/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import com.typesafe.config.Config;
import it.agilelab.bigdata.wasp.core.utils.ConfigManager$;
import java.io.File;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.spark.AndLogicExpression;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.EqualLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanLogicExpression;
import org.apache.hadoop.hbase.spark.GreaterThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.HBaseConnectionCache$;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRelation$;
import org.apache.hadoop.hbase.spark.IsNullLogicExpression;
import org.apache.hadoop.hbase.spark.LatestHBaseContextCache$;
import org.apache.hadoop.hbase.spark.LessThanLogicExpression;
import org.apache.hadoop.hbase.spark.LessThanOrEqualLogicExpression;
import org.apache.hadoop.hbase.spark.OrLogicExpression;
import org.apache.hadoop.hbase.spark.PassThroughLogicExpression;
import org.apache.hadoop.hbase.spark.PutConverterFactory;
import org.apache.hadoop.hbase.spark.PutConverterFactory$;
import org.apache.hadoop.hbase.spark.RowKeyFilter;
import org.apache.hadoop.hbase.spark.RowKeyFilter$;
import org.apache.hadoop.hbase.spark.ScanRange;
import org.apache.hadoop.hbase.spark.SmartConnection;
import org.apache.hadoop.hbase.spark.datasources.BoundRange;
import org.apache.hadoop.hbase.spark.datasources.BoundRanges;
import org.apache.hadoop.hbase.spark.datasources.BytesEncoder;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.hadoop.hbase.spark.datasources.HBaseTableScanRDD;
import org.apache.hadoop.hbase.spark.datasources.JavaBytesEncoder$;
import org.apache.hadoop.hbase.spark.datasources.SerializableConfiguration;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog$;
import org.apache.spark.sql.datasources.hbase.Utils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@InterfaceAudience.Private
@ScalaSignature(bytes="\u0006\u0001\rUg\u0001B\u0001\u0003\u00016\u0011Q\u0002\u0013\"bg\u0016\u0014V\r\\1uS>t'BA\u0002\u0005\u0003\u0015\u0019\b/\u0019:l\u0015\t)a!A\u0003iE\u0006\u001cXM\u0003\u0002\b\u0011\u00051\u0001.\u00193p_BT!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0002\u0001\u000f/ii2%\u000b\t\u0003\u001fUi\u0011\u0001\u0005\u0006\u0003#I\tqa]8ve\u000e,7O\u0003\u0002\u0014)\u0005\u00191/\u001d7\u000b\u0005\rA\u0011B\u0001\f\u0011\u00051\u0011\u0015m]3SK2\fG/[8o!\ty\u0001$\u0003\u0002\u001a!\t\u0011\u0002K];oK\u00124\u0015\u000e\u001c;fe\u0016$7kY1o!\ty1$\u0003\u0002\u001d!\t\u0011\u0012J\\:feR\f'\r\\3SK2\fG/[8o!\tq\u0012%D\u0001 \u0015\t\u0001C#\u0001\u0005j]R,'O\\1m\u0013\t\u0011sDA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\u000fA\u0013x\u000eZ;diB\u0011AEK\u0005\u0003W\u0015\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\f\u0001\u0003\u0016\u0004%\tAL\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cX#A\u0018\u0011\tA\u001adG\u000e\b\u0003IEJ!AM\u0013\u0002\rA\u0013X\rZ3g\u0013\t!TGA\u0002NCBT!AM\u0013\u0011\u0005A:\u0014B\u0001\u001d6\u0005\u0019\u0019FO]5oO\"A!\b\u0001B\tB\u0003%q&A\u0006qCJ\fW.\u001a;feN\u0004\u0003FA\u001d=!\t!S(\u0003\u0002?K\tIAO]1og&,g\u000e\u001e\u0005\t\u0001\u0002\u0011)\u001a!C\u0001\u0003\u0006\u0019Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nCV\t!\tE\u0002%\u0007\u0016K!\u0001R\u0013\u0003\r=\u0003H/[8o!\t1\u0015*D\u0001H\u0015\tA%#A\u0003usB,7/\u0003\u0002K\u000f\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u00111\u0003!\u0011#Q\u0001\n\t\u000bA#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004\u0003\u0002\u0003(\u0001\u0005\u000b\u0007I\u0011A(\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001Q!\t\t&+D\u0001\u0013\u0013\t\u0019&C\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\fgFd7i\u001c8uKb$\b\u0005\u000b\u0002Uy!)\u0001\f\u0001C\u00013\u00061A(\u001b8jiz\"2A\u00170`)\tYV\f\u0005\u0002]\u00015\t!\u0001C\u0003O/\u0002\u0007\u0001\u000bC\u0003./\u0002\u0007q\u0006C\u0003A/\u0002\u0007!\tC\u0004b\u0001\t\u0007I\u0011\u00012\u0002\u0013QLW.Z:uC6\u0004X#A2\u0011\u0007\u0011\u001aE\r\u0005\u0002%K&\u0011a-\n\u0002\u0005\u0019>tw\r\u0003\u0004i\u0001\u0001\u0006IaY\u0001\u000bi&lWm\u001d;b[B\u0004\u0003b\u00026\u0001\u0005\u0004%\tAY\u0001\r[&tG+[7fgR\fW\u000e\u001d\u0005\u0007Y\u0002\u0001\u000b\u0011B2\u0002\u001b5Lg\u000eV5nKN$\u0018-\u001c9!\u0011\u001dq\u0007A1A\u0005\u0002\t\fA\"\\1y)&lWm\u001d;b[BDa\u0001\u001d\u0001!\u0002\u0013\u0019\u0017!D7bqRKW.Z:uC6\u0004\b\u0005C\u0004s\u0001\t\u0007I\u0011A:\u0002\u00175\f\u0007PV3sg&|gn]\u000b\u0002iB\u0019AeQ;\u0011\u0005\u00112\u0018BA<&\u0005\rIe\u000e\u001e\u0005\u0007s\u0002\u0001\u000b\u0011\u0002;\u0002\u00195\f\u0007PV3sg&|gn\u001d\u0011\t\u000fm\u0004!\u0019!C\u0001y\u0006qQM\\2pI\u0016\u00148\t\\:OC6,W#\u0001\u001c\t\ry\u0004\u0001\u0015!\u00037\u0003=)gnY8eKJ\u001cEn\u001d(b[\u0016\u0004\u0003\"CA\u0001\u0001\t\u0007I\u0011AA\u0002\u0003\u001d)gnY8eKJ,\"!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\u0003\u0003-!\u0017\r^1t_V\u00148-Z:\n\t\u0005=\u0011\u0011\u0002\u0002\r\u0005f$Xm]#oG>$WM\u001d\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u0006\u0005AQM\\2pI\u0016\u0014\b\u0005K\u0002\u0002\u0012qB\u0011\"!\u0007\u0001\u0005\u0004%\t!a\u0007\u0002\u000f\r\fG/\u00197pOV\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019Q!a\t\u000b\u0007\u0005-!#\u0003\u0003\u0002(\u0005\u0005\"!\u0005%CCN,G+\u00192mK\u000e\u000bG/\u00197pO\"A\u00111\u0006\u0001!\u0002\u0013\ti\"\u0001\u0005dCR\fGn\\4!\u0011%\ty\u0003\u0001b\u0001\n\u0003\t\t$\u0001\u000bvg\u0016\u001c6\r[3nC\u00063(o\\'b]\u0006<WM]\u000b\u0003\u0003g\u00012\u0001JA\u001b\u0013\r\t9$\n\u0002\b\u0005>|G.Z1o\u0011!\tY\u0004\u0001Q\u0001\n\u0005M\u0012!F;tKN\u001b\u0007.Z7b\u0003Z\u0014x.T1oC\u001e,'\u000f\t\u0005\n\u0003\u007f\u0001!\u0019!C\u0001\u0003\u0003\n!\u0002Z1so&t7i\u001c8g+\t\t\u0019\u0005\u0005\u0003%\u0007\u0006\u0015\u0003\u0003BA$\u0003+j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0007G>tg-[4\u000b\t\u0005=\u0013\u0011K\u0001\tif\u0004Xm]1gK*\u0011\u00111K\u0001\u0004G>l\u0017\u0002BA,\u0003\u0013\u0012aaQ8oM&<\u0007\u0002CA.\u0001\u0001\u0006I!a\u0011\u0002\u0017\u0011\f'o^5o\u0007>tg\r\t\u0005\u0007\u0003?\u0002A\u0011\u0001?\u0002\u0013Q\f'\r\\3OC6,\u0007\u0002CA2\u0001\t\u0007I\u0011\u0001?\u0002\u001f\r|gNZ5h%\u0016\u001cx.\u001e:dKNDq!a\u001a\u0001A\u0003%a'\u0001\td_:4\u0017n\u001a*fg>,(oY3tA!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0011\u0011G\u0001\u0010kN,\u0007JQ1tK\u000e{g\u000e^3yi\"A\u0011q\u000e\u0001!\u0002\u0013\t\u0019$\u0001\tvg\u0016D%)Y:f\u0007>tG/\u001a=uA!I\u00111\u000f\u0001C\u0002\u0013\u0005\u0011\u0011G\u0001\u0018kN,\u0007+^:i\t><hnQ8mk6tg)\u001b7uKJD\u0001\"a\u001e\u0001A\u0003%\u00111G\u0001\u0019kN,\u0007+^:i\t><hnQ8mk6tg)\u001b7uKJ\u0004\u0003\"CA>\u0001\t\u0007I\u0011AA\u0019\u0003A\u0011Gn\\2l\u0007\u0006\u001c\u0007.Z#oC\ndW\r\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0011BA\u001a\u0003E\u0011Gn\\2l\u0007\u0006\u001c\u0007.Z#oC\ndW\r\t\u0005\n\u0003\u0007\u0003!\u0019!C\u0001\u0003\u000b\u000b\u0011bY1dQ\u0016\u001c\u0016N_3\u0016\u0003UDq!!#\u0001A\u0003%Q/\u0001\u0006dC\u000eDWmU5{K\u0002B\u0011\"!$\u0001\u0005\u0004%\t!!\"\u0002\u0011\t\fGo\u00195Ok6Dq!!%\u0001A\u0003%Q/A\u0005cCR\u001c\u0007NT;nA!I\u0011Q\u0013\u0001C\u0002\u0013\u0005\u0011QQ\u0001\fEVd7nR3u'&TX\rC\u0004\u0002\u001a\u0002\u0001\u000b\u0011B;\u0002\u0019\t,Hn[$fiNK'0\u001a\u0011\t\u0013\u0005u\u0005A1A\u0005\u0002\u0005}\u0015AF2mkN$XM]5oO\u000e37i\u001c7v[:\u001cX*\u00199\u0016\u0005\u0005\u0005\u0006#\u0002\u00194m\u0005\r\u0006#BAS\u0003k3d\u0002BAT\u0003csA!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[c\u0011A\u0002\u001fs_>$h(C\u0001'\u0013\r\t\u0019,J\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9,!/\u0003\u0007M+\u0017OC\u0002\u00024\u0016B\u0001\"!0\u0001A\u0003%\u0011\u0011U\u0001\u0018G2,8\u000f^3sS:<7IZ\"pYVlgn]'ba\u0002B\u0011\"!1\u0001\u0005\u0004%\t!a1\u0002\u0019!\u0014\u0017m]3D_:$X\r\u001f;\u0016\u0005\u0005\u0015\u0007c\u0001/\u0002H&\u0019\u0011\u0011\u001a\u0002\u0003\u0019!\u0013\u0015m]3D_:$X\r\u001f;\t\u0011\u00055\u0007\u0001)A\u0005\u0003\u000b\fQ\u0002\u001b2bg\u0016\u001cuN\u001c;fqR\u0004\u0003\"CAi\u0001\t\u0007I\u0011AAj\u0003-9(/\u00199qK\u0012\u001cuN\u001c4\u0016\u0005\u0005U\u0007\u0003BA\u0004\u0003/LA!!7\u0002\n\tI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0011!\ti\u000e\u0001Q\u0001\n\u0005U\u0017\u0001D<sCB\u0004X\rZ\"p]\u001a\u0004\u0003bBAq\u0001\u0011\u0005\u00111]\u0001\nQ\n\f7/Z\"p]\u001a,\"!!:\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;\u0007\u0003\u0011\u0019wN\u001c4\n\t\u0005=\u0018\u0011\u001e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0013\u0005M\bA1A\u0005B\u0005U\u0018AB:dQ\u0016l\u0017-F\u0001F\u0011\u001d\tI\u0010\u0001Q\u0001\n\u0015\u000bqa]2iK6\f\u0007\u0005C\u0004\u0002~\u0002!\t!a@\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0003\u0005\u0003\u00012\u0001\nB\u0002\u0013\r\u0011)!\n\u0002\u0005+:LG\u000fC\u0004\u0003\n\u0001!\tAa\u0003\u00023\r\u0014X-\u0019;f\u001d\u0006lWm\u001d9bG\u0016LeMT8u\u000bbL7\u000f\u001e\u000b\u0007\u0003g\u0011iA!\b\t\u0011\t=!q\u0001a\u0001\u0005#\t!bY8o]\u0016\u001cG/[8o!\u0011\u0011\u0019B!\u0007\u000e\u0005\tU!b\u0001B\f\t\u000511\r\\5f]RLAAa\u0007\u0003\u0016\t)\u0011\tZ7j]\"9!q\u0004B\u0004\u0001\u00041\u0014!\u00038b[\u0016\u001c\b/Y2f\u0011\u001d\u0011\u0019\u0003\u0001C!\u0005K\ta!\u001b8tKJ$HC\u0002B\u0001\u0005O\u00119\u0005\u0003\u0005\u0003*\t\u0005\u0002\u0019\u0001B\u0016\u0003\u0011!\u0017\r^1\u0011\t\t5\"\u0011\t\b\u0005\u0005_\u0011yD\u0004\u0003\u00032\tub\u0002\u0002B\u001a\u0005wqAA!\u000e\u0003:9!\u0011\u0011\u0016B\u001c\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t\u0019\u0001\"\u0003\u0002\u0014)%\u0019\u00111\u0017\n\n\t\t\r#Q\t\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a-\u0013\u0011!\u0011IE!\tA\u0002\u0005M\u0012!C8wKJ<(/\u001b;f\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001f\nQcZ3u\u0013:$W\r_3e!J|'.Z2uS>t7\u000f\u0006\u0003\u0003R\t}\u0003CBAS\u0003k\u0013\u0019\u0006\u0005\u0004%\u0005+\u0012I&^\u0005\u0004\u0005/*#A\u0002+va2,'\u0007\u0005\u0003\u0002 \tm\u0013\u0002\u0002B/\u0003C\u0011QAR5fY\u0012D\u0001B!\u0019\u0003L\u0001\u0007!1M\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB!AE!\u001a7\u0013\r\u00119'\n\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0005W\u0002A\u0011\u0001B7\u0003-\u0001\u0018M]:f%><8*Z=\u0015\r\t=$q\u000fBB!\u0019\u00014G!\u0017\u0003rA\u0019AEa\u001d\n\u0007\tUTEA\u0002B]fD\u0001B!\u001f\u0003j\u0001\u0007!1P\u0001\u0004e><\b#\u0002\u0013\u0003f\tu\u0004c\u0001\u0013\u0003\u0000%\u0019!\u0011Q\u0013\u0003\t\tKH/\u001a\u0005\t\u0005\u000b\u0013I\u00071\u0001\u0003\b\u0006I1.Z=GS\u0016dGm\u001d\t\u0007\u0003K\u000b)L!\u0017\t\u000f\t-\u0005\u0001\"\u0001\u0003\u000e\u0006A!-^5mIJ{w\u000f\u0006\u0004\u0003\u0010\nU%\u0011\u0014\t\u0004#\nE\u0015b\u0001BJ%\t\u0019!k\\<\t\u0011\t]%\u0011\u0012a\u0001\u0005\u000f\u000baAZ5fY\u0012\u001c\b\u0002\u0003BN\u0005\u0013\u0003\rA!(\u0002\rI,7/\u001e7u!\u0011\u0011\u0019Ba(\n\t\t\u0005&Q\u0003\u0002\u0007%\u0016\u001cX\u000f\u001c;\t\u000f\t\u0015\u0006\u0001\"\u0011\u0003(\u0006I!-^5mIN\u001b\u0017M\u001c\u000b\u0007\u0005S\u0013)La.\u0011\r\t-&\u0011\u0017BH\u001b\t\u0011iKC\u0002\u00030R\t1A\u001d3e\u0013\u0011\u0011\u0019L!,\u0003\u0007I#E\t\u0003\u0005\u0003b\t\r\u0006\u0019\u0001B2\u0011!\u0011ILa)A\u0002\tm\u0016a\u00024jYR,'o\u001d\t\u0006I\t\u0015$Q\u0018\t\u0004\u001f\t}\u0016b\u0001Ba!\t1a)\u001b7uKJDqA!2\u0001\t\u0003\u00119-A\u0010ck&dG\rU;tQ\u0012{wO\u001c)sK\u0012L7-\u0019;fgJ+7o\\;sG\u0016$BA!3\u0003^BIAEa3\u0003P\nU'1\\\u0005\u0004\u0005\u001b,#A\u0002+va2,7\u0007E\u0002]\u0005#L1Aa5\u0003\u00051\u0011vn^&fs\u001aKG\u000e^3s!\ra&q[\u0005\u0004\u00053\u0014!A\u0006#z]\u0006l\u0017n\u0019'pO&\u001cW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u000b\u0011\u0012)Ga\u001f\t\u0011\te&1\u0019a\u0001\u0005wCqA!9\u0001\t\u0003\u0011\u0019/\u0001\u000bue\u0006t7O^3sg\u00164\u0015\u000e\u001c;feR\u0013X-\u001a\u000b\t\u0005+\u0014)O!;\u0003~\"A!q\u001dBp\u0001\u0004\u0011y-\u0001\nqCJ,g\u000e\u001e*po.+\u0017PR5mi\u0016\u0014\b\u0002\u0003Bv\u0005?\u0004\rA!<\u0002\u0015Y\fG.^3BeJ\f\u0017\u0010\u0005\u0004\u0003p\ne(1P\u0007\u0003\u0005cTAAa=\u0003v\u00069Q.\u001e;bE2,'b\u0001B|K\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm(\u0011\u001f\u0002\f\u001bV$\u0018M\u00197f\u0019&\u001cH\u000f\u0003\u0005\u0003\u0000\n}\u0007\u0019\u0001B_\u0003\u00191\u0017\u000e\u001c;fe\"I11\u0001\u0001\u0002\u0002\u0013\u00051QA\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0004\b\r-1Q\u0002\u000b\u00047\u000e%\u0001B\u0002(\u0004\u0002\u0001\u0007\u0001\u000b\u0003\u0005.\u0007\u0003\u0001\n\u00111\u00010\u0011!\u00015\u0011\u0001I\u0001\u0002\u0004\u0011\u0005\"CB\t\u0001E\u0005I\u0011AB\n\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0006+\u0007=\u001a9b\u000b\u0002\u0004\u001aA!11DB\u0013\u001b\t\u0019iB\u0003\u0003\u0004 \r\u0005\u0012!C;oG\",7m[3e\u0015\r\u0019\u0019#J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0014\u0007;\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019Y\u0003AI\u0001\n\u0003\u0019i#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r=\"f\u0001\"\u0004\u0018!I11\u0007\u0001\u0002\u0002\u0013\u00053QG\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r]\u0002\u0003BB\u001d\u0007\u0007j!aa\u000f\u000b\t\ru2qH\u0001\u0005Y\u0006twM\u0003\u0002\u0004B\u0005!!.\u0019<b\u0013\rA41\b\u0005\n\u0007\u000f\u0002\u0011\u0011!C\u0001\u0003\u000b\u000bA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011ba\u0013\u0001\u0003\u0003%\ta!\u0014\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011OB(\u0011%\u0019\tf!\u0013\u0002\u0002\u0003\u0007Q/A\u0002yIEB\u0011b!\u0016\u0001\u0003\u0003%\tea\u0016\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0017\u0011\r\rm3Q\fB9\u001b\t\u0011)0\u0003\u0003\u0004`\tU(\u0001C%uKJ\fGo\u001c:\t\u0013\r\r\u0004!!A\u0005\u0002\r\u0015\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M2q\r\u0005\u000b\u0007#\u001a\t'!AA\u0002\tE\u0004\"CB6\u0001\u0005\u0005I\u0011IB7\u0003!A\u0017m\u001d5D_\u0012,G#A;\t\u0013\rE\u0004!!A\u0005B\rM\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r]\u0002\"CB<\u0001\u0005\u0005I\u0011IB=\u0003\u0019)\u0017/^1mgR!\u00111GB>\u0011)\u0019\tf!\u001e\u0002\u0002\u0003\u0007!\u0011\u000f\u0015\u0004\u0001\r}\u0004\u0003BBA\u0007\u001bsAaa!\u0004\n6\u00111Q\u0011\u0006\u0004\u0007\u000f3\u0011AD2mCN\u001c\u0018NZ5dCRLwN\\\u0005\u0005\u0007\u0017\u001b))A\tJ]R,'OZ1dK\u0006+H-[3oG\u0016LAaa$\u0004\u0012\n9\u0001K]5wCR,'\u0002BBF\u0007\u000b;\u0011b!&\u0003\u0003\u0003E\taa&\u0002\u001b!\u0013\u0015m]3SK2\fG/[8o!\ra6\u0011\u0014\u0004\t\u0003\t\t\t\u0011#\u0001\u0004\u001cN)1\u0011TBOSA\u0019Aea(\n\u0007\r\u0005VE\u0001\u0004B]f\u0014VM\u001a\u0005\b1\u000eeE\u0011ABS)\t\u00199\n\u0003\u0006\u0004r\re\u0015\u0011!C#\u0007gB!ba+\u0004\u001a\u0006\u0005I\u0011QBW\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0019yk!.\u0004:R\u00191l!-\t\r9\u001bI\u000b1\u0001QQ\r\u0019\t\f\u0010\u0005\u0007[\r%\u0006\u0019A\u0018)\u0007\rUF\b\u0003\u0004A\u0007S\u0003\rA\u0011\u0005\u000b\u0007{\u001bI*!A\u0005\u0002\u000e}\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u0003\u001c)\r\u0005\u0003%\u0007\u000e\r\u0007#\u0002\u0013\u0003V=\u0012\u0005\"CBd\u0007w\u000b\t\u00111\u0001\\\u0003\rAH\u0005\r\u0005\u000b\u0007\u0017\u001cI*!A\u0005\n\r5\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa4\u0011\t\re2\u0011[\u0005\u0005\u0007'\u001cYD\u0001\u0004PE*,7\r\u001e")
public class HBaseRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
Logging,
Product,
Serializable {
    private final transient Map<String, String> parameters;
    private final Option<StructType> userSpecifiedSchema;
    private final transient SQLContext sqlContext;
    private final Option<Object> timestamp;
    private final Option<Object> minTimestamp;
    private final Option<Object> maxTimestamp;
    private final Option<Object> maxVersions;
    private final String encoderClsName;
    private final transient BytesEncoder encoder;
    private final HBaseTableCatalog catalog;
    private final boolean useSchemaAvroManager;
    private final Option<Config> darwinConf;
    private final String configResources;
    private final boolean useHBaseContext;
    private final boolean usePushDownColumnFilter;
    private final boolean blockCacheEnable;
    private final int cacheSize;
    private final int batchNum;
    private final int bulkGetSize;
    private final Map<String, Seq<String>> clusteringCfColumnsMap;
    private final HBaseContext hbaseContext;
    private final SerializableConfiguration wrappedConf;
    private final StructType schema;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Tuple2<Map<String, String>, Option<StructType>>> unapply(HBaseRelation hBaseRelation) {
        return HBaseRelation$.MODULE$.unapply(hBaseRelation);
    }

    public static HBaseRelation apply(Map<String, String> map, Option<StructType> option, SQLContext sQLContext) {
        return HBaseRelation$.MODULE$.apply(map, option, sQLContext);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Option<Object> timestamp() {
        return this.timestamp;
    }

    public Option<Object> minTimestamp() {
        return this.minTimestamp;
    }

    public Option<Object> maxTimestamp() {
        return this.maxTimestamp;
    }

    public Option<Object> maxVersions() {
        return this.maxVersions;
    }

    public String encoderClsName() {
        return this.encoderClsName;
    }

    public BytesEncoder encoder() {
        return this.encoder;
    }

    public HBaseTableCatalog catalog() {
        return this.catalog;
    }

    public boolean useSchemaAvroManager() {
        return this.useSchemaAvroManager;
    }

    public Option<Config> darwinConf() {
        return this.darwinConf;
    }

    public String tableName() {
        return new StringBuilder().append((Object)this.catalog().namespace()).append((Object)":").append((Object)this.catalog().name()).toString();
    }

    public String configResources() {
        return this.configResources;
    }

    public boolean useHBaseContext() {
        return this.useHBaseContext;
    }

    public boolean usePushDownColumnFilter() {
        return this.usePushDownColumnFilter;
    }

    public boolean blockCacheEnable() {
        return this.blockCacheEnable;
    }

    public int cacheSize() {
        return this.cacheSize;
    }

    public int batchNum() {
        return this.batchNum;
    }

    public int bulkGetSize() {
        return this.bulkGetSize;
    }

    public Map<String, Seq<String>> clusteringCfColumnsMap() {
        return this.clusteringCfColumnsMap;
    }

    public HBaseContext hbaseContext() {
        return this.hbaseContext;
    }

    public SerializableConfiguration wrappedConf() {
        return this.wrappedConf;
    }

    public Configuration hbaseConf() {
        return this.wrappedConf().value();
    }

    public StructType schema() {
        return this.schema;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createTable() {
        int numReg = BoxesRunTime.unboxToInt((Object)this.parameters().get((Object)HBaseTableCatalog$.MODULE$.newTable()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x) {
                return new StringOps(Predef$.MODULE$.augmentString(x)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
        byte[] startKey = Bytes.toBytes((String)((String)this.parameters().getOrElse((Object)HBaseTableCatalog$.MODULE$.regionStart(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseTableCatalog$.MODULE$.defaultRegionStart();
            }
        })));
        byte[] endKey = Bytes.toBytes((String)((String)this.parameters().getOrElse((Object)HBaseTableCatalog$.MODULE$.regionEnd(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseTableCatalog$.MODULE$.defaultRegionEnd();
            }
        })));
        if (numReg <= 3) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\n           |is not defined or no larger than 3, skip the create table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HBaseTableCatalog$.MODULE$.newTable()})))).stripMargin();
                }
            });
            return;
        }
        TableName tName = TableName.valueOf((String)this.catalog().namespace(), (String)this.catalog().name());
        Seq<String> cfs = this.catalog().getColumnFamilies();
        SmartConnection connection = HBaseConnectionCache$.MODULE$.getConnection(this.hbaseConf());
        Admin admin = connection.getAdmin();
        try {
            if (!this.createNamespaceIfNotExist(admin, this.catalog().namespace())) {
                admin.createNamespace(NamespaceDescriptor.create((String)this.catalog().namespace()).build());
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseRelation $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create namespace ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.catalog().namespace()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if (!admin.isTableAvailable(tName)) {
                TableDescriptorBuilder tableDesc = TableDescriptorBuilder.newBuilder((TableName)tName);
                cfs.foreach((Function1)new Serializable(this, tableDesc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseRelation $outer;
                    private final TableDescriptorBuilder tableDesc$1;

                    public final TableDescriptorBuilder apply(String x) {
                        ColumnFamilyDescriptorBuilder cf = ColumnFamilyDescriptorBuilder.newBuilder((byte[])x.getBytes());
                        this.$outer.logDebug((Function0<String>)new Serializable(this, x){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$createTable$2 $outer;
                            private final String x$27;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add family ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x$27, this.$outer.org$apache$hadoop$hbase$spark$HBaseRelation$$anonfun$$$outer().tableName()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.x$27 = x$27;
                            }
                        });
                        return this.tableDesc$1.setColumnFamily(cf.build());
                    }

                    public /* synthetic */ HBaseRelation org$apache$hadoop$hbase$spark$HBaseRelation$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tableDesc$1 = tableDesc$1;
                    }
                });
                byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)numReg);
                admin.createTable(tableDesc.build(), splitKeys);
            }
        }
        catch (Throwable throwable) {
            void var6_6;
            void var7_7;
            var7_7.close();
            var6_6.close();
            throw throwable;
        }
        admin.close();
        connection.close();
    }

    public boolean createNamespaceIfNotExist(Admin connection, String namespace) {
        boolean bl;
        try {
            bl = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])connection.listNamespaceDescriptors()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(NamespaceDescriptor x$12) {
                    return x$12.getName();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).contains((Object)namespace);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        JobConf jobConfig = new JobConf(this.hbaseConf(), ((Object)((Object)this)).getClass());
        jobConfig.setOutputFormat(TableOutputFormat.class);
        jobConfig.set("hbase.mapred.outputtable", this.tableName());
        Dataset<Row> df = PutConverterFactory$.MODULE$.convertAvroColumns(this.parameters(), data);
        PutConverterFactory putConverterFactory = PutConverterFactory$.MODULE$.apply(this.parameters(), df);
        Serializable convertToPut2 = new Serializable(this, putConverterFactory){
            public static final long serialVersionUID = 0L;
            private final PutConverterFactory putConverterFactory$1;

            public final Tuple2<ImmutableBytesWritable, Put> apply(InternalRow row) {
                return new Tuple2((Object)new ImmutableBytesWritable(), (Object)this.putConverterFactory$1.convertToPut(row));
            }
            {
                this.putConverterFactory$1 = putConverterFactory$1;
            }
        };
        QueryExecution queryExecution = df.queryExecution();
        SQLExecution$.MODULE$.withNewExecutionId(data.sparkSession(), queryExecution, (Function0)new Serializable(this, jobConfig, (Function1)convertToPut2, queryExecution){
            public static final long serialVersionUID = 0L;
            private final JobConf jobConfig$1;
            private final Function1 convertToPut$1;
            private final QueryExecution queryExecution$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD$.MODULE$.rddToPairRDDFunctions(this.queryExecution$1.toRdd().map(this.convertToPut$1, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ImmutableBytesWritable.class), ClassTag$.MODULE$.apply(Put.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).saveAsHadoopDataset(this.jobConfig$1);
            }
            {
                this.jobConfig$1 = jobConfig$1;
                this.convertToPut$1 = convertToPut$1;
                this.queryExecution$1 = queryExecution$1;
            }
        });
    }

    public Seq<Tuple2<Field, Object>> getIndexedProjections(String[] requiredColumns) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final Field apply(String x$13) {
                return this.$outer.catalog().sMap().getField(x$13);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class)))).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Map<Field, Object> parseRowKey(byte[] row, Seq<Field> keyFields) {
        return ((TraversableOnce)((Tuple2)keyFields.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(this, row){
            public static final long serialVersionUID = 0L;
            private final byte[] row$1;

            public final Tuple2<Object, Seq<Tuple2<Field, Object>>> apply(Tuple2<Object, Seq<Tuple2<Field, Object>>> state, Field field) {
                Tuple2 tuple2;
                int idx = state._1$mcI$sp();
                Seq parsed = (Seq)state._2();
                if (field.length() != -1) {
                    Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$1, idx, field.length());
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(idx + field.length())), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                } else {
                    Tuple2 tuple22;
                    DataType dataType = field.dt();
                    if (StringType$.MODULE$.equals(dataType)) {
                        Tuple2 tuple23;
                        int pos = Predef$.MODULE$.byteArrayOps(this.row$1).indexOf((Object)BoxesRunTime.boxToByte((byte)HBaseTableCatalog$.MODULE$.delimiter()), idx);
                        if (pos == -1 || pos > this.row$1.length) {
                            Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$1, idx, this.row$1.length);
                            tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.row$1.length + 1)), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                        } else {
                            Object value = Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$1, idx, pos - idx);
                            tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)pos), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, value)})), Seq$.MODULE$.canBuildFrom()));
                        }
                        tuple22 = tuple23;
                    } else {
                        tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)(this.row$1.length + 1)), parsed.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)field, Utils$.MODULE$.hbaseFieldToScalaType(field, this.row$1, idx, this.row$1.length))})), Seq$.MODULE$.canBuildFrom()));
                    }
                    tuple2 = tuple22;
                }
                return tuple2;
            }
            {
                this.row$1 = row$1;
            }
        }))._2()).toMap(Predef$.MODULE$.$conforms());
    }

    public Row buildRow(Seq<Field> fields, Result result) {
        byte[] r = result.getRow();
        Map<Field, Object> keySeq = this.parseRowKey(r, this.catalog().getRowKey());
        Map valueSeq = ((TraversableOnce)((TraversableLike)fields.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Field f) {
                return !f.isRowKey();
            }
        })).map((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final Result result$1;

            public final Tuple2<Field, Object> apply(Field x) {
                Tuple2 tuple2;
                Cell kv = this.result$1.getColumnLatestCell(Bytes.toBytes((String)x.cf()), Bytes.toBytes((String)x.col()));
                if (kv == null || kv.getValueLength() == 0) {
                    tuple2 = new Tuple2((Object)x, null);
                } else {
                    byte[] v = CellUtil.cloneValue((Cell)kv);
                    DataType dataType = x.dt();
                    Object object = BinaryType$.MODULE$.equals(dataType) ? v : (Object)Utils$.MODULE$.hbaseFieldToScalaType(x, v, 0, v.length);
                    Tuple2 tuple22 = new Tuple2((Object)x, object);
                    tuple2 = tuple22;
                }
                return tuple2;
            }
            {
                this.result$1 = result$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map unionedRow = keySeq.$plus$plus((GenTraversableOnce)valueSeq);
        return Row$.MODULE$.fromSeq((Seq)fields.map((Function1)new Serializable(this, unionedRow){
            public static final long serialVersionUID = 0L;
            private final Map unionedRow$1;

            public final Object apply(Field x$14) {
                return this.unionedRow$1.get((Object)x$14).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            {
                this.unionedRow$1 = unionedRow$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        RDD resultRDD;
        Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> pushDownTuple = this.buildPushDownPredicatesResource(filters);
        RowKeyFilter pushDownRowKeyFilter = (RowKeyFilter)pushDownTuple._1();
        ObjectRef pushDownDynamicLogicExpression = ObjectRef.create((Object)((DynamicLogicExpression)pushDownTuple._2()));
        byte[][] valueArray = (byte[][])pushDownTuple._3();
        if (!this.usePushDownColumnFilter()) {
            pushDownDynamicLogicExpression.elem = null;
        }
        this.logDebug((Function0<String>)new Serializable(this, pushDownRowKeyFilter){
            public static final long serialVersionUID = 0L;
            private final RowKeyFilter pushDownRowKeyFilter$1;

            public final String apply() {
                return new StringBuilder().append((Object)"pushDownRowKeyFilter:           ").append(this.pushDownRowKeyFilter$1.ranges()).toString();
            }
            {
                this.pushDownRowKeyFilter$1 = pushDownRowKeyFilter$1;
            }
        });
        if ((DynamicLogicExpression)pushDownDynamicLogicExpression.elem != null) {
            this.logDebug((Function0<String>)new Serializable(this, pushDownDynamicLogicExpression){
                public static final long serialVersionUID = 0L;
                private final ObjectRef pushDownDynamicLogicExpression$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"pushDownDynamicLogicExpression: ").append((Object)((DynamicLogicExpression)this.pushDownDynamicLogicExpression$1.elem).toExpressionString()).toString();
                }
                {
                    this.pushDownDynamicLogicExpression$1 = pushDownDynamicLogicExpression$1;
                }
            });
        }
        this.logDebug((Function0<String>)new Serializable(this, valueArray){
            public static final long serialVersionUID = 0L;
            private final byte[][] valueArray$1;

            public final String apply() {
                return new StringBuilder().append((Object)"valueArray:                     ").append((Object)BoxesRunTime.boxToInteger((int)this.valueArray$1.length)).toString();
            }
            {
                this.valueArray$1 = valueArray$1;
            }
        });
        MutableList requiredQualifierDefinitionList = new MutableList();
        Predef$.MODULE$.refArrayOps((Object[])requiredColumns).foreach((Function1)new Serializable(this, requiredQualifierDefinitionList){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final MutableList requiredQualifierDefinitionList$1;

            public final MutableList<Field> apply(String c) {
                Field field = this.$outer.catalog().getField(c);
                return this.requiredQualifierDefinitionList$1.$plus$eq((Object)field);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requiredQualifierDefinitionList$1 = requiredQualifierDefinitionList$1;
            }
        });
        DefaultSourceStaticUtils$.MODULE$.populateLatestExecutionRules(pushDownRowKeyFilter, (DynamicLogicExpression)pushDownDynamicLogicExpression.elem);
        ArrayList getList = new ArrayList();
        pushDownRowKeyFilter.points().foreach((Function1)new Serializable(this, requiredQualifierDefinitionList, getList){
            public static final long serialVersionUID = 0L;
            private final MutableList requiredQualifierDefinitionList$1;
            private final ArrayList getList$1;

            public final boolean apply(byte[] p) {
                Get get2 = new Get(p);
                this.requiredQualifierDefinitionList$1.foreach((Function1)new Serializable(this, get2){
                    public static final long serialVersionUID = 0L;
                    private final Get get$1;

                    public final Object apply(Field d) {
                        return d.isRowKey() ? this.get$1.addColumn(d.cfBytes(), d.colBytes()) : BoxedUnit.UNIT;
                    }
                    {
                        this.get$1 = get$1;
                    }
                });
                return this.getList$1.add(get2);
            }
            {
                this.requiredQualifierDefinitionList$1 = requiredQualifierDefinitionList$1;
                this.getList$1 = getList$1;
            }
        });
        HBaseTableScanRDD hRdd = new HBaseTableScanRDD(this, this.hbaseContext(), (Seq<Field>)requiredQualifierDefinitionList.seq());
        pushDownRowKeyFilter.points().foreach((Function1)new Serializable(this, hRdd){
            public static final long serialVersionUID = 0L;
            private final HBaseTableScanRDD hRdd$1;

            public final void apply(byte[] x$15) {
                this.hRdd$1.addPoint(x$15);
            }
            {
                this.hRdd$1 = hRdd$1;
            }
        });
        pushDownRowKeyFilter.ranges().foreach((Function1)new Serializable(this, hRdd){
            public static final long serialVersionUID = 0L;
            private final HBaseTableScanRDD hRdd$1;

            public final void apply(ScanRange x$16) {
                this.hRdd$1.addRange(x$16);
            }
            {
                this.hRdd$1 = hRdd$1;
            }
        });
        RDD tmp = hRdd.map((Function1)new Serializable(this, requiredColumns){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final String[] requiredColumns$1;

            public final Row apply(Result r) {
                Seq indexedFields = (Seq)this.$outer.getIndexedProjections(this.requiredColumns$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Field apply(Tuple2<Field, Object> x$17) {
                        return (Field)x$17._1();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return this.$outer.buildRow((Seq<Field>)indexedFields, r);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requiredColumns$1 = requiredColumns$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Object object = resultRDD = Predef$.MODULE$.refArrayOps((Object[])tmp.partitions()).size() > 0 ? tmp : null;
        if (resultRDD == null) {
            RDD rdd;
            Scan scan = new Scan();
            scan.setCacheBlocks(this.blockCacheEnable());
            scan.setBatch(this.batchNum());
            scan.setCaching(this.cacheSize());
            requiredQualifierDefinitionList.foreach((Function1)new Serializable(this, scan){
                public static final long serialVersionUID = 0L;
                private final Scan scan$1;

                public final Scan apply(Field d) {
                    return this.scan$1.addColumn(d.cfBytes(), d.colBytes());
                }
                {
                    this.scan$1 = scan$1;
                }
            });
            resultRDD = rdd = this.hbaseContext().hbaseRDD(TableName.valueOf((String)this.tableName()), scan).map((Function1)new Serializable(this, requiredColumns){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseRelation $outer;
                private final String[] requiredColumns$1;

                public final Row apply(Tuple2<ImmutableBytesWritable, Result> r) {
                    Seq indexedFields = (Seq)this.$outer.getIndexedProjections(this.requiredColumns$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Field apply(Tuple2<Field, Object> x$18) {
                            return (Field)x$18._1();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return this.$outer.buildRow((Seq<Field>)indexedFields, (Result)r._2());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requiredColumns$1 = requiredColumns$1;
                }
            }, ClassTag$.MODULE$.apply(Row.class));
        }
        return resultRDD;
    }

    public Tuple3<RowKeyFilter, DynamicLogicExpression, byte[][]> buildPushDownPredicatesResource(Filter[] filters) {
        ObjectRef superRowKeyFilter = ObjectRef.create(null);
        MutableList queryValueList = new MutableList();
        ObjectRef superDynamicLogicExpression = ObjectRef.create(null);
        Predef$.MODULE$.refArrayOps((Object[])filters).foreach((Function1)new Serializable(this, superRowKeyFilter, queryValueList, superDynamicLogicExpression){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;
            private final ObjectRef superRowKeyFilter$1;
            private final MutableList queryValueList$1;
            private final ObjectRef superDynamicLogicExpression$1;

            public final Object apply(Filter f) {
                Object object;
                RowKeyFilter rowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                DynamicLogicExpression logicExpression = this.$outer.transverseFilterTree(rowKeyFilter, (MutableList<byte[]>)this.queryValueList$1, f);
                if ((DynamicLogicExpression)this.superDynamicLogicExpression$1.elem == null) {
                    this.superDynamicLogicExpression$1.elem = logicExpression;
                    this.superRowKeyFilter$1.elem = rowKeyFilter;
                    object = BoxedUnit.UNIT;
                } else {
                    this.superDynamicLogicExpression$1.elem = new AndLogicExpression((DynamicLogicExpression)this.superDynamicLogicExpression$1.elem, logicExpression);
                    object = ((RowKeyFilter)this.superRowKeyFilter$1.elem).mergeIntersect(rowKeyFilter);
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.superRowKeyFilter$1 = superRowKeyFilter$1;
                this.queryValueList$1 = queryValueList$1;
                this.superDynamicLogicExpression$1 = superDynamicLogicExpression$1;
            }
        });
        byte[][] queryValueArray = (byte[][])queryValueList.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        if ((RowKeyFilter)superRowKeyFilter.elem == null) {
            superRowKeyFilter.elem = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
        }
        return new Tuple3((Object)((RowKeyFilter)superRowKeyFilter.elem), (Object)((DynamicLogicExpression)superDynamicLogicExpression.elem), (Object)queryValueArray);
    }

    public DynamicLogicExpression transverseFilterTree(RowKeyFilter parentRowKeyFilter, MutableList<byte[]> valueArray, Filter filter) {
        DynamicLogicExpression dynamicLogicExpression;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            BoxedUnit boxedUnit;
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Object object = field.isRowKey() ? parentRowKeyFilter.mergeIntersect(new RowKeyFilter(DefaultSourceStaticUtils$.MODULE$.getByteValue(field, value.toString()), null, RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4())) : BoxedUnit.UNIT;
                byte[] byteValue = DefaultSourceStaticUtils$.MODULE$.getByteValue(field, value.toString());
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new EqualLogicExpression(attr, valueArray.length() - 1, false);
        } else if (filter2 instanceof LessThan) {
            BoxedUnit boxedUnit;
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit2;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit2 = b.map((Function1)new Serializable(this, inc){
                        public static final long serialVersionUID = 0L;
                        public final BooleanRef inc$1;

                        public final RowKeyFilter[] apply(BoundRanges x$19) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$19.less()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$transverseFilterTree$1 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final RowKeyFilter apply(BoundRange x) {
                                    void var2_2;
                                    RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), this.$outer.inc$1.elem, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                    this.$outer.inc$1.elem = true;
                                    return var2_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                        {
                            this.inc$1 = inc$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$20) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$20);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new LessThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThan) {
            BoxedUnit boxedUnit;
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit3;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    BooleanRef inc = BooleanRef.create((boolean)false);
                    boxedUnit3 = b.map((Function1)new Serializable(this, inc){
                        public static final long serialVersionUID = 0L;
                        public final BooleanRef inc$2;

                        public final RowKeyFilter[] apply(BoundRanges x$21) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$21.greater()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$transverseFilterTree$4 $outer;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final RowKeyFilter apply(BoundRange x) {
                                    void var2_2;
                                    RowKeyFilter r = new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), this.$outer.inc$2.elem), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                    this.$outer.inc$2.elem = true;
                                    return var2_2;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                        {
                            this.inc$2 = inc$2;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$22) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$22);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new GreaterThanLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof LessThanOrEqual) {
            BoxedUnit boxedUnit;
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit4 = b.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter[] apply(BoundRanges x$23) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$23.less()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(BoundRange x) {
                                    return new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$24) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$24);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new LessThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            BoxedUnit boxedUnit;
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            Field field = this.catalog().getField(attr);
            if (field == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit5;
                if (field.isRowKey()) {
                    Option<BoundRanges> b = this.encoder().ranges(value);
                    boxedUnit5 = b.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter[] apply(BoundRanges x$25) {
                            return (RowKeyFilter[])Predef$.MODULE$.refArrayOps((Object[])x$25.greater()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(BoundRange x) {
                                    return new RowKeyFilter(null, new ScanRange(x.upper(), true, x.low(), true), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RowKeyFilter.class)));
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RowKeyFilter apply(RowKeyFilter[] x) {
                            return (RowKeyFilter)Predef$.MODULE$.refArrayOps((Object[])x).reduce((Function2)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final RowKeyFilter apply(RowKeyFilter i, RowKeyFilter j) {
                                    return i.mergeUnion(j);
                                }
                            });
                        }
                    }).map((Function1)new Serializable(this, parentRowKeyFilter){
                        public static final long serialVersionUID = 0L;
                        private final RowKeyFilter parentRowKeyFilter$1;

                        public final RowKeyFilter apply(RowKeyFilter x$26) {
                            return this.parentRowKeyFilter$1.mergeIntersect(x$26);
                        }
                        {
                            this.parentRowKeyFilter$1 = parentRowKeyFilter$1;
                        }
                    });
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                byte[] byteValue = this.encoder().encode(field.dt(), value);
                boxedUnit = valueArray.$plus$eq((Object)byteValue);
            }
            dynamicLogicExpression = new GreaterThanOrEqualLogicExpression(attr, valueArray.length() - 1);
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeUnion(rightSideRowKeyFilter);
            dynamicLogicExpression = new OrLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof And) {
            And and2 = (And)filter2;
            Filter left = and2.left();
            Filter right = and2.right();
            DynamicLogicExpression leftExpression = this.transverseFilterTree(parentRowKeyFilter, valueArray, left);
            RowKeyFilter rightSideRowKeyFilter = new RowKeyFilter(RowKeyFilter$.MODULE$.$lessinit$greater$default$1(), RowKeyFilter$.MODULE$.$lessinit$greater$default$2(), RowKeyFilter$.MODULE$.$lessinit$greater$default$3(), RowKeyFilter$.MODULE$.$lessinit$greater$default$4());
            DynamicLogicExpression rightExpression = this.transverseFilterTree(rightSideRowKeyFilter, valueArray, right);
            parentRowKeyFilter.mergeIntersect(rightSideRowKeyFilter);
            dynamicLogicExpression = new AndLogicExpression(leftExpression, rightExpression);
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, false);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            dynamicLogicExpression = new IsNullLogicExpression(attr, true);
        } else {
            dynamicLogicExpression = new PassThroughLogicExpression();
        }
        return dynamicLogicExpression;
    }

    public HBaseRelation copy(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        return new HBaseRelation(parameters, userSpecifiedSchema, sqlContext);
    }

    public Map<String, String> copy$default$1() {
        return this.parameters();
    }

    public Option<StructType> copy$default$2() {
        return this.userSpecifiedSchema();
    }

    public String productPrefix() {
        return "HBaseRelation";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<StructType> option;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                option = this.userSpecifiedSchema();
                break;
            }
            case 0: {
                option = this.parameters();
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HBaseRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HBaseRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        HBaseRelation hBaseRelation = (HBaseRelation)((Object)x$1);
        Map<String, String> map = this.parameters();
        Map<String, String> map2 = hBaseRelation.parameters();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<StructType> option = this.userSpecifiedSchema();
        Option<StructType> option2 = hBaseRelation.userSpecifiedSchema();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hBaseRelation.canEqual((Object)this)) return false;
        return true;
    }

    public HBaseRelation(Map<String, String> parameters, Option<StructType> userSpecifiedSchema, SQLContext sqlContext) {
        HBaseContext hBaseContext;
        this.parameters = parameters;
        this.userSpecifiedSchema = userSpecifiedSchema;
        this.sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        Product.class.$init$((Product)this);
        this.timestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMESTAMP()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
            }
        });
        this.minTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMERANGE_START()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
            }
        });
        this.maxTimestamp = parameters.get((Object)HBaseSparkConf$.MODULE$.TIMERANGE_END()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
            }
        });
        this.maxVersions = parameters.get((Object)HBaseSparkConf$.MODULE$.MAX_VERSIONS()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
            }
        });
        this.encoderClsName = (String)parameters.getOrElse((Object)HBaseSparkConf$.MODULE$.QUERY_ENCODER(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return HBaseSparkConf$.MODULE$.DEFAULT_QUERY_ENCODER();
            }
        });
        this.encoder = JavaBytesEncoder$.MODULE$.create(this.encoderClsName());
        this.catalog = HBaseTableCatalog$.MODULE$.apply(parameters);
        this.useSchemaAvroManager = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)"useAvroSchemaManager").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        this.darwinConf = this.useSchemaAvroManager() ? new Some((Object)ConfigManager$.MODULE$.getAvroSchemaManagerConfig()) : None$.MODULE$;
        this.configResources = (String)parameters.getOrElse((Object)HBaseSparkConf$.MODULE$.HBASE_CONFIG_LOCATION(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.useHBaseContext = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.USE_HBASECONTEXT()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return HBaseSparkConf$.MODULE$.DEFAULT_USE_HBASECONTEXT();
            }
        }));
        this.usePushDownColumnFilter = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.PUSHDOWN_COLUMN_FILTER()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return HBaseSparkConf$.MODULE$.DEFAULT_PUSHDOWN_COLUMN_FILTER();
            }
        }));
        this.blockCacheEnable = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_CACHEBLOCKS()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$8) {
                return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getBoolean(HBaseSparkConf$.MODULE$.QUERY_CACHEBLOCKS(), HBaseSparkConf$.MODULE$.DEFAULT_QUERY_CACHEBLOCKS());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.cacheSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_CACHEDROWS()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$9) {
                return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.QUERY_CACHEDROWS(), -1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.batchNum = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.QUERY_BATCHSIZE()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.QUERY_BATCHSIZE(), -1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.bulkGetSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)HBaseSparkConf$.MODULE$.BULKGET_SIZE()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$11) {
                return new StringOps(Predef$.MODULE$.augmentString(x$11)).toInt();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.sqlContext().sparkContext().getConf().getInt(HBaseSparkConf$.MODULE$.BULKGET_SIZE(), HBaseSparkConf$.MODULE$.DEFAULT_BULKGET_SIZE());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.clusteringCfColumnsMap = this.catalog().clusteringMap();
        if (this.useHBaseContext()) {
            hBaseContext = LatestHBaseContextCache$.MODULE$.latest();
        } else {
            Configuration config = HBaseConfiguration.create();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.configResources().split(",")).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String r) {
                    String string = r;
                    String string2 = "";
                    return (string == null ? string2 != null : !string.equals(string2)) && new File(r).exists();
                }
            })).foreach((Function1)new Serializable(this, config){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseRelation $outer;
                private final Configuration config$2;

                public final void apply(String r) {
                    this.$outer.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HBase configuration file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r})));
                    this.config$2.addResource(new Path(r));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.config$2 = config$2;
                }
            });
            this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HBase configurations ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config})));
            hBaseContext = new HBaseContext(sqlContext.sparkContext(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
        }
        this.hbaseContext = hBaseContext;
        this.wrappedConf = new SerializableConfiguration(this.hbaseContext().config());
        this.schema = (StructType)userSpecifiedSchema.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseRelation $outer;

            public final StructType apply() {
                return this.$outer.catalog().toDataType();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

