/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasources.hbase;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.spark.datasources.AvroSerdes$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.sql.datasources.hbase.Field;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

@InterfaceAudience.Private
public final class Utils$ {
    public static final Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Object hbaseFieldToScalaType(Field f, byte[] src, int offset, int length2) {
        block13: {
            Object object;
            block3: {
                Object object2;
                block5: {
                    DataType dataType;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    block2: {
                                                        if (!f.exeSchema().isDefined()) break block2;
                                                        GenericRecord m = AvroSerdes$.MODULE$.deserialize(src, (Schema)f.exeSchema().get());
                                                        Option n = f.avroToCatalyst().map((Function1)new Serializable(m){
                                                            public static final long serialVersionUID = 0L;
                                                            private final GenericRecord m$1;

                                                            public final Object apply(Function1<Object, Object> x$1) {
                                                                return x$1.apply((Object)this.m$1);
                                                            }
                                                            {
                                                                this.m$1 = m$1;
                                                            }
                                                        });
                                                        object = n.get();
                                                        break block3;
                                                    }
                                                    dataType = f.dt();
                                                    if (!BooleanType$.MODULE$.equals(dataType)) break block4;
                                                    object2 = BoxesRunTime.boxToBoolean((boolean)this.toBoolean(src, offset));
                                                    break block5;
                                                }
                                                if (!ByteType$.MODULE$.equals(dataType)) break block6;
                                                object2 = BoxesRunTime.boxToByte((byte)src[offset]);
                                                break block5;
                                            }
                                            if (!DoubleType$.MODULE$.equals(dataType)) break block7;
                                            object2 = BoxesRunTime.boxToDouble((double)Bytes.toDouble((byte[])src, (int)offset));
                                            break block5;
                                        }
                                        if (!FloatType$.MODULE$.equals(dataType)) break block8;
                                        object2 = BoxesRunTime.boxToFloat((float)Bytes.toFloat((byte[])src, (int)offset));
                                        break block5;
                                    }
                                    if (!IntegerType$.MODULE$.equals(dataType)) break block9;
                                    object2 = BoxesRunTime.boxToInteger((int)Bytes.toInt((byte[])src, (int)offset));
                                    break block5;
                                }
                                boolean bl = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                                if (!bl) break block10;
                                object2 = BoxesRunTime.boxToLong((long)Bytes.toLong((byte[])src, (int)offset));
                                break block5;
                            }
                            if (!ShortType$.MODULE$.equals(dataType)) break block11;
                            object2 = BoxesRunTime.boxToShort((short)Bytes.toShort((byte[])src, (int)offset));
                            break block5;
                        }
                        if (!StringType$.MODULE$.equals(dataType)) break block12;
                        object2 = this.toUTF8String(src, offset, length2);
                        break block5;
                    }
                    if (!BinaryType$.MODULE$.equals(dataType)) break block13;
                    byte[] newArray = new byte[length2];
                    System.arraycopy(src, offset, newArray, 0, length2);
                    object2 = newArray;
                }
                object = object2;
            }
            return object;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported data type ", ", field: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.dt(), f})));
    }

    public byte[] toBytesPrimitiveType(Object input, DataType dt) {
        block12: {
            byte[] byArray;
            block3: {
                Object object;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block5: {
                                            block4: {
                                                block2: {
                                                    object = input;
                                                    if (!(object instanceof Boolean)) break block2;
                                                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                                                    byArray = Bytes.toBytes((boolean)bl);
                                                    break block3;
                                                }
                                                if (!(object instanceof Byte)) break block4;
                                                byte by = BoxesRunTime.unboxToByte((Object)object);
                                                byArray = new byte[]{by};
                                                break block3;
                                            }
                                            if (!(object instanceof byte[])) break block5;
                                            byte[] byArray2 = (byte[])object;
                                            byArray = byArray2;
                                            break block3;
                                        }
                                        if (!(object instanceof Double)) break block6;
                                        double d = BoxesRunTime.unboxToDouble((Object)object);
                                        byArray = Bytes.toBytes((double)d);
                                        break block3;
                                    }
                                    if (!(object instanceof Float)) break block7;
                                    float f = BoxesRunTime.unboxToFloat((Object)object);
                                    byArray = Bytes.toBytes((float)f);
                                    break block3;
                                }
                                if (!(object instanceof Integer)) break block8;
                                int n = BoxesRunTime.unboxToInt((Object)object);
                                byArray = Bytes.toBytes((int)n);
                                break block3;
                            }
                            if (!(object instanceof Long)) break block9;
                            long l = BoxesRunTime.unboxToLong((Object)object);
                            byArray = Bytes.toBytes((long)l);
                            break block3;
                        }
                        if (!(object instanceof Short)) break block10;
                        short s = BoxesRunTime.unboxToShort((Object)object);
                        byArray = Bytes.toBytes((short)s);
                        break block3;
                    }
                    if (!(object instanceof UTF8String)) break block11;
                    UTF8String uTF8String = (UTF8String)object;
                    byArray = uTF8String.getBytes();
                    break block3;
                }
                if (!(object instanceof String)) break block12;
                String string = (String)object;
                byArray = Bytes.toBytes((String)string);
            }
            return byArray;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported data type ", ", ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dt, input, input.getClass().toString()})));
    }

    public boolean toBoolean(byte[] input, int offset) {
        return input[offset] != 0;
    }

    public UTF8String toUTF8String(byte[] input, int offset, int length2) {
        return UTF8String.fromBytes((byte[])((byte[])Predef$.MODULE$.byteArrayOps(input).slice(offset, offset + length2)));
    }

    private Utils$() {
        MODULE$ = this;
    }
}

