/*
 * Decompiled with CFR 0.152.
 */
package com.guglielmobartelloni.trenitalia;

import com.guglielmobartelloni.trenitalia.exceptions.TrenitaliaEmptyArgumentException;
import com.guglielmobartelloni.trenitalia.exceptions.TrenitaliaResponseException;
import com.guglielmobartelloni.trenitalia.response.objects.autocomplete.AutocompletedStation;
import com.guglielmobartelloni.trenitalia.response.objects.travel.solution.TravelSolution;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class Trenitalia {
    public List<String> autocompleteStations(String city) {
        if (city == null || city.isEmpty()) {
            throw new TrenitaliaEmptyArgumentException();
        }
        String apiEndpoint = String.format("https://www.lefrecce.it/msite/api/geolocations/locations?name=%s", city);
        List<String> stationsList = Arrays.stream((AutocompletedStation[])Unirest.get((String)apiEndpoint).asObject(AutocompletedStation[].class).getBody()).map(AutocompletedStation::getName).collect(Collectors.toList());
        return stationsList;
    }

    public List<TravelSolution> oneWaySolutions(String autoCompletedOriginStation, String autocompletedDestinationStation, LocalDateTime travelSolutionsDateTime, int nAdults, int nChildren, boolean frecceSolutions, boolean regionalOnly) {
        DateTimeFormatter timeFormatter;
        String time;
        if (Stream.of(autocompletedDestinationStation, autoCompletedOriginStation, travelSolutionsDateTime).anyMatch(x$0 -> Objects.isNull(x$0)) || autoCompletedOriginStation.isEmpty() || autocompletedDestinationStation.isEmpty()) {
            throw new TrenitaliaEmptyArgumentException();
        }
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        String date = dateFormatter.format(travelSolutionsDateTime);
        String apiEndpoint = String.format("https://www.lefrecce.it/msite/api/solutions?origin=%s&destination=%s&arflag=A&adate=%s&atime=%s&adultno=%s&childno=%s&direction=A&frecce=%s&onlyRegional=%s", autoCompletedOriginStation, autocompletedDestinationStation, date, time = (timeFormatter = DateTimeFormatter.ofPattern("HH")).format(travelSolutionsDateTime), nAdults, nChildren, frecceSolutions, regionalOnly);
        HttpResponse response = Unirest.get((String)apiEndpoint).asObject(TravelSolution[].class);
        if (response.getStatus() != 200) {
            throw new TrenitaliaResponseException(response);
        }
        return Arrays.stream((TravelSolution[])response.getBody()).collect(Collectors.toList());
    }
}

