/*
 * Decompiled with CFR 0.152.
 */
package it.futurecraft.futureapi.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import it.futurecraft.futureapi.database.ConnectionInfo;
import it.futurecraft.futureapi.database.Transaction;
import it.futurecraft.futureapi.database.TransactionManagerImpl;
import java.util.function.Consumer;

public final class Database {
    private final HikariDataSource source;
    private final ConnectionInfo info;
    private final Transaction.Manager transactionManager;

    private Database(HikariDataSource source, ConnectionInfo info) {
        this.source = source;
        this.info = info;
        this.transactionManager = new TransactionManagerImpl(this, () -> ((HikariDataSource)source).getConnection());
    }

    public static Database connect(ConnectionInfo info) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(info.url());
        config.setUsername(info.username());
        config.setPassword(info.password());
        config.addDataSourceProperty("cachePrepStmts", (Object)true);
        config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        config.addDataSourceProperty("useServerPrepStmts", (Object)true);
        config.addDataSourceProperty("useLocalSessionState", (Object)true);
        config.addDataSourceProperty("rewriteBatchedStatements", (Object)true);
        config.addDataSourceProperty("cacheResultSetMetadata", (Object)true);
        config.addDataSourceProperty("cacheServerConfiguration", (Object)true);
        config.addDataSourceProperty("elideSetAutoCommits", (Object)true);
        config.addDataSourceProperty("maintainTimeStats", (Object)false);
        HikariDataSource source = new HikariDataSource(config);
        return new Database(source, info);
    }

    public ConnectionInfo info() {
        return this.info;
    }

    public Transaction.Manager transactionManager() {
        return this.transactionManager;
    }

    public void withTransaction(Consumer<Transaction> consumer) throws Exception {
        try (Transaction transaction = this.transactionManager.create();){
            consumer.accept(transaction);
        }
    }
}

