/*
 * Decompiled with CFR 0.152.
 */
package it.futurecraft.futureapi.database;

import it.futurecraft.futureapi.database.Database;
import it.futurecraft.futureapi.database.Transaction;
import it.futurecraft.futureapi.utils.Lazy;
import java.sql.Connection;
import java.sql.SQLException;

final class TransactionManagerImpl
implements Transaction.Manager {
    private final Database database;
    private final Transaction.Connector connector;
    private final ThreadLocal<Transaction> current;

    public TransactionManagerImpl(Database database, Transaction.Connector connector) {
        this.database = database;
        this.connector = connector;
        this.current = new ThreadLocal();
    }

    @Override
    public Connection newConnection() throws SQLException {
        return this.connector.get();
    }

    @Override
    public Transaction create() {
        Transaction transaction = this.current.get();
        if (transaction != null) {
            return transaction;
        }
        transaction = new TransactionImpl();
        this.current.set(transaction);
        return transaction;
    }

    @Override
    public Database database() {
        return this.database;
    }

    final class TransactionImpl
    implements Transaction {
        private final Lazy<Connection> connectionLazy = Lazy.by(() -> {
            Connection connection = TransactionManagerImpl.this.newConnection();
            if (connection.getAutoCommit()) {
                connection.setAutoCommit(false);
            }
            return connection;
        });

        TransactionImpl() {
        }

        @Override
        public Connection connection() throws Exception {
            return this.connectionLazy.get();
        }

        @Override
        public void commit() throws Exception {
            if (this.connectionLazy.initialized()) {
                this.connection().commit();
            }
        }

        @Override
        public void rollback() throws Exception {
            if (this.connectionLazy.initialized()) {
                this.connection().rollback();
            }
        }

        @Override
        public void close() {
            try {
                if (this.connectionLazy.initialized() && !this.connection().isClosed()) {
                    this.connection().close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                TransactionManagerImpl.this.current.remove();
            }
        }
    }
}

