/*
 * Decompiled with CFR 0.152.
 */
package it.futurecraft.futureapi.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import it.futurecraft.futureapi.utils.TypeReference;
import it.futurecraft.futureapi.utils.tuple.Pair;

public abstract class Converter<S, D> {
    private static final Cache<Pair<Class<?>, Class<?>>, Converter<?, ?>> CACHE = Caffeine.newBuilder().build();

    public Converter() {
        TypeReference src = new TypeReference<S>(){};
        TypeReference dest = new TypeReference<D>(){};
        CACHE.put(Pair.of(src.typeClass(), dest.typeClass()), (Object)this);
    }

    public static <S, D> Converter<S, D> get(Class<S> src, Class<D> dest) {
        Converter converter = (Converter)CACHE.getIfPresent(Pair.of(src, dest));
        if (converter == null) {
            for (Pair types : CACHE.asMap().keySet()) {
                if (!((Class)types.first()).isAssignableFrom(src) || !((Class)types.second()).equals(dest)) continue;
                return (Converter)CACHE.getIfPresent((Object)types);
            }
        }
        return converter;
    }

    public static <S, D> D convert(S src, Class<D> dest) {
        Converter<?, D> converter = Converter.get(src.getClass(), dest);
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Converter: Could not find a valid converter from type %s to type %s", src.getClass().getSimpleName(), dest.getSimpleName()));
        }
        return converter.convert(src);
    }

    public static <S, D> S revert(D dest, Class<S> src) {
        Converter<S, ?> converter = Converter.get(src, dest.getClass());
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Converter: Could not find a valid converter from type %s to type %s", dest.getClass().getSimpleName(), src.getSimpleName()));
        }
        return converter.revert(dest);
    }

    public static void invalidate(Class<?> src, Class<?> dest) {
        CACHE.invalidate(Pair.of(src, dest));
    }

    public abstract D convert(S var1);

    public abstract S revert(D var1);
}

