/*
 * Decompiled with CFR 0.152.
 */
package it.futurecraft.futureapi.utils;

import it.futurecraft.futureapi.utils.Throwing;
import java.util.concurrent.CompletableFuture;

public abstract class Lazy<T> {
    protected T value;

    public static <T> Lazy<T> by(Throwing.Supplier<T> supplier) {
        return new SynchronousLazy<T>(supplier);
    }

    public static <T> Lazy<T> by(CompletableFuture<T> supplier) {
        return new AsynchronousLazy<T>(supplier);
    }

    public void set(T value) {
        this.value = value;
    }

    public abstract T get() throws Exception;

    public boolean initialized() {
        return this.value != null;
    }

    private static final class SynchronousLazy<T>
    extends Lazy<T> {
        private final Throwing.Supplier<T> supplier;

        public SynchronousLazy(Throwing.Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T get() throws Exception {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return (T)this.value;
        }
    }

    private static final class AsynchronousLazy<T>
    extends Lazy<T> {
        private final CompletableFuture<T> supplier;

        public AsynchronousLazy(CompletableFuture<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T get() throws Exception {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return (T)this.value;
        }
    }
}

