/*
 * Decompiled with CFR 0.152.
 */
package it.futurecraft.futureapi.utils.tuple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class Tuple
implements Iterable<Object>,
Comparable<Tuple>,
Serializable {
    protected final Object[] values;
    private final int size;

    protected Tuple(Object[] values) {
        this.size = values.length;
        this.values = values;
    }

    public final int size() {
        return this.size;
    }

    public final Object at(int position) {
        Objects.checkIndex(position, this.size);
        return this.values[position];
    }

    public final <T> T at(int position, @NotNull Class<T> type) {
        Objects.checkIndex(position, this.size);
        Objects.requireNonNull(type);
        Object value = this.values[position];
        if (!type.isInstance(value)) {
            throw new ClassCastException("Tuple element at index " + position + " can not be cast to type " + type.getSimpleName());
        }
        return (T)value;
    }

    public final boolean contains(Object value) {
        return this.asList().contains(value);
    }

    public final boolean containsAll(Object ... values) {
        return this.containsAll(Arrays.asList(values));
    }

    public final boolean containsAll(Collection<Object> values) {
        return this.asList().containsAll(values);
    }

    public int indexOf(Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object value) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public final Object[] asArray() {
        return (Object[])this.values.clone();
    }

    public final List<Object> asList() {
        return List.of(this.values);
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        return this.asList().iterator();
    }

    @Override
    public int compareTo(@NotNull Tuple o) {
        for (int i = 0; i < this.size && i < o.size; ++i) {
            Comparable tElement = (Comparable)this.values[i];
            Comparable oElement = (Comparable)o.values[i];
            int result = tElement.compareTo(oElement);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(this.size, o.size);
    }

    public boolean equals(@NotNull Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple t = (Tuple)obj;
        if (this.size != t.size) {
            return false;
        }
        return this.containsAll(t.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        return sb.append(")").toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.size;
        result = result * 31 + Arrays.hashCode(this.values);
        return result;
    }
}

