/*
 * Decompiled with CFR 0.152.
 */
package it.futurecraft.futureapi.version;

import it.futurecraft.futureapi.version.ProtocolVersion;

public final class VersionSupport {
    private final ProtocolVersion min;
    private final ProtocolVersion max;

    private VersionSupport(ProtocolVersion min, ProtocolVersion max) {
        this.min = min;
        this.max = max;
    }

    public static VersionSupport single(ProtocolVersion version) {
        return new VersionSupport(version, version);
    }

    public static VersionSupport ranged(ProtocolVersion min, ProtocolVersion max) {
        return new VersionSupport(min, max);
    }

    public boolean check() {
        try {
            ProtocolVersion current = (ProtocolVersion)((Object)ProtocolVersion.current.get());
            return current.isSameOrAfter(this.min) && current.isSameOrBefore(this.max);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ProtocolVersion min() {
        return this.min;
    }

    public ProtocolVersion max() {
        return this.max;
    }
}

