/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.api;

import it.krzeminski.snakeyaml.engine.kmp.api.LoadSettings;
import it.krzeminski.snakeyaml.engine.kmp.api.YamlUnicodeReader;
import it.krzeminski.snakeyaml.engine.kmp.composer.Composer;
import it.krzeminski.snakeyaml.engine.kmp.constructor.BaseConstructor;
import it.krzeminski.snakeyaml.engine.kmp.constructor.StandardConstructor;
import it.krzeminski.snakeyaml.engine.kmp.nodes.Node;
import it.krzeminski.snakeyaml.engine.kmp.parser.ParserImpl;
import it.krzeminski.snakeyaml.engine.kmp.scanner.StreamReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.Charsets;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u001eB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\u0017\u001a\u00020\rH\u0007J\u0018\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\u001a\u001a\u00020\u0011H\u0007J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\rH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0011H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/Load;", "", "settings", "Lit/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;", "constructor", "Lit/krzeminski/snakeyaml/engine/kmp/constructor/BaseConstructor;", "<init>", "(Lit/krzeminski/snakeyaml/engine/kmp/api/LoadSettings;Lit/krzeminski/snakeyaml/engine/kmp/constructor/BaseConstructor;)V", "createComposer", "Lit/krzeminski/snakeyaml/engine/kmp/composer/Composer;", "yaml", "Lokio/Source;", "inputStream", "Ljava/io/InputStream;", "string", "", "reader", "Ljava/io/Reader;", "loadOne", "composer", "loadAll", "", "loadAllFromInputStream", "yamlStream", "loadAllFromString", "loadAllFromReader", "yamlReader", "loadFromInputStream", "loadFromReader", "loadFromString", "YamlIterator", "snakeyaml-engine-kmp"})
public final class Load {
    @NotNull
    private final LoadSettings settings;
    @NotNull
    private final BaseConstructor constructor;

    @JvmOverloads
    public Load(@NotNull LoadSettings settings, @NotNull BaseConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.settings = settings;
        this.constructor = constructor;
    }

    public /* synthetic */ Load(LoadSettings loadSettings, BaseConstructor baseConstructor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            loadSettings = LoadSettings.Companion.builder().build();
        }
        if ((n & 2) != 0) {
            baseConstructor = new StandardConstructor(loadSettings);
        }
        this(loadSettings, baseConstructor);
    }

    private final Composer createComposer(Source yaml) {
        StreamReader reader = new StreamReader(this.settings, new YamlUnicodeReader(yaml));
        return new Composer(this.settings, new ParserImpl(this.settings, reader));
    }

    private final Composer createComposer(InputStream inputStream) {
        return this.createComposer(Okio.source((InputStream)inputStream));
    }

    private final Composer createComposer(String string) {
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.createComposer(new ByteArrayInputStream(byArray));
    }

    private final Composer createComposer(Reader reader) {
        return this.createComposer(TextStreamsKt.readText((Reader)reader));
    }

    private final Object loadOne(Composer composer) {
        Node nodeOptional = composer.getSingleNode();
        return this.constructor.constructSingleDocument(nodeOptional);
    }

    @Nullable
    public final Object loadOne(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return this.loadOne(this.createComposer(inputStream));
    }

    @Nullable
    public final Object loadOne(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return this.loadOne(this.createComposer(reader));
    }

    @Nullable
    public final Object loadOne(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.loadOne(this.createComposer(string));
    }

    private final Iterable<Object> loadAll(Composer composer) {
        return new Iterable<Object>(composer, this){
            final /* synthetic */ Composer $composer$inlined;
            final /* synthetic */ Load this$0;
            {
                this.$composer$inlined = composer;
                this.this$0 = load;
            }

            public Iterator<Object> iterator() {
                boolean bl = false;
                return new YamlIterator(this.$composer$inlined, Load.access$getConstructor$p(this.this$0));
            }
        };
    }

    @NotNull
    public final Iterable<Object> loadAll(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return this.loadAll(this.createComposer(inputStream));
    }

    @NotNull
    public final Iterable<Object> loadAll(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return this.loadAll(this.createComposer(reader));
    }

    @NotNull
    public final Iterable<Object> loadAll(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.loadAll(this.createComposer(string));
    }

    @Deprecated(message="renamed", replaceWith=@ReplaceWith(expression="loadAll(yamlStream)", imports={}))
    @NotNull
    public final Iterable<Object> loadAllFromInputStream(@NotNull InputStream yamlStream) {
        Intrinsics.checkNotNullParameter((Object)yamlStream, (String)"yamlStream");
        return this.loadAll(yamlStream);
    }

    @Deprecated(message="renamed", replaceWith=@ReplaceWith(expression="loadAll(yaml)", imports={}))
    @NotNull
    public final Iterable<Object> loadAllFromString(@NotNull String yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return this.loadAll(yaml);
    }

    @Deprecated(message="renamed", replaceWith=@ReplaceWith(expression="loadAll(yamlReader)", imports={}))
    @NotNull
    public final Iterable<Object> loadAllFromReader(@NotNull Reader yamlReader) {
        Intrinsics.checkNotNullParameter((Object)yamlReader, (String)"yamlReader");
        return this.loadAll(yamlReader);
    }

    @Deprecated(message="renamed", replaceWith=@ReplaceWith(expression="loadOne(yamlStream)", imports={}))
    @Nullable
    public final Object loadFromInputStream(@NotNull InputStream yamlStream) {
        Intrinsics.checkNotNullParameter((Object)yamlStream, (String)"yamlStream");
        return this.loadOne(yamlStream);
    }

    @Deprecated(message="renamed", replaceWith=@ReplaceWith(expression="loadOne(yamlReader)", imports={}))
    @Nullable
    public final Object loadFromReader(@NotNull Reader yamlReader) {
        Intrinsics.checkNotNullParameter((Object)yamlReader, (String)"yamlReader");
        return this.loadOne(yamlReader);
    }

    @Deprecated(message="renamed", replaceWith=@ReplaceWith(expression="loadOne(yamlReader)", imports={}))
    @Nullable
    public final Object loadFromString(@NotNull String yaml) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        return this.loadOne(yaml);
    }

    @JvmOverloads
    public Load(@NotNull LoadSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this(settings, null, 2, null);
    }

    @JvmOverloads
    public Load() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ BaseConstructor access$getConstructor$p(Load $this) {
        return $this.constructor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000b\u001a\u00020\nH\u0096\u0002J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/Load$YamlIterator;", "", "", "composer", "Lit/krzeminski/snakeyaml/engine/kmp/composer/Composer;", "constructor", "Lit/krzeminski/snakeyaml/engine/kmp/constructor/BaseConstructor;", "<init>", "(Lit/krzeminski/snakeyaml/engine/kmp/composer/Composer;Lit/krzeminski/snakeyaml/engine/kmp/constructor/BaseConstructor;)V", "composerInitiated", "", "hasNext", "next", "snakeyaml-engine-kmp"})
    private static final class YamlIterator
    implements Iterator<Object>,
    KMappedMarker {
        @NotNull
        private final Composer composer;
        @NotNull
        private final BaseConstructor constructor;
        private boolean composerInitiated;

        public YamlIterator(@NotNull Composer composer, @NotNull BaseConstructor constructor) {
            Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            this.composer = composer;
            this.constructor = constructor;
        }

        @Override
        public boolean hasNext() {
            this.composerInitiated = true;
            return this.composer.hasNext();
        }

        @Override
        @Nullable
        public Object next() {
            if (!this.composerInitiated) {
                this.hasNext();
            }
            Node node = this.composer.next();
            return this.constructor.constructSingleDocument(node);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

