/*
 * Decompiled with CFR 0.152.
 */
package it.sdkboilerplate.actions;

import it.sdkboilerplate.exceptions.MalformedHookException;
import it.sdkboilerplate.exceptions.MalformedSdkException;
import it.sdkboilerplate.exceptions.SdkException;
import it.sdkboilerplate.exceptions.SdkHttpException;
import it.sdkboilerplate.exceptions.UnknownContentTypeException;
import it.sdkboilerplate.exceptions.UnknownHttpException;
import it.sdkboilerplate.exceptions.UnserializableObjectException;
import it.sdkboilerplate.hooks.FailureHook;
import it.sdkboilerplate.hooks.Hook;
import it.sdkboilerplate.hooks.PreSendHook;
import it.sdkboilerplate.hooks.SuccessHook;
import it.sdkboilerplate.http.SdkRequest;
import it.sdkboilerplate.http.SdkResponse;
import it.sdkboilerplate.http.agents.UserAgent;
import it.sdkboilerplate.http.agents.UserAgentFactory;
import it.sdkboilerplate.lib.ApiContext;
import it.sdkboilerplate.lib.Serializer;
import it.sdkboilerplate.lib.SerializerFactory;
import it.sdkboilerplate.objects.SdkBodyType;
import it.sdkboilerplate.objects.SdkCollection;
import it.sdkboilerplate.objects.SdkObject;
import it.sdkboilerplate.validation.Schema;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.text.StrSubstitutor;

public abstract class Action {
    private ApiContext ctx;
    private HashMap<String, String> routeParameters;
    private HashMap<String, String> queryParameters;
    private SdkBodyType requestBody;

    public ApiContext getContext() {
        return this.ctx;
    }

    public abstract ArrayList<Class<? extends FailureHook>> getFailureHooks();

    public abstract ArrayList<Class<? extends SuccessHook>> getSuccessHooks();

    public abstract ArrayList<Class<? extends PreSendHook>> getPreSendHooks();

    public void setRouteParameters(HashMap<String, String> routeParameters) {
        this.validateRouteParams(routeParameters);
        this.routeParameters = routeParameters;
    }

    public void setQueryParameters(HashMap<String, String> queryParameters) {
        this.validateQueryParams(queryParameters);
        this.queryParameters = queryParameters;
    }

    public void setRequestBody(SdkBodyType requestBody) throws UnserializableObjectException {
        this.validateRequestBody(requestBody);
        this.requestBody = requestBody;
    }

    public void setRouteParameter(String key, String value) {
        this.routeParameters.put(key, value);
    }

    public void setQueryParameter(String key, String value) {
        this.queryParameters.put(key, value);
    }

    private HashMap<String, String> getRouteParameters() {
        return this.routeParameters;
    }

    private HashMap<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    private SdkBodyType getRequestBody() {
        return this.requestBody;
    }

    public abstract String getRoute();

    public abstract String getVerb();

    public abstract Class<? extends SdkBodyType> getRequestBodyClass();

    public abstract Class<? extends SdkBodyType> getResponseBodyClass();

    public abstract HashMap<String, Class<? extends SdkHttpException>> getErrors();

    public abstract Schema getRouteParametersSchema();

    public abstract Schema getQueryParametersSchema();

    public abstract HashMap<String, String> getHeaders();

    private void validateRequestBody(SdkBodyType body) throws UnserializableObjectException {
        Class<? extends SdkBodyType> requestBodyClass = this.getRequestBodyClass();
        try {
            Method getSchema = requestBodyClass.getMethod("getSchema", new Class[0]);
            Method serializationMethod = null;
            if (body instanceof SdkObject) {
                serializationMethod = requestBodyClass.getMethod("toHashMap", new Class[0]);
            } else if (body instanceof SdkCollection) {
                serializationMethod = requestBodyClass.getMethod("toArray", new Class[0]);
            } else {
                throw new UnserializableObjectException();
            }
            this.validate(serializationMethod.invoke((Object)body, new Object[0]), (Schema)getSchema.invoke((Object)body, new Object[0]));
        }
        catch (NoSuchMethodException exc) {
            throw new UnserializableObjectException(exc.getMessage());
        }
        catch (IllegalAccessException exc) {
            throw new UnserializableObjectException(exc.getMessage());
        }
        catch (InvocationTargetException exc) {
            throw new UnserializableObjectException(exc.getMessage());
        }
    }

    private void validateQueryParams(HashMap<String, String> queryParameters) {
    }

    private void validateRouteParams(HashMap<String, String> routeParameters) {
    }

    private <T> void validate(T value, Schema schema) {
    }

    public String getExceptionKey(SdkResponse sdkResponse) {
        return sdkResponse.getStatusCode().toString();
    }

    private Class<? extends SdkHttpException> getException(SdkResponse sdkResponse) throws UnknownHttpException {
        Class<? extends SdkHttpException> exceptionClass = this.getErrors().get(this.getExceptionKey(sdkResponse));
        if (exceptionClass == null) {
            throw new UnknownHttpException();
        }
        return exceptionClass;
    }

    private String buildRoute() throws SdkException {
        return StrSubstitutor.replace((Object)this.getRoute(), this.getRouteParameters(), (String)"{", (String)"}");
    }

    private void runHooks(ArrayList<Hook> hooks) {
        for (Hook hook : hooks) {
            hook.run();
        }
    }

    private void runPreSendHooks(SdkRequest request) throws SdkException {
        try {
            ArrayList<Hook> hooks = new ArrayList<Hook>();
            for (Class<? extends PreSendHook> preSendHookClass : this.getPreSendHooks()) {
                Constructor<? extends PreSendHook> hookConstructor = preSendHookClass.getConstructor(ApiContext.class, SdkRequest.class);
                hooks.add(hookConstructor.newInstance(this.ctx, request));
            }
            this.runHooks(hooks);
        }
        catch (IllegalAccessException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedHookException(e.getMessage());
        }
    }

    private void runFailureHooks(SdkRequest request, SdkResponse response, SdkException exception) throws SdkException {
        try {
            ArrayList<Hook> hooks = new ArrayList<Hook>();
            for (Class<? extends FailureHook> failureHookClass : this.getFailureHooks()) {
                Constructor<? extends FailureHook> hookConstructor = failureHookClass.getConstructor(ApiContext.class, SdkRequest.class, SdkResponse.class, SdkException.class);
                hooks.add(hookConstructor.newInstance(this.ctx, request, response, exception));
            }
            this.runHooks(hooks);
        }
        catch (IllegalAccessException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedHookException(e.getMessage());
        }
    }

    private void runSuccessHooks(SdkRequest request, SdkResponse response) throws SdkException {
        try {
            ArrayList<Hook> hooks = new ArrayList<Hook>();
            for (Class<? extends SuccessHook> successHookClass : this.getSuccessHooks()) {
                Constructor<? extends SuccessHook> hookConstructor = successHookClass.getConstructor(ApiContext.class, SdkRequest.class, SdkResponse.class);
                hooks.add(hookConstructor.newInstance(this.ctx, request, response));
            }
            this.runHooks(hooks);
        }
        catch (IllegalAccessException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MalformedHookException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedHookException(e.getMessage());
        }
    }

    private String serializeRequestBody() throws UnknownContentTypeException, UnserializableObjectException {
        SdkBodyType requestBody = this.getRequestBody();
        if (requestBody != null) {
            Serializer serializer = SerializerFactory.make(this.getHeaders().get("Content-Type"));
            return serializer.serialize(requestBody);
        }
        return null;
    }

    private UserAgent getUserAgent() {
        return UserAgentFactory.make(this.ctx);
    }

    public SdkBodyType run() throws SdkException, SdkHttpException {
        HashMap<String, String> headers = this.getHeaders();
        String serializedBody = this.serializeRequestBody();
        SdkRequest request = new SdkRequest(this.buildRoute(), this.getVerb(), headers, this.getQueryParameters(), serializedBody);
        this.runPreSendHooks(request);
        UserAgent agent = this.getUserAgent();
        SdkResponse response = agent.send(request);
        if (response.isFailed()) {
            try {
                Class<? extends SdkHttpException> exceptionClass = this.getException(response);
                SdkHttpException exceptionInstance = exceptionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.runFailureHooks(request, response, exceptionInstance);
                throw exceptionInstance;
            }
            catch (NoSuchMethodException e) {
                throw new MalformedSdkException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new MalformedSdkException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new MalformedSdkException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new MalformedSdkException(e.getMessage());
            }
        }
        this.runSuccessHooks(request, response);
        Class<? extends SdkBodyType> responseBodyClass = this.getResponseBodyClass();
        return response.format(responseBodyClass);
    }

    public Action(ApiContext ctx) {
        this.ctx = ctx;
        this.routeParameters = new HashMap();
        this.queryParameters = new HashMap();
        this.requestBody = null;
    }
}

