/*
 * Decompiled with CFR 0.152.
 */
package it.sdkboilerplate.actions;

import it.sdkboilerplate.actions.Action;
import it.sdkboilerplate.exceptions.MalformedActionException;
import it.sdkboilerplate.exceptions.UndefinedActionException;
import it.sdkboilerplate.lib.ApiContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public abstract class ActionsFactory {
    private ApiContext ctx;

    public abstract HashMap<String, Class<? extends Action>> getActions();

    public ActionsFactory(ApiContext ctx) {
        this.ctx = ctx;
    }

    public Action make(String namespace) throws UndefinedActionException {
        HashMap<String, Class<? extends Action>> actions = this.getActions();
        if (actions.containsKey(namespace)) {
            try {
                Class<? extends Action> actionClass = actions.get(namespace);
                Constructor<? extends Action> constructor = actionClass.getConstructor(ApiContext.class);
                return constructor.newInstance(this.ctx);
            }
            catch (NoSuchMethodException e) {
                throw new MalformedActionException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new MalformedActionException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new MalformedActionException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new MalformedActionException(e.getMessage());
            }
        }
        throw new UndefinedActionException();
    }
}

