/*
 * Decompiled with CFR 0.152.
 */
package it.sdkboilerplate.callbacks;

import it.sdkboilerplate.exceptions.CallbackParsingException;
import it.sdkboilerplate.exceptions.CallbackVerificationException;
import it.sdkboilerplate.exceptions.DeserializationException;
import it.sdkboilerplate.exceptions.UnknownBodyTypeException;
import it.sdkboilerplate.exceptions.UnknownCallbackTypeException;
import it.sdkboilerplate.lib.ApiContext;
import it.sdkboilerplate.lib.JsonDeserializer;
import it.sdkboilerplate.objects.SdkObject;
import java.util.HashMap;

public abstract class CallbackHandler {
    public ApiContext ctx;

    public CallbackHandler(ApiContext ctx) {
        this.ctx = ctx;
    }

    public abstract String getCallbackNamespace(byte[] var1) throws CallbackParsingException;

    public abstract void verify(HashMap<String, String> var1, byte[] var2) throws CallbackParsingException, CallbackVerificationException;

    public abstract HashMap<String, Class<? extends SdkObject>> getCallbacks();

    public SdkObject parse(HashMap<String, String> headers, byte[] rawBody) throws UnknownCallbackTypeException, CallbackVerificationException, CallbackParsingException, DeserializationException {
        this.verify(headers, rawBody);
        String callbackNamespace = this.getCallbackNamespace(rawBody);
        JsonDeserializer deserializer = new JsonDeserializer();
        try {
            return (SdkObject)deserializer.deserialize(new String(rawBody), this.getCallbacks().get(callbackNamespace));
        }
        catch (UnknownBodyTypeException e) {
            throw new UnknownCallbackTypeException();
        }
    }
}

