/*
 * Decompiled with CFR 0.152.
 */
package it.sdkboilerplate.http;

import it.sdkboilerplate.exceptions.DeserializationException;
import it.sdkboilerplate.exceptions.UnknownBodyTypeException;
import it.sdkboilerplate.exceptions.UnknownContentTypeException;
import it.sdkboilerplate.lib.Deserializer;
import it.sdkboilerplate.lib.DeserializerFactory;
import it.sdkboilerplate.objects.SdkBodyType;
import java.util.HashMap;

public class SdkResponse {
    private Integer statusCode;
    private String body;
    private HashMap<String, String> headers;

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getRawBody() {
        return this.body;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public SdkResponse(Integer statusCode, String body, HashMap<String, String> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers;
    }

    public boolean isFailed() {
        return 200 > this.statusCode || this.statusCode > 299;
    }

    public <T extends SdkBodyType> T format(Class<? extends SdkBodyType> sdkObjectClass) throws UnknownContentTypeException, UnknownBodyTypeException, DeserializationException {
        if (sdkObjectClass == null) {
            return null;
        }
        Deserializer deserializer = DeserializerFactory.make(this.headers.get("Content-Type"));
        return (T)deserializer.deserialize(this.body, sdkObjectClass);
    }
}

