/*
 * Decompiled with CFR 0.152.
 */
package it.sdkboilerplate.lib;

import it.sdkboilerplate.exceptions.DeserializationException;
import it.sdkboilerplate.exceptions.JsonSerializationException;
import it.sdkboilerplate.exceptions.MalformedSdkObjectException;
import it.sdkboilerplate.exceptions.UnknownBodyTypeException;
import it.sdkboilerplate.lib.Deserializer;
import it.sdkboilerplate.objects.SdkBodyType;
import it.sdkboilerplate.objects.SdkCollection;
import it.sdkboilerplate.objects.SdkObject;
import it.sdkboilerplate.utils.Json;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.text.WordUtils;

public class JsonDeserializer
implements Deserializer {
    @Override
    public SdkBodyType deserialize(String jsonString, Class<? extends SdkBodyType> objectClass) throws UnknownBodyTypeException, DeserializationException {
        if (objectClass.getSuperclass() == SdkObject.class) {
            return this.deserializeSdkObject(jsonString, objectClass);
        }
        if (objectClass.getSuperclass() == SdkCollection.class) {
            return this.deserializeSdkCollection(jsonString, objectClass);
        }
        throw new UnknownBodyTypeException();
    }

    private SdkObject deserializeSdkObject(String jsonString, Class<? extends SdkObject> objectClass) throws DeserializationException {
        HashMap<String, Class<? extends SdkBodyType>> subObjects = this.getSubObjects(objectClass);
        HashMap jsonObject = (HashMap)this.loadJson(jsonString, HashMap.class);
        if (jsonObject == null) {
            return null;
        }
        SdkObject instance = this.getInstance(objectClass);
        for (Map.Entry jsonObjectAttribute : jsonObject.entrySet()) {
            String attributeName = WordUtils.capitalizeFully((String)jsonObjectAttribute.getKey().toString(), (char[])new char[]{'_'}).replaceAll("_", "");
            Class<? extends SdkBodyType> subObjectClass = subObjects.get(jsonObjectAttribute.getKey().toString());
            if (subObjectClass != null) {
                String jsonField = this.dumpJson(jsonObjectAttribute.getValue());
                Object attributeValue = this.deserializeSubObject(jsonField, subObjectClass);
                this.setAttribute(instance, attributeName, subObjectClass, attributeValue);
                continue;
            }
            Object attributeValue = jsonObjectAttribute.getValue();
            if (attributeValue == null) continue;
            Class<?> attributeClass = attributeValue.getClass();
            this.setAttribute(instance, attributeName, attributeClass, jsonObjectAttribute.getValue());
        }
        return instance;
    }

    private Object deserializeSubObject(String jsonAttribute, Class<? extends SdkBodyType> subObjectClass) throws DeserializationException {
        SdkBodyType value;
        if (subObjectClass.getSuperclass() == SdkObject.class) {
            value = this.deserializeSdkObject(jsonAttribute, subObjectClass);
        } else if (subObjectClass.getSuperclass() == SdkCollection.class) {
            value = this.deserializeSdkCollection(jsonAttribute, subObjectClass);
        } else {
            throw new DeserializationException("Unknown object subclass " + subObjectClass);
        }
        return value;
    }

    private SdkObject getInstance(Class<? extends SdkObject> objectClass) {
        try {
            Constructor<? extends SdkObject> objectConstructor = objectClass.getConstructor(new Class[0]);
            return objectClass.cast(objectConstructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
    }

    private void setAttribute(SdkObject instance, String attributeName, Class<?> attributeType, Object attributeValue) {
        try {
            Method setter = instance.getClass().getMethod("set" + attributeName, attributeType);
            setter.invoke((Object)instance, attributeValue);
        }
        catch (NoSuchMethodException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
    }

    private HashMap<String, Class<? extends SdkBodyType>> getSubObjects(Class<? extends SdkObject> objectClass) {
        try {
            return (HashMap)objectClass.getMethod("getSubObjects", new Class[0]).invoke(objectClass, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
    }

    private Object loadJson(String jsonString, Class<?> targetClass) throws DeserializationException {
        try {
            return Json.load(jsonString, targetClass);
        }
        catch (JsonSerializationException e) {
            throw new DeserializationException(e.getMessage());
        }
    }

    private String dumpJson(Object object) throws DeserializationException {
        try {
            return Json.dump(object);
        }
        catch (JsonSerializationException e) {
            throw new DeserializationException(e.getMessage());
        }
    }

    private SdkCollection deserializeSdkCollection(String jsonString, Class<? extends SdkCollection> collectionClass) throws DeserializationException {
        ArrayList jsonArray = (ArrayList)this.loadJson(jsonString, ArrayList.class);
        ArrayList<SdkBodyType> collectionArguments = new ArrayList<SdkBodyType>();
        Class elementsClass = this.getElementsClass(collectionClass);
        for (Object element : jsonArray) {
            String tmpField;
            if (elementsClass.getSuperclass() == SdkCollection.class) {
                tmpField = this.dumpJson(new ArrayList().add(element));
                collectionArguments.add(this.deserializeSdkCollection(tmpField, elementsClass));
                continue;
            }
            if (elementsClass.getSuperclass() == SdkObject.class) {
                tmpField = this.dumpJson(element);
                collectionArguments.add(this.deserializeSdkObject(tmpField, elementsClass));
                continue;
            }
            collectionArguments.add((SdkBodyType)element);
        }
        try {
            Constructor<? extends SdkCollection> constructor = collectionClass.getConstructor(ArrayList.class);
            return constructor.newInstance(collectionArguments);
        }
        catch (NoSuchMethodException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
    }

    private Class getElementsClass(Class<?> collectionClass) {
        try {
            Method getElementsClass = collectionClass.getMethod("getElementsClass", new Class[0]);
            return (Class)getElementsClass.invoke(collectionClass, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
    }
}

