/*
 * Decompiled with CFR 0.152.
 */
package it.sdkboilerplate.lib;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.sdkboilerplate.exceptions.MalformedSdkObjectException;
import it.sdkboilerplate.exceptions.UnserializableObjectException;
import it.sdkboilerplate.lib.Serializer;
import it.sdkboilerplate.objects.SdkBodyType;
import it.sdkboilerplate.objects.SdkCollection;
import it.sdkboilerplate.objects.SdkObject;
import java.lang.reflect.InvocationTargetException;

public class JsonSerializer
implements Serializer {
    @Override
    public String serialize(SdkBodyType bodyObject) throws UnserializableObjectException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            if (bodyObject instanceof SdkObject) {
                return mapper.writeValueAsString(bodyObject.getClass().getMethod("toHashMap", new Class[0]).invoke((Object)bodyObject, new Object[0]));
            }
            if (bodyObject instanceof SdkCollection) {
                return mapper.writeValueAsString(bodyObject.getClass().getMethod("toArray", new Class[0]).invoke((Object)bodyObject, new Object[0]));
            }
            throw new UnserializableObjectException();
        }
        catch (JsonProcessingException e) {
            throw new UnserializableObjectException();
        }
        catch (NoSuchMethodException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new MalformedSdkObjectException(e.getMessage());
        }
    }
}

