/*
 * Decompiled with CFR 0.152.
 */
package it.nerdammer.oauthentication.web;

import it.nerdammer.oauthentication.OauthProvider;
import it.nerdammer.oauthentication.User;
import it.nerdammer.oauthentication.UserID;
import it.nerdammer.oauthentication.web.ConnectionsFinder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

class FacebookConnectionsFinder
implements ConnectionsFinder {
    FacebookConnectionsFinder() {
    }

    @Override
    public Collection<UserID> findConnections(User user) throws IOException {
        try {
            String accessToken = user.getAccessToken();
            String url = "https://graph.facebook.com/me/friends?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
            HashSet<UserID> users = new HashSet<UserID>();
            this.retrieve(url, users);
            return users;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void retrieve(String urlStr, Collection<UserID> collection) throws MalformedURLException, IOException {
        String next;
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        InputStream in = conn.getInputStream();
        ObjectMapper mapper = new ObjectMapper();
        Map friendsData = (Map)mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Object>>(){});
        conn.disconnect();
        List friendList = (List)friendsData.get("data");
        for (Map f : friendList) {
            String fid = (String)f.get("id");
            UserID id = new UserID(OauthProvider.FACEBOOK, fid);
            collection.add(id);
        }
        Map paging = (Map)friendsData.get("paging");
        if (paging != null && (next = (String)paging.get("next")) != null) {
            this.retrieve(next, collection);
        }
    }
}

