/*
 * Decompiled with CFR 0.152.
 */
package it.nerdammer.oauthentication.web;

import it.nerdammer.oauthentication.OauthProvider;
import it.nerdammer.oauthentication.web.CommonUtils;
import it.nerdammer.oauthentication.web.OauthConfig;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        OauthConfig config = CommonUtils.getConfig();
        OauthProvider provider = CommonUtils.getProviderFromRequest(req);
        if (provider == null) {
            provider = CommonUtils.getProviderFromCookies(req);
        }
        if (provider == null) {
            provider = config.getDefaultProvider();
        }
        if (provider.equals((Object)OauthProvider.FACEBOOK)) {
            String appID = config.getFacebookAppID();
            if (appID == null) {
                throw new IllegalStateException("Missing facebook App ID");
            }
            String state = UUID.randomUUID().toString();
            req.getSession(true).setAttribute("it.nerdammer.oauthentication.FACEBOOK_STATE", (Object)state);
            String loginCallback = CommonUtils.buildCompleteUrl(req, "/oauthentication/facebook_login_callback");
            res.sendRedirect("https://www.facebook.com/dialog/oauth?client_id=" + URLEncoder.encode(appID, "UTF-8") + "&redirect_uri=" + URLEncoder.encode(loginCallback, "UTF-8") + "&state=" + URLEncoder.encode(state, "UTF-8") + "&scope=email");
        } else if (provider.equals((Object)OauthProvider.GOOGLE)) {
            String clientID = config.getGoogleClientID();
            if (clientID == null) {
                throw new IllegalStateException("Missing google Client ID");
            }
            String state = UUID.randomUUID().toString();
            req.getSession(true).setAttribute("it.nerdammer.oauthentication.GOOGLE_STATE", (Object)state);
            String loginCallback = CommonUtils.buildCompleteUrl(req, "/oauthentication/google_login_callback");
            res.sendRedirect("https://accounts.google.com/o/oauth2/auth?state=" + URLEncoder.encode(state, "UTF-8") + "&redirect_uri=" + URLEncoder.encode(loginCallback, "UTF-8") + "&response_type=code" + "&client_id=" + URLEncoder.encode(clientID, "UTF-8") + "&scope=" + URLEncoder.encode("https://www.googleapis.com/auth/userinfo.email https://www.googleapis.com/auth/userinfo.profile https://www.googleapis.com/auth/plus.login", "UTF-8"));
        } else {
            throw new UnsupportedOperationException("Login for provider " + (Object)((Object)provider) + " not implemented yet");
        }
    }
}

