/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.cec;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.tidalwave.cec.CecUserControlEvent;
import it.tidalwave.util.NotFoundException;
import java.beans.ConstructorProperties;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class CecEvent {
    @Nonnull
    private final EventType eventType;

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public EventType getEventType() {
        return this.eventType;
    }

    @ConstructorProperties(value={"eventType"})
    @SuppressFBWarnings(justification="generated code")
    public CecEvent(@Nonnull EventType eventType) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        this.eventType = eventType;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CecEvent)) {
            return false;
        }
        CecEvent other = (CecEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventType this$eventType = this.getEventType();
        EventType other$eventType = other.getEventType();
        return !(this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof CecEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 0 : ((Object)((Object)$eventType)).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "CecEvent(eventType=" + (Object)((Object)this.getEventType()) + ")";
    }

    public static enum EventType {
        USER_CONTROL_PRESSED(68, code -> new CecUserControlEvent(EventType.forCode(68), CecUserControlEvent.UserControlCode.forCode(code))),
        USER_CONTROL_RELEASED(139, code -> new CecUserControlEvent(EventType.forCode(139), CecUserControlEvent.UserControlCode.forCode(code)));

        private final int code;
        @Nonnull
        private final CecEventFactory eventFactory;

        @Nonnull
        public static EventType forCode(int code) throws NotFoundException {
            for (EventType eventType : EventType.values()) {
                if (eventType.getCode() != code) continue;
                return eventType;
            }
            throw new NotFoundException("CEC event type: " + Integer.toHexString(code));
        }

        @SuppressFBWarnings(justification="generated code")
        private EventType(int code, CecEventFactory eventFactory) {
            if (eventFactory == null) {
                throw new NullPointerException("eventFactory");
            }
            this.code = code;
            this.eventFactory = eventFactory;
        }

        @SuppressFBWarnings(justification="generated code")
        public int getCode() {
            return this.code;
        }

        @Nonnull
        @SuppressFBWarnings(justification="generated code")
        public CecEventFactory getEventFactory() {
            return this.eventFactory;
        }

        @SuppressFBWarnings(justification="generated code")
        public CecEvent createEvent(int code) throws NotFoundException {
            return this.getEventFactory().createEvent(code);
        }

        static interface CecEventFactory {
            @Nonnull
            public CecEvent createEvent(int var1) throws NotFoundException;
        }
    }
}

