/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.cec.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.tidalwave.bluemarine2.util.PowerOnNotification;
import it.tidalwave.cec.CecEvent;
import it.tidalwave.messagebus.MessageBus;
import it.tidalwave.messagebus.annotation.ListensTo;
import it.tidalwave.messagebus.annotation.SimpleMessageSubscriber;
import it.tidalwave.messagebus.impl.spring.SpringSimpleMessageSubscriberAspect;
import it.tidalwave.messagebus.impl.spring.SpringSimpleMessageSubscriberSupport;
import it.tidalwave.util.NotFoundException;
import it.tidalwave.util.ProcessExecutor;
import it.tidalwave.util.spi.DefaultProcessExecutor;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimpleMessageSubscriber
public class CecClientAdapter
implements SpringSimpleMessageSubscriberAspect.MessageBusHelperAware {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(CecClientAdapter.class);
    private static final String CEC_REGEX = "^TRAFFIC: *\\[ *([0-9]+)\\][ \\t>]*([0-9A-Fa-f]+):([0-9A-Fa-f]+):([0-9A-Fa-f]+)$";
    private static final Pattern CEC_PATTERN = Pattern.compile("^TRAFFIC: *\\[ *([0-9]+)\\][ \\t>]*([0-9A-Fa-f]+):([0-9A-Fa-f]+):([0-9A-Fa-f]+)$");
    private ProcessExecutor executor;
    @Inject
    private MessageBus messageBus;
    private final ProcessExecutor.ConsoleOutput.Listener listener;
    public SpringSimpleMessageSubscriberSupport support;

    public CecClientAdapter() {
        SpringSimpleMessageSubscriberAspect.ajc$interFieldInit$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$MessageBusHelperAware$support((SpringSimpleMessageSubscriberAspect.MessageBusHelperAware)this);
        this.listener = string -> {
            Matcher matcher = CEC_PATTERN.matcher(string);
            if (matcher.matches()) {
                int eventType = Integer.parseInt(matcher.group(3), 16);
                int keyCode = Integer.parseInt(matcher.group(4), 16);
                try {
                    CecEvent event = CecEvent.EventType.forCode(eventType).createEvent(keyCode);
                    log.debug("Sending {}...", (Object)event);
                    this.messageBus.publish((Object)event);
                }
                catch (NotFoundException e) {
                    log.warn("Not found: {} / {}", (Object)string, (Object)e.getMessage());
                }
            }
        };
    }

    void onPowerOnReceived(@Nonnull @ListensTo PowerOnNotification notification) {
        try {
            log.info("onPowerOnReceived({})", (Object)notification);
            this.executor = DefaultProcessExecutor.forExecutable((String)"/usr/bin/cec-client").withArguments(new String[]{"-d", "8", "-t", "p", "-o", "blueMarine"}).start();
            this.executor.getStdout().setListener(this.listener);
        }
        catch (IOException e) {
            log.error("Cannot run cec-client: {}", (Object)e.toString());
        }
    }

    public /* synthetic */ SpringSimpleMessageSubscriberSupport ajc$interFieldGet$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$MessageBusHelperAware$support() {
        return this.support;
    }

    public /* synthetic */ void ajc$interFieldSet$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$MessageBusHelperAware$support(SpringSimpleMessageSubscriberSupport springSimpleMessageSubscriberSupport) {
        this.support = springSimpleMessageSubscriberSupport;
    }

    public void afterPropertiesSet() {
        SpringSimpleMessageSubscriberAspect.ajc$interMethod$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$MessageBusHelperAware$afterPropertiesSet((SpringSimpleMessageSubscriberAspect.MessageBusHelperAware)this);
    }

    public void destroy() {
        SpringSimpleMessageSubscriberAspect.ajc$interMethod$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$it_tidalwave_messagebus_impl_spring_SpringSimpleMessageSubscriberAspect$MessageBusHelperAware$destroy((SpringSimpleMessageSubscriberAspect.MessageBusHelperAware)this);
    }
}

