/*
 * Decompiled with CFR 0.152.
 */
package it.xaan.random.cache;

import it.xaan.random.core.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public interface Cache<K, V> {
    public Optional<V> getOptional(K var1);

    public Optional<V> store(K var1, V var2);

    public Optional<V> invalidate(K var1);

    public Set<Pair<K, V>> entries();

    default public <A, B> Cache<A, B> map(BiFunction<K, V, Pair<A, B>> biFunction) {
        throw new NotImplementedException();
    }

    default public Optional<V> store(Pair<K, V> pair) {
        return this.store(pair.getFirst(), pair.getSecond());
    }

    default public List<V> invalidateWhere(Predicate<K> predicate) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Pair<Object, Object>> list = this.invalidateWhere((K object, V object2) -> predicate.test(object));
        for (Pair<Object, Object> pair : list) {
            arrayList.add(pair.getSecond());
        }
        return arrayList;
    }

    default public List<Pair<K, V>> invalidateWhere(BiPredicate<K, V> biPredicate) {
        ArrayList<Pair<K, V>> arrayList = new ArrayList<Pair<K, V>>();
        for (Pair<K, V> pair : this.entries()) {
            if (!biPredicate.test(pair.getFirst(), pair.getSecond())) continue;
            arrayList.add(pair);
            this.invalidate(pair.getFirst());
        }
        return arrayList;
    }

    default public int size() {
        return this.entries().size();
    }

    @Nullable
    default public V get(K k) {
        return this.getOptional(k).orElse(null);
    }

    default public Stream<Pair<K, V>> stream() {
        return this.entries().stream();
    }

    default public List<Pair<K, V>> invalidateAll() {
        return this.invalidateWhere((K object, V object2) -> true);
    }

    default public List<Pair<K, V>> where(BiPredicate<K, V> biPredicate) {
        ArrayList<Pair<K, V>> arrayList = new ArrayList<Pair<K, V>>();
        Set<Pair<K, V>> set = this.entries();
        for (Pair<K, V> pair : set) {
            if (!biPredicate.test(pair.getFirst(), pair.getSecond())) continue;
            arrayList.add(pair);
        }
        return arrayList;
    }

    default public List<V> where(Predicate<K> predicate) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Set<Pair<K, V>> set = this.entries();
        for (Pair<K, V> pair : set) {
            if (!predicate.test(pair.getFirst())) continue;
            arrayList.add(pair.getSecond());
        }
        return arrayList;
    }

    default public boolean has(K k) {
        return this.getOptional(k).isPresent();
    }

    default public Set<K> keys() {
        HashSet hashSet = new HashSet();
        this.entries().forEach(pair -> hashSet.add(pair.getFirst()));
        return hashSet;
    }

    default public Collection<V> values() {
        ArrayList arrayList = new ArrayList();
        this.entries().forEach(pair -> arrayList.add(pair.getSecond()));
        return arrayList;
    }
}

