/*
 * Decompiled with CFR 0.152.
 */
package it.xaan.random.cache.impl;

import it.xaan.random.cache.Cache;
import it.xaan.random.core.Pair;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class MapMemoryCache<K, V>
implements Cache<K, V> {
    private final Map<K, V> underlying;
    private final Supplier<Map<K, V>> supplier;

    public MapMemoryCache(Supplier<Map<K, V>> supplier) {
        this.underlying = supplier.get();
        if (this.underlying.size() > 0) {
            throw new IllegalStateException("Supplier must return a new, empty map.");
        }
        this.supplier = supplier;
    }

    @Override
    public Optional<V> getOptional(K k) {
        return Optional.ofNullable(this.underlying.get(k));
    }

    @Override
    public Optional<V> store(K k, V v) {
        if (v == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.underlying.put(k, v));
    }

    @Override
    public Optional<V> invalidate(K k) {
        return Optional.ofNullable(this.underlying.remove(k));
    }

    @Override
    public Set<Pair<K, V>> entries() {
        HashSet<Pair<K, V>> hashSet = new HashSet<Pair<K, V>>();
        Set<Map.Entry<K, V>> set = this.underlying.entrySet();
        for (Map.Entry<K, V> entry : set) {
            hashSet.add(Pair.from(entry.getKey(), entry.getValue()));
        }
        return hashSet;
    }

    @Override
    public <A, B> Cache<A, B> map(BiFunction<K, V, Pair<A, B>> biFunction) {
        MapMemoryCache<A, B> mapMemoryCache = new MapMemoryCache<A, B>(() -> this.supplier.get());
        Set<Pair<K, V>> set = this.entries();
        for (Pair<K, V> pair : set) {
            Pair<A, B> pair2 = biFunction.apply(pair.getFirst(), pair.getSecond());
            mapMemoryCache.store(pair2);
        }
        return mapMemoryCache;
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    public int hashCode() {
        return this.underlying.hashCode();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof MapMemoryCache && ((MapMemoryCache)object).underlying.equals(this.underlying);
    }

    public String toString() {
        return String.format("MapMemoryCache[underlying=%s]", this.underlying);
    }
}

