/*
 * Decompiled with CFR 0.152.
 */
package it.xaan.random.cache.impl;

import it.xaan.random.cache.Cache;
import it.xaan.random.cache.MultiValueCache;
import it.xaan.random.core.Pair;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class MultiValueCacheDelegate<K, V, C extends Collection<V>>
implements MultiValueCache<K, V, C> {
    private final Cache<K, C> delegate;
    private final Supplier<C> supplier;

    public MultiValueCacheDelegate(Cache<K, C> cache, Supplier<C> supplier) {
        this.delegate = cache;
        this.supplier = supplier;
    }

    @Override
    public Optional<C> getOptional(K k) {
        return Optional.of(this.delegate.getOptional(k).orElseGet(this.supplier()));
    }

    @Override
    public Optional<C> store(K k, C c) {
        Optional<C> optional = this.getOptional(k);
        this.delegate.store(k, c);
        return optional;
    }

    @Override
    public Optional<C> invalidate(K k) {
        Optional<C> optional = this.getOptional(k);
        this.delegate.invalidate(k);
        return optional;
    }

    @Override
    public Set<Pair<K, C>> entries() {
        return this.delegate.entries();
    }

    @Override
    public <A, B> Cache<A, B> map(BiFunction<K, C, Pair<A, B>> biFunction) {
        return this.delegate.map(biFunction);
    }

    @Override
    @Nonnull
    public C get(K k) {
        return (C)((Collection)this.delegate.getOptional(k).orElseGet(this.supplier()));
    }

    @Override
    public Supplier<C> supplier() {
        return this.supplier;
    }
}

