/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.log.Trace;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class ConnectionTable1_4
implements Runnable {
    Hashtable conns = new Hashtable();
    Receiver receiver = null;
    ServerSocketChannel srv_sock = null;
    InetAddress bind_addr = null;
    Address local_addr = null;
    int srv_port = 7800;
    Thread acceptor = null;
    final int backlog = 20;
    Vector conn_listeners = new Vector();
    Object recv_mutex = new Object();
    Reaper reaper = null;
    long reaper_interval = 60000L;
    long conn_expire_time = 300000L;
    boolean use_reaper = false;
    ThreadGroup thread_group = null;
    final byte[] cookie = new byte[]{98, 101, 108, 97};
    private Selector connectSelector;

    private ConnectionTable1_4() {
    }

    public ConnectionTable1_4(int srv_port) throws Exception {
        this.srv_port = srv_port;
        this.start();
    }

    public ConnectionTable1_4(int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.srv_port = srv_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        this.start();
    }

    public ConnectionTable1_4(Receiver r, InetAddress bind_addr, int srv_port) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.srv_port = srv_port;
        this.start();
    }

    public ConnectionTable1_4(Receiver r, InetAddress bind_addr, int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.setReceiver(r);
        this.bind_addr = bind_addr;
        this.srv_port = srv_port;
        this.reaper_interval = reaper_interval;
        this.conn_expire_time = conn_expire_time;
        this.use_reaper = true;
        this.start();
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public void addConnectionListener(ConnectionListener l) {
        if (l != null && !this.conn_listeners.contains(l)) {
            this.conn_listeners.addElement(l);
        }
    }

    public void removeConnectionListener(ConnectionListener l) {
        if (l != null) {
            this.conn_listeners.removeElement(l);
        }
    }

    public Address getLocalAddress() {
        if (this.local_addr == null) {
            this.local_addr = this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_port) : null;
        }
        return this.local_addr;
    }

    public void send(Message msg) {
        Connection conn;
        Address dest;
        Address address = dest = msg != null ? msg.getDest() : null;
        if (dest == null) {
            Trace.error("ConnectionTable.send()", "msg is null or message's destination is null");
            return;
        }
        try {
            conn = this.getConnection(dest);
            if (conn == null) {
                return;
            }
        }
        catch (Throwable ex) {
            Trace.info("ConnectionTable.send()", "connection to " + dest + " could not be established: " + ex);
            return;
        }
        try {
            conn.send(msg);
        }
        catch (Throwable ex) {
            if (Trace.trace) {
                Trace.info("ConnectionTable.send()", "sending message to " + dest + " failed (ex=" + ex.getClass().getName() + "); removing from connection table");
            }
            this.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(Address dest) throws Exception {
        Connection conn = null;
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            conn = (Connection)this.conns.get(dest);
            if (conn == null) {
                Socket sock = new Socket(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
                conn = new Connection(sock, dest);
                conn.sendLocalAddress(this.local_addr);
                this.notifyConnectionOpened(dest);
                this.addConnection(dest, conn);
                conn.init();
                if (Trace.trace) {
                    Trace.info("ConnectionTable.getConnection()", "created socket to " + dest);
                }
            }
            return conn;
        }
    }

    public void start() throws Exception {
        this.srv_sock = this.createServerSocket(this.srv_port);
        this.local_addr = this.bind_addr != null ? new IpAddress(this.bind_addr, this.srv_sock.socket().getLocalPort()) : new IpAddress(this.srv_sock.socket().getLocalPort());
        if (Trace.trace) {
            Trace.info("ConnectionTable.start()", "server socket created on " + this.local_addr);
        }
        this.acceptor = new Thread((Runnable)this, "ConnectionTable.AcceptorThread");
        this.acceptor.setDaemon(true);
        this.acceptor.start();
        if (this.use_reaper && this.reaper == null) {
            this.reaper = new Reaper();
            this.reaper.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Iterator it = null;
        if (this.srv_sock != null) {
            try {
                ServerSocketChannel tmp = this.srv_sock;
                this.srv_sock = null;
                tmp.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            it = this.conns.values().iterator();
            while (it.hasNext()) {
                Connection conn = (Connection)it.next();
                conn.destroy();
            }
            this.conns.clear();
        }
        this.local_addr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address addr) {
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            Connection conn = (Connection)this.conns.get(addr);
            if (conn != null) {
                try {
                    conn.destroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.conns.remove(addr);
            }
            if (Trace.trace) {
                Trace.info("ConnectionTable.remove()", "addr=" + addr + ", connections are " + this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection conn = null;
        while (this.srv_sock != null) {
            try {
                this.connectSelector.select();
                Set<SelectionKey> readyKeys = this.connectSelector.selectedKeys();
                Iterator<SelectionKey> i = readyKeys.iterator();
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    i.remove();
                    ServerSocketChannel readyChannel = (ServerSocketChannel)key.channel();
                    SocketChannel incomingChannel = readyChannel.accept();
                    incomingChannel.configureBlocking(false);
                    Socket client_sock = incomingChannel.socket();
                    if (Trace.trace) {
                        Trace.info("ConnectionTable.run()", "accepted connection, client_sock=" + client_sock);
                    }
                    conn = new Connection(client_sock, null);
                    Address peer_addr = conn.readPeerAddress(client_sock);
                    conn.setPeerAddress(peer_addr);
                    Hashtable hashtable = this.conns;
                    synchronized (hashtable) {
                        if (this.conns.contains(peer_addr)) {
                            if (Trace.trace) {
                                Trace.warn("ConnectionTable.run()", peer_addr + " is already there, will terminate connection");
                            }
                            conn.destroy();
                            return;
                        }
                        this.addConnection(peer_addr, conn);
                    }
                    this.notifyConnectionOpened(peer_addr);
                    conn.init();
                }
            }
            catch (SocketException sock_ex) {
                if (Trace.trace) {
                    Trace.info("ConnectionTable.run()", "exception is " + sock_ex);
                }
                if (conn != null) {
                    conn.destroy();
                }
                if (this.srv_sock != null) continue;
                break;
            }
            catch (Throwable ex) {
                if (!Trace.trace) continue;
                Trace.warn("ConnectionTable.run()", "exception is " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message msg) {
        if (this.receiver != null) {
            Object object = this.recv_mutex;
            synchronized (object) {
                this.receiver.receive(msg);
            }
        } else {
            Trace.error("ConnectionTable.receive()", "receiver is null (not set) !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer ret = new StringBuffer();
        Hashtable hashtable = this.conns;
        synchronized (hashtable) {
            ret.append("connections (" + this.conns.size() + "):\n");
            Enumeration e = this.conns.keys();
            while (e.hasMoreElements()) {
                Address key = (Address)e.nextElement();
                Connection val = (Connection)this.conns.get(key);
                ret.append("key: " + key.toString() + ": " + val.toString() + "\n");
            }
        }
        ret.append("\n");
        return ret.toString();
    }

    ServerSocketChannel createServerSocket(int start_port) throws Exception {
        ServerSocketChannel ret = ServerSocketChannel.open();
        ret.configureBlocking(false);
        while (true) {
            try {
                if (this.bind_addr == null) {
                    ret.socket().bind(new InetSocketAddress(start_port));
                    break;
                }
                ret.socket().bind(new InetSocketAddress(this.bind_addr, start_port), 20);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                Trace.error("ConnectionTable.createServerSocket()", "exception is " + io_ex);
            }
            break;
        }
        this.srv_port = start_port;
        ret.register(this.connectSelector, 16);
        return ret;
    }

    void notifyConnectionOpened(Address peer) {
        if (peer == null) {
            return;
        }
        for (int i = 0; i < this.conn_listeners.size(); ++i) {
            ((ConnectionListener)this.conn_listeners.elementAt(i)).connectionOpened(peer);
        }
    }

    void notifyConnectionClosed(Address peer) {
        if (peer == null) {
            return;
        }
        for (int i = 0; i < this.conn_listeners.size(); ++i) {
            ((ConnectionListener)this.conn_listeners.elementAt(i)).connectionClosed(peer);
        }
    }

    void addConnection(Address peer, Connection c) {
        this.conns.put(peer, c);
        if (this.reaper != null && !this.reaper.isRunning()) {
            this.reaper.start();
        }
    }

    class Reaper
    implements Runnable {
        Thread t = null;

        Reaper() {
        }

        public void start() {
            if (ConnectionTable1_4.this.conns.size() == 0) {
                return;
            }
            if (this.t != null && !this.t.isAlive()) {
                this.t = null;
            }
            if (this.t == null) {
                this.t = new Thread(ConnectionTable1_4.this.thread_group, this, "ConnectionTable.ReaperThread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            if (this.t != null) {
                this.t = null;
            }
        }

        public boolean isRunning() {
            return this.t != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Trace.trace) {
                Trace.info("ConnectionTable.Reaper.run()", "connection reaper thread was started. Number of connections=" + ConnectionTable1_4.this.conns.size() + ", reaper_interval=" + ConnectionTable1_4.this.reaper_interval + ", conn_expire_time=" + ConnectionTable1_4.this.conn_expire_time);
            }
            while (ConnectionTable1_4.this.conns.size() > 0 && this.t != null) {
                Util.sleep(ConnectionTable1_4.this.reaper_interval);
                Hashtable hashtable = ConnectionTable1_4.this.conns;
                synchronized (hashtable) {
                    long curr_time = System.currentTimeMillis();
                    Iterator it = ConnectionTable1_4.this.conns.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Connection value = (Connection)entry.getValue();
                        if (Trace.trace) {
                            Trace.info("ConnectionTable.Reaper.run()", "connection is " + (curr_time - value.last_access) / 1000L + " seconds old (curr-time=" + curr_time + ", last_access=" + value.last_access + ")");
                        }
                        if (value.last_access + ConnectionTable1_4.this.conn_expire_time >= curr_time) continue;
                        if (Trace.trace) {
                            Trace.info("ConnectionTable.Reaper.run()", "connection " + value + " has been idle for too long (conn_expire_time=" + ConnectionTable1_4.this.conn_expire_time + "), will be removed");
                        }
                        value.destroy();
                        it.remove();
                    }
                }
            }
            if (Trace.trace) {
                Trace.info("ConnectionTable.Reaper.run()", "reaper terminated");
            }
            this.t = null;
        }
    }

    class Connection {
        Socket sock = null;
        DataOutputStream out = null;
        DataInputStream in = null;
        Address peer_addr = null;
        Object send_mutex = new Object();
        long last_access = System.currentTimeMillis();

        Connection(Socket s, Address peer_addr) {
            this.sock = s;
            this.peer_addr = peer_addr;
            try {
                this.out = new DataOutputStream(this.sock.getOutputStream());
                this.in = new DataInputStream(this.sock.getInputStream());
            }
            catch (Exception ex) {
                Trace.error("ConnectionTable.Connection()", "exception is " + ex);
            }
        }

        void setPeerAddress(Address peer_addr) {
            this.peer_addr = peer_addr;
        }

        void updateLastAccessed() {
            this.last_access = System.currentTimeMillis();
        }

        void init() {
            if (Trace.trace) {
                Trace.info("ConnectionTable.Connection.init()", "connection was created to " + this.peer_addr);
            }
        }

        void destroy() {
            this.closeSocket();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(Message msg) {
            Object object = this.send_mutex;
            synchronized (object) {
                block12: {
                    try {
                        this.doSend(msg);
                        this.updateLastAccessed();
                    }
                    catch (IOException io_ex) {
                        if (Trace.trace) {
                            Trace.warn("ConnectionTable.Connection.send()", "peer closed connection, trying to re-establish connection and re-send msg.");
                        }
                        try {
                            this.doSend(msg);
                            this.updateLastAccessed();
                        }
                        catch (IOException io_ex2) {
                            if (Trace.trace) {
                                Trace.error("ConnectionTable.Connection.send()", "2nd attempt to send data failed too");
                            }
                        }
                        catch (Exception ex2) {
                            if (Trace.trace) {
                                Trace.error("ConnectionTable.Connection.send()", "exception is " + ex2);
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (!Trace.trace) break block12;
                        Trace.error("ConnectionTable.Connection.send()", "exception is " + ex);
                    }
                }
            }
        }

        void doSend(Message msg) throws Exception {
            IpAddress dst_addr = (IpAddress)msg.getDest();
            byte[] buffie = null;
            if (dst_addr == null || dst_addr.getIpAddress() == null) {
                Trace.error("ConnectionTable.Connection.doSend()", "the destination address is null; aborting send");
                return;
            }
            try {
                if (msg.getSrc() == null) {
                    msg.setSrc(ConnectionTable1_4.this.local_addr);
                }
                if ((buffie = Util.objectToByteBuffer(msg)).length <= 0) {
                    Trace.error("ConnectionTable.Connection.doSend()", "buffer.length is 0. Will not send message");
                    return;
                }
                if (this.out != null) {
                    this.out.writeInt(buffie.length);
                    Util.doubleWrite(buffie, this.out);
                    this.out.flush();
                }
            }
            catch (Exception ex) {
                if (Trace.trace) {
                    Trace.error("ConnectionTable.Connection.doSend()", "to " + dst_addr + ", exception is " + ex + ", stack trace:\n" + Util.printStackTrace(ex));
                }
                ConnectionTable1_4.this.remove(dst_addr);
                throw ex;
            }
        }

        Address readPeerAddress(Socket client_sock) throws Exception {
            InetAddress client_addr;
            Address peer_addr = null;
            byte[] input_cookie = new byte[ConnectionTable1_4.this.cookie.length];
            int len = 0;
            int client_port = client_sock != null ? client_sock.getPort() : 0;
            InetAddress inetAddress = client_addr = client_sock != null ? client_sock.getInetAddress() : null;
            if (this.in != null) {
                this.initCookie(input_cookie);
                this.in.read(input_cookie, 0, input_cookie.length);
                if (!this.matchCookie(input_cookie)) {
                    throw new SocketException("ConnectionTable.Connection.readPeerAddress(): cookie sent by " + peer_addr + " does not match own cookie; terminating connection");
                }
                byte[] version = new byte[Version.version_id.length];
                this.in.read(version, 0, version.length);
                if (!Version.compareTo(version)) {
                    Trace.warn("ConnectionTable.readPeerAddress()", "packet from " + client_addr + ":" + client_port + " has different version (" + Version.printVersionId(version, Version.version_id.length) + ") from ours (" + Version.printVersionId(Version.version_id) + "). This may cause problems");
                }
                len = this.in.readInt();
                byte[] buf = new byte[len];
                this.in.readFully(buf, 0, len);
                peer_addr = (Address)Util.objectFromByteBuffer(buf);
                this.updateLastAccessed();
            }
            return peer_addr;
        }

        void sendLocalAddress(Address local_addr) {
            if (local_addr == null) {
                Trace.warn("ConnectionTable.Connection.sendLocalAddress()", "local_addr is null");
                return;
            }
            if (this.out != null) {
                try {
                    byte[] buf = Util.objectToByteBuffer(local_addr);
                    this.out.write(ConnectionTable1_4.this.cookie, 0, ConnectionTable1_4.this.cookie.length);
                    this.out.write(Version.version_id, 0, Version.version_id.length);
                    this.out.writeInt(buf.length);
                    this.out.write(buf, 0, buf.length);
                    this.out.flush();
                    this.updateLastAccessed();
                }
                catch (Throwable t) {
                    Trace.error("ConnectionTable.Connection.sendLocalAddress()", "exception is " + t);
                }
            }
        }

        void initCookie(byte[] c) {
            if (c != null) {
                for (int i = 0; i < c.length; ++i) {
                    c[i] = 0;
                }
            }
        }

        boolean matchCookie(byte[] input) {
            if (input == null || input.length < ConnectionTable1_4.this.cookie.length) {
                return false;
            }
            if (Trace.trace) {
                Trace.info("ConnectionTable.Connection.matchCookie()", "input_cookie is " + this.printCookie(input));
            }
            for (int i = 0; i < ConnectionTable1_4.this.cookie.length; ++i) {
                if (ConnectionTable1_4.this.cookie[i] == input[i]) continue;
                return false;
            }
            return true;
        }

        String printCookie(byte[] c) {
            if (c == null) {
                return "";
            }
            return new String(c);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            InetAddress local = null;
            InetAddress remote = null;
            if (this.sock == null) {
                ret.append("<null socket>");
            } else {
                Socket tmp_sock = this.sock;
                local = tmp_sock.getLocalAddress();
                remote = tmp_sock.getInetAddress();
                String local_str = local != null ? Util.shortName(local.getHostName()) : "<null>";
                String remote_str = remote != null ? Util.shortName(local.getHostName()) : "<null>";
                ret.append("<" + local_str + ":" + tmp_sock.getLocalPort() + " --> " + remote_str + ":" + tmp_sock.getPort() + "> (" + (System.currentTimeMillis() - this.last_access) / 1000L + " secs old)");
                tmp_sock = null;
            }
            return ret.toString();
        }

        void closeSocket() {
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sock = null;
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.in = null;
            }
        }
    }

    class ReceiverThread
    extends Thread {
        private Selector selector = null;
        private static final int READ_BUFFER_SIZE = 256;
        private ByteBuffer readBuffer = null;

        public ReceiverThread(Selector selector) {
            this.selector = selector;
            this.readBuffer = ByteBuffer.allocateDirect(256);
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        if ((keysReady = this.selector.select()) <= 0) {
                            continue;
                        }
                        readyKeys = this.selector.selectedKeys();
                        i = readyKeys.iterator();
                        while (true) {
                            if (i.hasNext()) ** break;
                            continue block3;
                            key = i.next();
                            i.remove();
                            incomingChannel = (SocketChannel)key.channel();
                            incomingSocket = incomingChannel.socket();
                            bytesRead = incomingChannel.read(this.readBuffer);
                            this.readBuffer.flip();
                            recvBytes = this.readBuffer.array();
                            msg = (Message)Util.objectFromByteBuffer(recvBytes);
                            ConnectionTable1_4.this.receive(msg);
                            this.readBuffer.clear();
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public static interface ConnectionListener {
        public void connectionOpened(Address var1);

        public void connectionClosed(Address var1);
    }

    public static interface Receiver {
        public void receive(Message var1);
    }
}

