/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.jgroups.blocks.DistributedHashtable;
import org.jgroups.log.Trace;

public class DistributedHashtableTest
extends TestCase {
    final int NUM_ITEMS = 10;
    static Logger logger = Logger.getLogger((String)(class$org$jgroups$blocks$DistributedHashtableTest == null ? (class$org$jgroups$blocks$DistributedHashtableTest = DistributedHashtableTest.class$("org.jgroups.blocks.DistributedHashtableTest")) : class$org$jgroups$blocks$DistributedHashtableTest).getName());
    protected DistributedHashtable queue1;
    protected DistributedHashtable queue2;
    protected DistributedHashtable queue3;
    static /* synthetic */ Class class$org$jgroups$blocks$DistributedHashtableTest;

    public DistributedHashtableTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(class$org$jgroups$blocks$DistributedHashtableTest == null ? (class$org$jgroups$blocks$DistributedHashtableTest = DistributedHashtableTest.class$("org.jgroups.blocks.DistributedHashtableTest")) : class$org$jgroups$blocks$DistributedHashtableTest);
    }

    public void setUp() throws Exception {
        String props = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=5):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):UNICAST(timeout=5000):FRAG(frag_size=8192;down_thread=false;up_thread=false):TOTAL_TOKEN(block_sending=50;unblock_sending=10):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):STATE_TRANSFER:QUEUE";
        Trace.init();
        this.queue1 = new DistributedHashtable("testing", null, props, 10000L);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.queue2 = new DistributedHashtable("testing", null, props, 10000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.queue3 = new DistributedHashtable("testing", null, props, 10000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void tearDown() throws Exception {
        this.queue1.stop();
        this.queue2.stop();
        this.queue3.stop();
    }

    public void testConcurrent() throws Exception {
        PutTask t1 = new PutTask("Queue1", this.queue1);
        PutTask t2 = new PutTask("Queue2", this.queue2);
        PutTask t3 = new PutTask("Queue3", this.queue3);
        Thread rTask1 = new Thread(t1);
        Thread rTask2 = new Thread(t2);
        Thread rTask3 = new Thread(t3);
        rTask1.start();
        rTask2.start();
        rTask3.start();
        while (!(t1.finished() && t2.finished() && t3.finished())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {}
        }
        DistributedHashtableTest.assertEquals((int)this.queue1.size(), (int)this.queue2.size());
        DistributedHashtableTest.assertEquals((int)this.queue1.size(), (int)this.queue3.size());
        DistributedHashtableTest.assertEquals(this.queue1.keySet(), this.queue2.keySet());
        DistributedHashtableTest.assertEquals(this.queue1.keySet(), this.queue3.keySet());
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DistributedHashtableTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PutTask
    implements Runnable {
        protected DistributedHashtable queue;
        protected String name;
        protected boolean finished;

        public PutTask(String name, DistributedHashtable q) {
            this.queue = q;
            this.name = name;
            this.finished = false;
        }

        public void run() {
            Boolean yes = new Boolean(true);
            for (int i = 0; i < 10; ++i) {
                this.queue.put(this.name + "_" + i, yes);
            }
            this.finished = true;
        }

        public boolean finished() {
            return this.finished;
        }
    }
}

