/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.log.Trace;

public class MethodCall
implements Externalizable {
    static final long serialVersionUID = 7873471327078957662L;
    protected String method_name = null;
    protected Object[] args = new Object[0];
    protected Class[] types = null;
    protected String[] signature = null;
    protected Method method = null;
    protected short mode = 1;
    protected static final short OLD = 1;
    protected static final short METHOD = 2;
    protected static final short TYPES = 3;
    protected static final short SIGNATURE = 4;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jgroups$blocks$MethodCall;

    public MethodCall() {
    }

    public MethodCall(Method method) {
        this(method, null);
    }

    public MethodCall(Method method, Object[] arguments) {
        this.init(method);
        if (arguments != null) {
            this.args = arguments;
        }
    }

    public void init(Method method) {
        this.method = method;
        this.mode = (short)2;
        this.method_name = method.getName();
    }

    public MethodCall(String name) {
        this.method_name = name;
    }

    public MethodCall(String name, Object[] args) {
        this(name);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.addArg(args[i]);
            }
        }
    }

    public MethodCall(String name, Object arg1) {
        this(name, new Object[]{arg1});
    }

    public MethodCall(String name, Object arg1, Object arg2) {
        this(name, new Object[]{arg1, arg2});
    }

    public MethodCall(String name, Object arg1, Object arg2, Object arg3) {
        this(name, new Object[]{arg1, arg2, arg3});
    }

    public MethodCall(String name, Object arg1, Object arg2, Object arg3, Object arg4) {
        this(name, new Object[]{arg1, arg2, arg3, arg4});
    }

    public MethodCall(String name, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        this(name, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public MethodCall(String method_name, Object[] args, Class[] types) {
        this.method_name = method_name;
        this.args = args;
        this.types = types;
        this.mode = (short)3;
    }

    public MethodCall(String method_name, Object[] args, String[] signature) {
        this.method_name = method_name;
        this.args = args;
        this.signature = signature;
        this.mode = (short)4;
    }

    public int getMode() {
        return this.mode;
    }

    public void setNumArgs(int num) {
        this.args = new Object[num];
    }

    public String getName() {
        return this.method_name;
    }

    public void setName(String n) {
        this.method_name = n;
    }

    public Vector getArgs() {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < this.args.length; ++i) {
            v.addElement(this.args[i]);
        }
        return v;
    }

    public Method getMethod() {
        return this.method;
    }

    public void addArg(Object arg) {
        Object[] newarg = new Object[this.args.length + 1];
        System.arraycopy(this.args, 0, newarg, 0, this.args.length);
        newarg[this.args.length] = arg;
        this.args = newarg;
    }

    public void addArg(byte b) {
        Byte obj = new Byte(b);
        this.addArg(obj);
    }

    public void addArg(char c) {
        Character obj = new Character(c);
        this.addArg(obj);
    }

    public void addArg(boolean b) {
        Boolean obj = new Boolean(b);
        this.addArg(obj);
    }

    public void addArg(int i) {
        Integer obj = new Integer(i);
        this.addArg(obj);
    }

    public void addArg(long l) {
        Long obj = new Long(l);
        this.addArg(obj);
    }

    public void setArg(int index, Object arg) {
        if (index >= this.args.length) {
            this.addArg(arg);
        } else {
            this.args[index] = arg;
        }
    }

    public void clearArgs() {
        this.args = new Object[0];
    }

    Method findMethod(Class target_class, String method_name, Vector args) throws Exception {
        int len = args != null ? args.size() : 0;
        Class[] formal_parms = new Class[len];
        for (int i = 0; i < len; ++i) {
            formal_parms[i] = args.elementAt(i).getClass();
        }
        Method retval = target_class.getMethod(method_name, formal_parms);
        return retval;
    }

    public Object invoke(Object target, MethodLookup lookup) {
        Method meth = null;
        Object retval = null;
        if (this.method_name == null || target == null) {
            Trace.error("MethodCall.invoke()", "method name or target is null");
            return null;
        }
        Class<?> cl = target.getClass();
        try {
            switch (this.mode) {
                case 1: {
                    if (lookup == null) {
                        meth = this.findMethod(cl, this.method_name, this.getArgs());
                        break;
                    }
                    meth = lookup.findMethod(cl, this.method_name, this.getArgs());
                    break;
                }
                case 2: {
                    if (this.method == null) break;
                    meth = this.method;
                    break;
                }
                case 3: {
                    meth = cl.getMethod(this.method_name, this.types);
                    break;
                }
                case 4: {
                    Class[] mytypes = null;
                    if (this.signature != null) {
                        mytypes = this.getTypesFromString(cl, this.signature);
                    }
                    meth = cl.getMethod(this.method_name, mytypes);
                    break;
                }
                default: {
                    Trace.error("MethodCall.invoke()", "mode " + this.mode + " is invalid");
                }
            }
            if (meth != null) {
                retval = meth.invoke(target, this.args);
            } else {
                Trace.error("MethodCall.invoke()", "method " + this.method_name + " not found");
            }
            return retval;
        }
        catch (IllegalArgumentException illegal_arg) {
            return illegal_arg;
        }
        catch (IllegalAccessException illegal_access) {
            illegal_access.printStackTrace();
            return illegal_access;
        }
        catch (InvocationTargetException inv_ex) {
            return inv_ex.getTargetException();
        }
        catch (NoSuchMethodException no) {
            System.out.print("MethodCall.invoke(): found no method called " + this.method_name + " in class " + cl.getName() + " with [");
            for (int i = 0; i < this.args.length; ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(this.args[i] != null ? this.args[i].getClass().getName() : "null");
            }
            System.out.println("] formal parameters");
            return no;
        }
        catch (Throwable e) {
            Trace.error("MethodCall.invoke()", "exception=" + e);
            return e;
        }
    }

    Class[] getTypesFromString(Class cl, String[] signature) throws Exception {
        Class[] mytypes = new Class[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            String name = signature[i];
            Class<Serializable> parameter = name.equals("long") ? Long.TYPE : (name.equals("int") ? Integer.TYPE : (name.equals("short") ? Short.TYPE : (name.equals("char") ? Character.TYPE : (name.equals("byte") ? Byte.TYPE : (name.equals("float") ? Float.TYPE : (name.equals("double") ? Double.TYPE : Class.forName(name, false, cl.getClassLoader())))))));
            mytypes[i] = parameter;
        }
        return mytypes;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("MethodCall (name=" + this.method_name);
        ret.append(", number of args=" + this.args.length + ")");
        ret.append("\nArgs:");
        for (int i = 0; i < this.args.length; ++i) {
            ret.append("\n[" + this.args[i] + " (" + (this.args[i] != null ? this.args[i].getClass().getName() : "null") + ")]");
        }
        return ret.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.method_name);
        out.writeObject(this.args);
        out.writeShort(this.mode);
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                out.writeObject(this.method.getParameterTypes());
                out.writeObject(this.method.getDeclaringClass());
                break;
            }
            case 3: {
                out.writeObject(this.types);
                break;
            }
            case 4: {
                out.writeObject(this.signature);
                break;
            }
            default: {
                Trace.error("MethodCall.readExternal()", "mode " + this.mode + " is invalid");
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.method_name = in.readUTF();
        this.args = (Object[])in.readObject();
        this.mode = in.readShort();
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                Class[] parametertypes = (Class[])in.readObject();
                Class declaringclass = (Class)in.readObject();
                try {
                    this.method = declaringclass.getMethod(this.method_name, parametertypes);
                    break;
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e.toString());
                }
            }
            case 3: {
                this.types = (Class[])in.readObject();
                break;
            }
            case 4: {
                this.signature = (String[])in.readObject();
                break;
            }
            default: {
                Trace.error("MethodCall.readExternal()", "mode " + this.mode + " is invalid");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        MethodCall m = new MethodCall((class$org$jgroups$blocks$MethodCall == null ? (class$org$jgroups$blocks$MethodCall = MethodCall.class$("org.jgroups.blocks.MethodCall")) : class$org$jgroups$blocks$MethodCall).getMethod("invoke", class$java$lang$Object == null ? (class$java$lang$Object = MethodCall.class$("java.lang.Object")) : class$java$lang$Object));
        m.addArg(m);
        ByteArrayOutputStream msg_data = new ByteArrayOutputStream();
        ObjectOutputStream msg_out = new ObjectOutputStream(msg_data);
        m.writeExternal(msg_out);
        msg_out.flush();
        msg_out.close();
        byte[] data = msg_data.toByteArray();
        ByteArrayInputStream msg_in_data = new ByteArrayInputStream(data);
        ObjectInputStream msg_in = new ObjectInputStream(msg_in_data);
        MethodCall m2 = new MethodCall();
        m2.readExternal(msg_in);
        System.out.println(m2.getName());
        System.out.println(m2.getArgs().size());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

