/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClassPathEntityResolver
implements EntityResolver {
    public String mDefaultJGroupsDTD = "jgroups-protocol.dtd";

    public ClassPathEntityResolver() {
    }

    public ClassPathEntityResolver(String dtdName) {
        this.mDefaultJGroupsDTD = dtdName;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = new InputSource(this.getInputStream(systemId));
        return source;
    }

    protected InputStream getInputStream(String dtdurl) throws IOException {
        String url = dtdurl;
        if (url == null) {
            url = this.mDefaultJGroupsDTD;
        }
        try {
            URL inurl = new URL(url);
            return inurl.openStream();
        }
        catch (Exception ignore) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(url);
            if (stream == null) {
                throw new IOException("Could not locate the DTD with name:[" + url + "] in the classpath.");
            }
            return stream;
        }
    }
}

