/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.conf.ClassMap;
import org.jgroups.conf.ClassPathEntityResolver;
import org.jgroups.log.Trace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MagicNumberReader {
    private static boolean xml_debug = false;
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public String mMagicNumberFile = "jg-magic-map.xml";

    public void setFilename(String file) {
        this.mMagicNumberFile = file;
    }

    public ClassMap[] readMagicNumberMapping() {
        try {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.mMagicNumberFile);
            if (stream == null) {
                Trace.warn("MagicNumberReader.readMagicNumberMapping()", "failed reading " + this.mMagicNumberFile + ". Please make sure it is in the CLASSPATH. Will " + "continue, but marshalling will be slower");
                return new ClassMap[0];
            }
            return MagicNumberReader.parse(stream);
        }
        catch (Exception x) {
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("MagicNumberReader.readMagicNumberMapping()", error);
            return new ClassMap[0];
        }
    }

    protected static ClassMap[] parse(InputStream stream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new ClassPathEntityResolver());
        Document document = builder.parse(stream);
        NodeList class_list = document.getElementsByTagName("class");
        Vector<ClassMap> v = new Vector<ClassMap>();
        for (int i = 0; i < class_list.getLength(); ++i) {
            if (class_list.item(i).getNodeType() != 1) continue;
            v.addElement(MagicNumberReader.parseClassData(class_list.item(i)));
        }
        Object[] data = new ClassMap[v.size()];
        v.copyInto(data);
        return data;
    }

    protected static ClassMap parseClassData(Node protocol) throws IOException {
        try {
            protocol.normalize();
            int pos = 0;
            NodeList children = protocol.getChildNodes();
            String clazzname = null;
            String desc = null;
            String preload = null;
            String magicnumber = null;
            block8: for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                switch (++pos) {
                    case 1: {
                        desc = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 2: {
                        clazzname = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 3: {
                        preload = children.item(i).getFirstChild().getNodeValue();
                        continue block8;
                    }
                    case 4: {
                        magicnumber = children.item(i).getFirstChild().getNodeValue();
                    }
                }
            }
            return new ClassMap(clazzname, desc, Boolean.valueOf(preload), Integer.valueOf(magicnumber));
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            if (xml_debug) {
                x.printStackTrace();
            }
            String error = Trace.getStackTrace(x);
            Trace.error("MagicNumberReader.parseClassData()", error);
            throw new IOException(x.getMessage());
        }
    }
}

