/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;

public class FC
extends Protocol {
    HashMap sent = new HashMap();
    List down_msgs = new LinkedList();
    HashMap received = new HashMap();
    Vector members = new Vector();
    List creditors = new ArrayList();
    long max_credits = 50000L;
    double min_threshold = 0.25;
    long min_credits = 0L;
    boolean blocking = false;
    boolean direct_blocking = true;
    long MAX_BLOCK_TIME = 10000L;

    public String getName() {
        return "FC";
    }

    public boolean setProperties(Properties props) {
        boolean min_credits_set = false;
        String str = props.getProperty("max_credits");
        if (str != null) {
            this.max_credits = Long.parseLong(str);
            props.remove("max_credits");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            this.min_threshold = new Double(str);
            props.remove("min_threshold");
        }
        if ((str = props.getProperty("min_credits")) != null) {
            this.min_credits = Long.parseLong(str);
            props.remove("min_credits");
            min_credits_set = true;
        }
        if (!min_credits_set) {
            this.min_credits = (long)((double)this.max_credits * this.min_threshold);
        }
        if ((str = props.getProperty("direct_blocking")) != null) {
            this.direct_blocking = new Boolean(str);
            props.remove("direct_blocking");
        }
        if (props.size() > 0) {
            System.err.println("FC.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        FC fC = this;
        synchronized (fC) {
            switch (evt.getType()) {
                case 6: {
                    this.handleViewChange(((View)evt.getArg()).getMembers());
                    break;
                }
                case 1: {
                    if (this.handleDownMessage((Message)evt.getArg())) break;
                    return;
                }
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        FC fC = this;
        synchronized (fC) {
            switch (evt.getType()) {
                case 6: {
                    this.handleViewChange(((View)evt.getArg()).getMembers());
                    break;
                }
                case 1: {
                    Message msg = (Message)evt.getArg();
                    FcHeader hdr = (FcHeader)msg.removeHeader(this.getName());
                    if (hdr != null) {
                        if (hdr.type != 1) break;
                        this.handleCredit(msg.getSrc(), hdr.num_credits);
                        return;
                    }
                    this.handleUpMessage(msg);
                }
            }
        }
        this.passUp(evt);
    }

    void handleCredit(Address src, long num_credits) {
        if (src == null) {
            return;
        }
        long new_credits = num_credits + this.getCredits(this.sent, src);
        if (Trace.trace) {
            Trace.info("FC.handleCredit()", "received " + num_credits + " credits from " + src + ", old credit was " + this.sent.get(src) + ", new credits are " + new_credits + ". Creditors are\n" + this.printCreditors());
        }
        this.sent.put(src, new Long(new_credits));
        if (this.creditors.size() > 0) {
            this.removeCreditor(src);
            if (this.blocking && this.creditors.size() == 0) {
                this.unblockSender();
            }
        }
    }

    boolean sendQueuedMessages() {
        if (Trace.trace) {
            Trace.info("FC.sendQueuedMessages()", "sending queued messages (" + this.down_msgs.size() + " msgs)");
        }
        Iterator it = this.down_msgs.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            if (this.decrMessage(msg)) {
                this.passDown(new Event(1, msg));
                it.remove();
                continue;
            }
            return false;
        }
        this.down_msgs.clear();
        return true;
    }

    void handleUpMessage(Message msg) {
        long size;
        Address src = msg.getSrc();
        long l = size = msg.getBuffer() != null ? (long)msg.getBuffer().length : 24L;
        if (src == null) {
            Trace.error("FC.handleUpMessage()", "src is null");
            return;
        }
        if (Trace.trace) {
            Trace.info("FC.handleUpMessage()", "credit for " + src + " is " + this.received.get(src));
        }
        if (this.checkCredit(this.received, src, size, this.min_credits)) {
            this.decrementCredit(this.received, src, size);
        } else {
            this.decrementCredit(this.received, src, size);
            long new_credits = this.max_credits - this.getCredits(this.received, src);
            if (Trace.trace) {
                Trace.info("FC.handleUpMessage()", "sending " + new_credits + " credits to " + src);
            }
            this.sendCredit(src, new_credits);
            this.replenishCredits(this.received, src, new_credits);
        }
    }

    void replenishCredits(HashMap received, Address dest, long new_credits) {
        long tmp_credits = this.getCredits(received, dest);
        received.put(dest, new Long(tmp_credits += new_credits));
    }

    void sendCredit(Address dest, long new_credits) {
        Message msg = new Message(dest, null, null);
        FcHeader hdr = new FcHeader(1, new_credits);
        msg.putHeader(this.getName(), hdr);
        this.passDown(new Event(1, msg));
    }

    boolean handleDownMessage(Message msg) {
        if (this.blocking) {
            if (Trace.trace) {
                Trace.info("FC.handleDownMessage()", "blocking message to " + msg.getDest());
            }
            if (this.direct_blocking) {
                while (this.blocking) {
                    try {
                        this.wait(this.MAX_BLOCK_TIME);
                    }
                    catch (InterruptedException e) {}
                }
            } else {
                this.down_msgs.add(msg);
                return false;
            }
        }
        if (!this.decrMessage(msg)) {
            this.blockSender();
            if (this.direct_blocking) {
                while (this.blocking) {
                    if (Trace.trace) {
                        Trace.info("FC.handleDownMessage()", "blocking " + this.MAX_BLOCK_TIME + " msecs. Creditors are\n" + this.printCreditors());
                    }
                    try {
                        this.wait(this.MAX_BLOCK_TIME);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    if (this.decrMessage(msg)) {
                        return true;
                    }
                    if (!Trace.trace) continue;
                    Trace.info("FC.handleDownMessage()", "insufficient credits to send message, creditors=\n" + this.printCreditors());
                }
            } else {
                this.down_msgs.add(msg);
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean decrMessage(Message msg) {
        long size;
        boolean success = true;
        if (msg == null) {
            Trace.error("FC.decrMessage()", "msg is null");
            return false;
        }
        Address dest = msg.getDest();
        long l = size = msg.getBuffer() != null ? (long)msg.getBuffer().length : 24L;
        if (dest != null && !dest.isMulticastAddress()) {
            if (Trace.trace) {
                Trace.info("FC.decrMessage()", "credit for " + dest + " is " + this.sent.get(dest));
            }
            if (this.sufficientCredit(this.sent, dest, size)) {
                this.decrementCredit(this.sent, dest, size);
                return success;
            }
            this.addCreditor(dest);
            return false;
        }
        Iterator it = this.members.iterator();
        while (it.hasNext()) {
            dest = (Address)it.next();
            if (Trace.trace) {
                Trace.info("FC.decrMessage()", "credit for " + dest + " is " + this.sent.get(dest));
            }
            if (this.sufficientCredit(this.sent, dest, size)) continue;
            this.addCreditor(dest);
            success = false;
        }
        if (!success) return success;
        it = this.members.iterator();
        while (it.hasNext()) {
            dest = (Address)it.next();
            this.decrementCredit(this.sent, dest, size);
        }
        return success;
    }

    void blockSender() {
        if (!this.direct_blocking) {
            this.passUp(new Event(54));
        }
        if (Trace.trace) {
            Trace.info("FC.blockSender()", "setting blocking=true; creditors are:\n" + this.printCreditors());
        }
        this.blocking = true;
    }

    void unblockSender() {
        if (Trace.trace) {
            Trace.info("FC.unblockSender()", "setting blocking=false");
        }
        if (this.direct_blocking) {
            this.blocking = false;
            this.notifyAll();
        } else if (this.sendQueuedMessages()) {
            this.passUp(new Event(55));
            this.blocking = false;
        }
    }

    String printCreditors() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.creditors.iterator();
        while (it.hasNext()) {
            Address creditor = (Address)it.next();
            sb.append(creditor).append(": ").append(this.getCredits(this.sent, creditor)).append(" credits\n");
        }
        return sb.toString();
    }

    void addCreditor(Address mbr) {
        if (mbr != null && !this.creditors.contains(mbr)) {
            this.creditors.add(mbr);
        }
    }

    void removeCreditor(Address mbr) {
        if (mbr != null) {
            this.creditors.remove(mbr);
        }
    }

    long getCredits(Map map, Address mbr) {
        Long tmp = (Long)map.get(mbr);
        if (tmp == null) {
            map.put(mbr, new Long(this.max_credits));
            return this.max_credits;
        }
        return tmp;
    }

    boolean sufficientCredit(Map map, Address mbr, long credits_required) {
        return this.checkCredit(map, mbr, credits_required, 0L);
    }

    boolean checkCredit(Map map, Address mbr, long credits_required, long min_credits) {
        Long tmp = (Long)map.get(mbr);
        if (tmp != null) {
            long credits_left = tmp;
            if (credits_left - credits_required >= min_credits) {
                return true;
            }
            Trace.info("FC.checkCredit()", "insufficient credit for " + mbr + ": credits left=" + credits_left + ", credits required=" + credits_required + " (min_credits=" + min_credits + ")");
            return false;
        }
        map.put(mbr, new Long(this.max_credits - credits_required));
        return true;
    }

    void decrementCredit(HashMap map, Address dest, long credits_required) {
        Long tmp = (Long)map.get(dest);
        if (tmp != null) {
            long credits_left = tmp;
            if (credits_left - credits_required >= 0L) {
                map.put(dest, new Long(credits_left - credits_required));
            } else {
                Trace.error("FC.decrementCredit()", "not enough credits left for " + dest + ": left=" + credits_left + ", required=" + credits_required);
            }
        } else {
            map.put(dest, new Long(this.max_credits - credits_required));
        }
    }

    void handleViewChange(Vector mbrs) {
        Address addr;
        if (mbrs == null) {
            return;
        }
        if (Trace.trace) {
            Trace.info("FC.handleViewChange()", "new membership: " + mbrs);
        }
        this.members.clear();
        this.members.addAll(mbrs);
        for (int i = 0; i < mbrs.size(); ++i) {
            addr = (Address)mbrs.elementAt(i);
            if (this.sent.containsKey(addr)) continue;
            this.sent.put(addr, new Long(this.max_credits));
        }
        Iterator it = this.sent.keySet().iterator();
        while (it.hasNext()) {
            addr = (Address)it.next();
            if (mbrs.contains(addr)) continue;
            it.remove();
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            addr = (Address)mbrs.elementAt(i);
            if (this.received.containsKey(addr)) continue;
            this.received.put(addr, new Long(this.max_credits));
        }
        Iterator<Object> it2 = this.received.keySet().iterator();
        while (it2.hasNext()) {
            addr = (Address)it2.next();
            if (mbrs.contains(addr)) continue;
            it2.remove();
        }
        it2 = this.creditors.iterator();
        while (it2.hasNext()) {
            Address creditor = (Address)it2.next();
            if (mbrs.contains(creditor)) continue;
            it2.remove();
        }
        if (Trace.trace) {
            Trace.info("FC.handleViewChange()", "creditors are\n" + this.printCreditors());
        }
        if (this.creditors.size() == 0 && this.blocking) {
            this.unblockSender();
        }
    }

    String dumpSentMessages() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.sent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    String dumpReceivedMessages() {
        Map tmp = (Map)this.received.clone();
        StringBuffer sb = new StringBuffer();
        Iterator it = tmp.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    String dumpMessages() {
        StringBuffer sb = new StringBuffer();
        sb.append("sent:\n").append(this.sent).append("\n");
        sb.append("received:\n").append(this.received).append("\n");
        return sb.toString();
    }

    public static class FcHeader
    extends Header {
        public static final int CREDIT = 1;
        int type = 1;
        long num_credits = 0L;

        public FcHeader() {
        }

        public FcHeader(int type, long num_credits) {
            this.type = type;
            this.num_credits = num_credits;
        }

        public long size() {
            return 24L;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.num_credits);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.num_credits = in.readLong();
        }
    }
}

