/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class TCPGOSSIP
extends Protocol {
    Vector members = new Vector();
    Vector initial_members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    String groupname = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    Vector initial_hosts = null;
    boolean is_server = false;
    GossipClient gossip_client = null;
    long gossip_refresh_rate = 20000L;

    public String getName() {
        return "TCPGOSSIP";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("gossip_refresh_rate")) != null) {
            this.gossip_refresh_rate = new Integer(str).intValue();
            props.remove("gossip_refresh_rate");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        if (props.size() > 0) {
            System.err.println("TCPGOSSIP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        if (this.initial_hosts == null || this.initial_hosts.size() == 0) {
            Trace.error("TCPGOSSIP.setProperties()", "initial_hosts must contain the address of at least one GossipServer");
            return false;
        }
        this.gossip_client = new GossipClient(this.initial_hosts, this.gossip_refresh_rate);
        return true;
    }

    public void init() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                Trace.warn("TCPGOSSIP.up()", "got TCPGOSSIP header with unknown type (" + hdr.type + ")");
                return;
            }
            case 3: {
                if (this.group_addr == null || this.local_addr == null) {
                    Trace.error("TCPGOSSIP.up()", "[CONNECT_OK]: group_addr or local_addr is null. cannot register with GossipServer(s)");
                    break;
                }
                if (Trace.trace) {
                    Trace.info("TCPGOSSIP.up()", "[CONNECT_OK]: registering " + this.local_addr + " under " + this.group_addr + " with GossipServer");
                }
                this.gossip_client.register(this.group_addr, this.local_addr);
                break;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                Vector tmp_mbrs;
                this.initial_members.removeAllElements();
                if (this.group_addr == null) {
                    Trace.error("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS]: group_addr is null, cannot get mbrship");
                    this.passUp(new Event(13, this.initial_members));
                    break;
                }
                if (Trace.trace) {
                    Trace.info("TCPGOSSIP.down()", "fetching members from GossipServer(s)");
                }
                if ((tmp_mbrs = this.gossip_client.getMembers(this.group_addr)) == null || tmp_mbrs.size() == 0) {
                    Trace.error("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS]: gossip client found no members");
                    this.passUp(new Event(13, this.initial_members));
                }
                if (Trace.trace) {
                    Trace.info("TCPGOSSIP.down()", "consolidated mbrs from GossipServer(s) are " + tmp_mbrs);
                }
                PingHeader hdr = new PingHeader(1, null);
                Message msg = new Message(null, null, null);
                msg.putHeader(this.getName(), hdr);
                for (int i = 0; i < tmp_mbrs.size(); ++i) {
                    IpAddress mbr_addr = (IpAddress)tmp_mbrs.elementAt(i);
                    Message copy = msg.copy();
                    copy.setDest(mbr_addr);
                    if (Trace.trace) {
                        Trace.info("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS] sending PING request to " + copy.getDest());
                    }
                    this.passDown(new Event(1, copy));
                }
                Vector i = this.initial_members;
                synchronized (i) {
                    long start_time = System.currentTimeMillis();
                    for (long time_to_wait = this.timeout; (long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L; time_to_wait -= System.currentTimeMillis() - start_time) {
                        try {
                            this.initial_members.wait(time_to_wait);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (Trace.trace) {
                    Trace.info("TCPGOSSIP.down()", "[FIND_INITIAL_MBRS] initial members are " + this.initial_members);
                }
                this.passUp(new Event(13, this.initial_members));
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.removeAllElements();
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.members.addElement(tmp.elementAt(i));
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 4: {
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private Vector createInitialHosts(String l) {
        Vector<IpAddress> tmp = new Vector<IpAddress>();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                int port = new Integer(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                IpAddress addr = new IpAddress(host, port);
                tmp.addElement(addr);
            }
            catch (NumberFormatException e) {
                Trace.error("TCPGOSSIP.createInitialHosts()", "exeption is " + e);
            }
        }
        return tmp;
    }
}

