/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;

public class UDP
extends Protocol
implements Runnable {
    DatagramSocket send_sock = null;
    DatagramSocket ucast_recv_sock = null;
    MulticastSocket mcast_sock = null;
    IpAddress local_addr = null;
    String group_addr = null;
    IpAddress mcast_addr = null;
    InetAddress bind_addr = null;
    int bind_port = 0;
    int port_range = 1;
    String mcast_addr_name = "228.8.8.8";
    int mcast_port = 7600;
    Thread mcast_receiver = null;
    UcastReceiver ucast_receiver = null;
    boolean ip_mcast = true;
    int ip_ttl = 64;
    Vector members = new Vector();
    ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);
    UdpHeader udp_hdr = null;
    int mcast_send_buf_size = 32000;
    int mcast_recv_buf_size = 64000;
    int ucast_send_buf_size = 32000;
    int ucast_recv_buf_size = 64000;
    boolean loopback = true;
    boolean use_packet_handler = false;
    Queue packet_queue = null;
    byte[] additional_data = null;
    PacketHandler packet_handler = null;
    final String name = "UDP";
    final int VERSION_LENGTH = Version.getLength();

    public String toString() {
        return "Protocol UDP(local address: " + this.local_addr + ")";
    }

    public void run() {
        byte[] receive_buf = new byte[65000];
        DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
        while (this.mcast_receiver != null && this.mcast_sock != null) {
            try {
                byte[] tmp;
                packet.setData(receive_buf, 0, receive_buf.length);
                this.mcast_sock.receive(packet);
                int len = packet.getLength();
                if (len == 1 && packet.getData()[0] == 0) continue;
                if (len == 4 && (tmp = packet.getData())[0] == 100 && tmp[1] == 105 && tmp[2] == 97 && tmp[3] == 103) {
                    this.handleDiagnosticProbe(packet.getAddress(), packet.getPort());
                    continue;
                }
                if (len > receive_buf.length) {
                    Trace.error("UDP.run()", "size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length);
                }
                if (!Version.compareTo(packet.getData())) {
                    Trace.warn("UDP.run()", "packet from " + packet.getAddress() + ":" + packet.getPort() + " has different version (" + Version.printVersionId(packet.getData(), Version.version_id.length) + ") from ours (" + Version.printVersionId(Version.version_id) + "). This may cause problems");
                }
                if (this.use_packet_handler) {
                    byte[] tmp1 = packet.getData();
                    byte[] tmp2 = new byte[len];
                    System.arraycopy(tmp1, 0, tmp2, 0, len);
                    this.packet_queue.add(tmp2);
                    continue;
                }
                this.handleIncomingUdpPacket(packet.getData());
            }
            catch (SocketException sock_ex) {
                if (!Trace.trace) break;
                Trace.info("UDP.run()", "multicast socket is closed, exception=" + sock_ex);
                break;
            }
            catch (InterruptedIOException io_ex) {
            }
            catch (Throwable ex) {
                Trace.error("UDP.run()", "exception=" + ex + ", stack trace=" + Util.printStackTrace(ex));
                Util.sleep(1000L);
            }
        }
        if (Trace.trace) {
            Trace.info("UDP.run()", "multicast thread terminated");
        }
    }

    void handleDiagnosticProbe(InetAddress sender, int port) {
        try {
            byte[] diag_rsp = this.getDiagResponse().getBytes();
            DatagramPacket rsp = new DatagramPacket(diag_rsp, 0, diag_rsp.length, sender, port);
            if (Trace.trace) {
                Trace.info("UDP.handleDiagnosticProbe()", "sending diag response to " + sender + ":" + port);
            }
            this.send_sock.send(rsp);
        }
        catch (Throwable t) {
            Trace.error("UDP.handleDiagnosticProbe()", "failed sending diag rsp to " + sender + ":" + port + ", exception=" + t);
        }
    }

    String getDiagResponse() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.local_addr).append(" (").append(this.group_addr).append(")");
        sb.append(" [").append(this.mcast_addr_name).append(":").append(this.mcast_port).append("]\n");
        sb.append("Version=").append(Version.version).append(", cvs=\"").append(Version.cvs).append("\"\n");
        sb.append("bound to ").append(this.bind_addr).append(":").append(this.bind_port).append("\n");
        sb.append("members: ").append(this.members).append("\n");
        return sb.toString();
    }

    public String getName() {
        return "UDP";
    }

    public void init() throws Exception {
        if (this.use_packet_handler) {
            this.packet_queue = new Queue();
            this.packet_handler = new PacketHandler();
        }
    }

    public void start() throws Exception {
        if (Trace.trace) {
            Trace.info("UDP.start()", "creating sockets and starting threads");
        }
        this.createSockets();
        this.passUp(new Event(8, this.local_addr));
        this.startThreads();
    }

    public void stop() {
        if (Trace.trace) {
            Trace.info("UDP.stop()", "closing sockets and stopping threads");
        }
        this.stopThreads();
        this.closeSockets();
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                Trace.fatal("UDP.setProperties()", "(bind_addr): host " + str + " not known");
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("bind_port")) != null) {
            this.bind_port = new Integer(str);
            props.remove("bind_port");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.bind_port = new Integer(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = new Integer(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("mcast_addr")) != null) {
            this.mcast_addr_name = new String(str);
            props.remove("mcast_addr");
        }
        if ((str = props.getProperty("mcast_port")) != null) {
            this.mcast_port = new Integer(str);
            props.remove("mcast_port");
        }
        if ((str = props.getProperty("ip_mcast")) != null) {
            this.ip_mcast = new Boolean(str);
            props.remove("ip_mcast");
        }
        if ((str = props.getProperty("ip_ttl")) != null) {
            this.ip_ttl = new Integer(str);
            props.remove("ip_ttl");
        }
        if ((str = props.getProperty("mcast_send_buf_size")) != null) {
            this.mcast_send_buf_size = Integer.parseInt(str);
            props.remove("mcast_send_buf_size");
        }
        if ((str = props.getProperty("mcast_recv_buf_size")) != null) {
            this.mcast_recv_buf_size = Integer.parseInt(str);
            props.remove("mcast_recv_buf_size");
        }
        if ((str = props.getProperty("ucast_send_buf_size")) != null) {
            this.ucast_send_buf_size = Integer.parseInt(str);
            props.remove("ucast_send_buf_size");
        }
        if ((str = props.getProperty("ucast_recv_buf_size")) != null) {
            this.ucast_recv_buf_size = Integer.parseInt(str);
            props.remove("ucast_recv_buf_size");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = new Boolean(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("use_packet_handler")) != null) {
            this.use_packet_handler = new Boolean(str);
            props.remove("use_packet_handler");
        }
        if (props.size() > 0) {
            System.err.println("UDP.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void up(Event evt) {
        this.passUp(evt);
        switch (evt.getType()) {
            case 56: {
                this.passUp(evt);
                if (Trace.trace) {
                    Trace.info("UDP.up()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        Message msg = (Message)evt.getArg();
        if (this.udp_hdr != null && this.udp_hdr.group_addr != null) {
            msg.putHeader("UDP", this.udp_hdr);
        }
        Address dest_addr = msg.getDest();
        if (this.observer != null) {
            this.observer.passDown(evt);
        }
        if (dest_addr == null) {
            if (this.ip_mcast) {
                if (this.mcast_addr == null) {
                    Trace.error("UDP.down()", "dest address of message is null, and sending to default address fails as mcast_addr is null, too ! Discarding message " + Util.printEvent(evt));
                    return;
                }
                msg.setDest(this.mcast_addr);
            } else {
                this.sendMultipleUdpMessages(msg, this.members);
                return;
            }
        }
        try {
            this.sendUdpMessage(msg);
        }
        catch (Exception e) {
            Trace.error("UDP.down()", "exception=" + e + ", msg=" + msg + ", mcast_addr=" + this.mcast_addr);
        }
    }

    void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    void handleIncomingUdpPacket(byte[] data) {
        Event evt;
        Message msg = null;
        UdpHeader hdr = null;
        try {
            ByteArrayInputStream inp_stream = new ByteArrayInputStream(data, this.VERSION_LENGTH, data.length - this.VERSION_LENGTH);
            ObjectInputStream inp = new ObjectInputStream(inp_stream);
            msg = new Message();
            msg.readExternal(inp);
            if (this.loopback) {
                Address dst = msg.getDest();
                Address src = msg.getSrc();
                if (dst != null && dst.isMulticastAddress() && src != null && this.local_addr.equals(src)) {
                    return;
                }
            }
            evt = new Event(1, msg);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            hdr = (UdpHeader)msg.removeHeader("UDP");
        }
        catch (Throwable e) {
            Trace.error("UDP.handleIncomingUdpPacket()", "exception=" + Trace.getStackTrace(e));
            return;
        }
        if (hdr != null) {
            String ch_name = null;
            if (hdr.group_addr != null) {
                ch_name = hdr.group_addr;
            }
            if (ch_name != null && this.group_addr != null && !this.group_addr.equals(ch_name) && !ch_name.equals("DIAG_GROUP-BELA-322649")) {
                if (Trace.trace) {
                    Trace.warn("UDP.handleIncomingUdpPacket()", "discarded message from different group (" + ch_name + "). Sender was " + msg.getSrc());
                }
                return;
            }
        }
        this.passUp(evt);
    }

    void sendUdpMessage(Message msg) throws Exception {
        IpAddress dest = (IpAddress)msg.getDest();
        this.setSourceAddress(msg);
        if (this.loopback && (dest.equals(this.local_addr) || dest.isMulticastAddress())) {
            Message copy = msg.copy();
            copy.removeHeader("UDP");
            copy.setSrc(this.local_addr);
            copy.setDest(dest);
            Event evt = new Event(1, copy);
            if (this.observer != null) {
                this.observer.up(evt, this.up_queue.size());
            }
            this.passUp(evt);
            if (!dest.isMulticastAddress()) {
                return;
            }
        }
        this.out_stream.reset();
        this.out_stream.write(Version.version_id, 0, Version.version_id.length);
        ObjectOutputStream out = new ObjectOutputStream(this.out_stream);
        msg.writeExternal(out);
        out.flush();
        byte[] buf = this.out_stream.toByteArray();
        DatagramPacket packet = new DatagramPacket(buf, buf.length, dest.getIpAddress(), dest.getPort());
        if (dest.getIpAddress().isMulticastAddress()) {
            try {
                this.mcast_sock.send(packet);
            }
            catch (Throwable e) {
                Trace.error("UDP.sendUdpMessage()", "exception sending mcast message: " + e);
            }
        } else if (this.send_sock != null) {
            try {
                this.send_sock.send(packet);
            }
            catch (Throwable e) {
                Trace.error("UDP.sendUdpMessage()", "exception sending ucast message: " + e);
            }
        } else {
            Trace.error("UDP.sendUdpMessage()", "(unicast) send_sock is null. Message is " + msg + ", headers are " + msg.getHeaders());
        }
    }

    void sendMultipleUdpMessages(Message msg, Vector dests) {
        for (int i = 0; i < dests.size(); ++i) {
            Address dest = (Address)dests.elementAt(i);
            msg.setDest(dest);
            try {
                this.sendUdpMessage(msg);
                continue;
            }
            catch (Exception e) {
                Trace.debug("UDP.sendMultipleUdpMessages()", "exception=" + e);
            }
        }
    }

    void createSockets() throws Exception {
        InetAddress[] interfaces;
        InetAddress tmp_addr = null;
        if (this.bind_addr == null && (interfaces = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress())) != null && interfaces.length > 0) {
            this.bind_addr = interfaces[0];
        }
        if (this.bind_addr == null) {
            this.bind_addr = InetAddress.getLocalHost();
        }
        if (this.bind_addr != null && Trace.trace) {
            Trace.info("UDP.createSockets()", "unicast sockets will use interface " + this.bind_addr.getHostAddress());
        }
        this.send_sock = new DatagramSocket(0, this.bind_addr);
        int rcv_port = this.bind_port;
        int max_port = this.bind_port + this.port_range;
        while (rcv_port <= max_port) {
            try {
                this.ucast_recv_sock = new DatagramSocket(rcv_port, this.bind_addr);
                break;
            }
            catch (SocketException bind_ex) {
                ++rcv_port;
            }
            catch (SecurityException sec_ex) {
                ++rcv_port;
            }
            if (rcv_port != max_port + 1) continue;
            throw new Exception("UDP.createSockets(): cannot list on any port in range " + this.bind_port + "-" + (this.bind_port + this.port_range));
        }
        this.local_addr = new IpAddress(this.ucast_recv_sock.getLocalAddress(), this.ucast_recv_sock.getLocalPort());
        if (this.additional_data != null) {
            this.local_addr.setAdditionalData(this.additional_data);
        }
        if (this.ip_mcast) {
            this.mcast_sock = new MulticastSocket(this.mcast_port);
            this.mcast_sock.setTimeToLive(this.ip_ttl);
            if (this.bind_addr != null) {
                this.mcast_sock.setInterface(this.bind_addr);
            }
            tmp_addr = InetAddress.getByName(this.mcast_addr_name);
            this.mcast_addr = new IpAddress(tmp_addr, this.mcast_port);
            this.mcast_sock.joinGroup(tmp_addr);
        }
        this.setBufferSizes();
        if (Trace.trace) {
            Trace.info("UDP.createSockets()", "socket information:\n" + this.dumpSocketInfo());
        }
    }

    String dumpSocketInfo() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("local_addr=").append(this.local_addr);
        sb.append(", mcast_addr=").append(this.mcast_addr);
        sb.append(", bind_addr=").append(this.bind_addr);
        sb.append(", ttl=").append(this.ip_ttl);
        if (this.send_sock != null) {
            sb.append("\nsend socket: bound to ");
            sb.append(this.send_sock.getLocalAddress().getHostAddress()).append(":").append(this.send_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.send_sock.getSendBufferSize());
        }
        if (this.ucast_recv_sock != null) {
            sb.append("\nreceive socket: bound to ");
            sb.append(this.ucast_recv_sock.getLocalAddress().getHostAddress()).append(":").append(this.ucast_recv_sock.getLocalPort());
            sb.append(", receive buffer size=").append(this.ucast_recv_sock.getReceiveBufferSize());
        }
        if (this.mcast_sock != null) {
            sb.append("\nmulticast socket: bound to ");
            sb.append(this.mcast_sock.getInterface().getHostAddress()).append(":").append(this.mcast_sock.getLocalPort());
            sb.append(", send buffer size=").append(this.mcast_sock.getSendBufferSize());
            sb.append(", receive buffer size=").append(this.mcast_sock.getReceiveBufferSize());
        }
        return sb.toString();
    }

    void setBufferSizes() {
        if (this.send_sock != null) {
            try {
                this.send_sock.setSendBufferSize(this.ucast_send_buf_size);
            }
            catch (Throwable ex) {
                Trace.warn("UDP.setBufferSizes()", "failed setting ucast_send_buf_size in send_sock: " + ex);
            }
        }
        if (this.ucast_recv_sock != null) {
            try {
                this.ucast_recv_sock.setReceiveBufferSize(this.ucast_recv_buf_size);
            }
            catch (Throwable ex) {
                Trace.warn("UDP.setBufferSizes()", "failed setting ucast_recv_buf_size in ucast_recv_sock: " + ex);
            }
        }
        if (this.mcast_sock != null) {
            try {
                this.mcast_sock.setSendBufferSize(this.mcast_send_buf_size);
            }
            catch (Throwable ex) {
                Trace.warn("UDP.setBufferSizes()", "failed setting mcast_send_buf_size in mcast_sock: " + ex);
            }
            try {
                this.mcast_sock.setReceiveBufferSize(this.mcast_recv_buf_size);
            }
            catch (Throwable ex) {
                Trace.warn("UDP.setBufferSizes()", "failed setting mcast_recv_buf_size in mcast_sock: " + ex);
            }
        }
    }

    void closeSockets() {
        this.closeMulticastSocket();
        this.closeUnicastReceiverSocket();
        this.closeUnicastSenderSocket();
    }

    void closeMulticastSocket() {
        if (this.mcast_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    this.sendDummyPacket(this.mcast_addr.getIpAddress(), this.mcast_addr.getPort());
                    Util.sleep(300L);
                    this.mcast_sock.leaveGroup(this.mcast_addr.getIpAddress());
                }
                this.mcast_sock.close();
                this.mcast_sock = null;
                if (Trace.trace) {
                    Trace.info("UDP.closeMulticastSocket()", "multicast socket closed");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
    }

    void closeUnicastReceiverSocket() {
        if (this.ucast_recv_sock != null) {
            this.sendDummyPacket(this.ucast_recv_sock.getLocalAddress(), this.ucast_recv_sock.getLocalPort());
            this.ucast_recv_sock.close();
            this.ucast_recv_sock = null;
            if (Trace.trace) {
                Trace.info("UDP.closeMulticastSocket()", "unicast receiver socket closed");
            }
        }
    }

    void closeUnicastSenderSocket() {
        if (this.send_sock != null) {
            this.send_sock.close();
            this.send_sock = null;
            if (Trace.trace) {
                Trace.info("UDP.closeMulticastSocket()", "unicast sender socket closed");
            }
        }
    }

    void sendDummyPacket(InetAddress dest, int port) {
        byte[] buf = new byte[]{0};
        if (dest == null) {
            try {
                dest = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.send_sock == null || dest == null) {
            Trace.warn("UDP.sendDummyPacket()", "send_sock was null or dest was null, cannot send dummy packet");
            return;
        }
        DatagramPacket packet = new DatagramPacket(buf, buf.length, dest, port);
        try {
            this.send_sock.send(packet);
        }
        catch (Throwable e) {
            Trace.error("UDP.sendDummyPacket()", "exception sending dummy packet to " + dest + ":" + port + ": " + e);
        }
    }

    void startThreads() throws Exception {
        if (this.ucast_receiver == null) {
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            if (Trace.trace) {
                Trace.info("UDP.startThreads()", "created unicast receiver thread");
            }
        }
        if (this.ip_mcast) {
            if (this.mcast_receiver != null) {
                if (this.mcast_receiver.isAlive()) {
                    if (Trace.trace) {
                        Trace.info("UDP.createThreads()", "did not create new multicastreceiver thread as existing multicast receiver thread is still running");
                    }
                } else {
                    this.mcast_receiver = null;
                }
            }
            if (this.mcast_receiver == null) {
                this.mcast_receiver = new Thread((Runnable)this, "UDP mcast receiver");
                this.mcast_receiver.setPriority(10);
                this.mcast_receiver.setDaemon(true);
                this.mcast_receiver.start();
            }
        }
        if (this.use_packet_handler) {
            this.packet_handler.start();
        }
    }

    void stopThreads() {
        if (this.mcast_receiver != null) {
            if (this.mcast_receiver.isAlive()) {
                Thread tmp = this.mcast_receiver;
                this.mcast_receiver = null;
                this.closeMulticastSocket();
                tmp.interrupt();
                try {
                    tmp.join(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object var1_1 = null;
            }
            this.mcast_receiver = null;
        }
        if (this.ucast_receiver != null) {
            this.ucast_receiver.stop();
            this.ucast_receiver = null;
        }
        if (this.packet_handler != null) {
            this.packet_handler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.udp_hdr = new UdpHeader(this.group_addr);
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 56: {
                if (Trace.trace) {
                    Trace.info("UDP.down()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
        }
        this.setBufferSizes();
    }

    class PacketHandler
    implements Runnable {
        Thread t = null;

        PacketHandler() {
        }

        public void run() {
            while (UDP.this.packet_queue != null && UDP.this.packet_handler != null) {
                byte[] data;
                try {
                    data = (byte[])UDP.this.packet_queue.remove();
                }
                catch (QueueClosedException closed_ex) {
                    if (!Trace.trace) break;
                    Trace.info("UDP.PacketHandler.run()", "packet_handler thread terminating");
                    break;
                }
                UDP.this.handleIncomingUdpPacket(data);
                data = null;
            }
        }

        void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "UDP.PacketHandler thread");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            if (UDP.this.packet_queue != null) {
                UDP.this.packet_queue.close(false);
            }
            this.t = null;
            UDP.this.packet_queue = null;
        }
    }

    public class UcastReceiver
    implements Runnable {
        boolean running = true;
        Thread thread = null;

        public void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "UDP.UcastReceiverThread");
                this.thread.setDaemon(true);
                this.running = true;
                this.thread.start();
            }
        }

        public void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.running = false;
                Thread tmp = this.thread;
                this.thread = null;
                UDP.this.closeUnicastReceiverSocket();
                tmp.interrupt();
                Object var1_1 = null;
            }
            this.thread = null;
        }

        public void run() {
            byte[] receive_buf = new byte[65535];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (this.running && this.thread != null && UDP.this.ucast_recv_sock != null) {
                try {
                    packet.setData(receive_buf, 0, receive_buf.length);
                    UDP.this.ucast_recv_sock.receive(packet);
                    int len = packet.getLength();
                    if (len == 1 && packet.getData()[0] == 0) continue;
                    if (len > receive_buf.length) {
                        Trace.error("UDP.UcastReceiver.run()", "size of the received packet (" + len + ") is bigger than " + "allocated buffer (" + receive_buf.length + "): will not be able to handle packet. " + "Use the FRAG protocol and make its frag_size lower than " + receive_buf.length);
                    }
                    if (!Version.compareTo(packet.getData())) {
                        Trace.warn("UDP.UcastReceiver.run()", "packet from " + packet.getAddress() + ":" + packet.getPort() + " has different version (" + Version.printVersionId(packet.getData(), Version.version_id.length) + ") from ours (" + Version.printVersionId(Version.version_id) + "). This may cause problems");
                    }
                    if (UDP.this.use_packet_handler) {
                        byte[] tmp1 = packet.getData();
                        byte[] tmp2 = new byte[len];
                        System.arraycopy(tmp1, 0, tmp2, 0, len);
                        UDP.this.packet_queue.add(tmp2);
                        continue;
                    }
                    UDP.this.handleIncomingUdpPacket(packet.getData());
                }
                catch (SocketException sock_ex) {
                    if (!Trace.trace) break;
                    Trace.info("UDP.UcastReceiver.run()", "unicast receiver socket is closed, exception=" + sock_ex);
                    break;
                }
                catch (InterruptedIOException io_ex) {
                }
                catch (Throwable ex) {
                    Trace.error("UDP.UcastReceiver.run()", "[" + UDP.this.local_addr + "] exception=" + ex + ", stack trace=" + Util.printStackTrace(ex));
                    Util.sleep(1000L);
                }
            }
            if (Trace.trace) {
                Trace.info("UDP.UcastReceiver.run()", "unicast receiver thread terminated");
            }
        }
    }
}

