/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.ring;

import java.io.Serializable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.TOTAL_TOKEN;
import org.jgroups.protocols.ring.RingNode;
import org.jgroups.protocols.ring.TokenLostException;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RpcProtocol;

public class UdpRingNode
implements RingNode {
    Address thisNode;
    Address nextNode;
    RpcProtocol rpcProtocol;
    Object token;
    Object mutex = new Object();
    TOTAL_TOKEN.RingTokenHeader tokenHeader;
    boolean tokenInStack = false;

    public UdpRingNode(RpcProtocol owner, Address memberAddress) {
        this.rpcProtocol = owner;
        this.thisNode = memberAddress;
        this.nextNode = null;
        this.tokenHeader = new TOTAL_TOKEN.RingTokenHeader();
    }

    public IpAddress getTokenReceiverAddress() {
        return (IpAddress)this.thisNode;
    }

    public synchronized void tokenArrived(Object token) {
        this.tokenInStack = true;
        this.token = token;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receiveToken(int timeout) throws TokenLostException {
        Address wasNext = this.nextNode;
        try {
            UdpRingNode udpRingNode = this;
            synchronized (udpRingNode) {
                if (!this.tokenInStack) {
                    this.wait(timeout);
                }
                if (!this.tokenInStack) {
                    throw new TokenLostException("Token wait timout expired", null, wasNext, TokenLostException.WHILE_RECEIVING);
                }
            }
        }
        catch (InterruptedException ie) {
            throw new TokenLostException("Token thread interrupted", (Throwable)ie, wasNext, TokenLostException.WHILE_RECEIVING);
        }
        return this.token;
    }

    public Object receiveToken() throws TokenLostException {
        return this.receiveToken(0);
    }

    public synchronized void passToken(Object token) {
        Message t = new Message(this.nextNode, this.thisNode, (Serializable)token);
        t.putHeader("TOTAL_TOKEN", this.tokenHeader);
        this.rpcProtocol.passDown(new Event(1, t));
        this.tokenInStack = false;
    }

    public synchronized void reconfigure(Vector newMembers) {
        if (this.isNextNeighbourChanged(newMembers)) {
            this.nextNode = this.getNextNode(newMembers);
        }
    }

    private boolean isNextNeighbourChanged(Vector newMembers) {
        Address oldNeighbour = this.nextNode;
        Address newNeighbour = this.getNextNode(newMembers);
        return !newNeighbour.equals(oldNeighbour);
    }

    private Address getNextNode(Vector otherNodes) {
        int myIndex = otherNodes.indexOf(this.thisNode);
        return myIndex == otherNodes.size() - 1 ? (Address)otherNodes.firstElement() : (Address)otherNodes.elementAt(myIndex + 1);
    }
}

