/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import org.jgroups.Event;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;

class DownHandler
extends Thread {
    private Queue mq = null;
    private Protocol handler = null;
    private ProtocolObserver observer = null;

    public DownHandler(Queue mq, Protocol handler, ProtocolObserver observer) {
        this.mq = mq;
        this.handler = handler;
        this.observer = observer;
        if (handler != null) {
            this.setName("DownHandler (" + handler.getName() + ")");
        } else {
            this.setName("DownHandler");
        }
    }

    public void setObserver(ProtocolObserver observer) {
        this.observer = observer;
    }

    public void run() {
        while (!this.mq.closed()) {
            try {
                Event evt = (Event)this.mq.remove();
                if (evt == null) {
                    Trace.warn("Protocol.DownHandler.run()", "removed null event");
                    continue;
                }
                if (this.observer != null && !this.observer.down(evt, this.mq.size())) continue;
                this.handler.down(evt);
                evt = null;
            }
            catch (QueueClosedException queue_closed) {
                break;
            }
            catch (Throwable e) {
                Trace.warn("Protocol.DownHandler.run()", this.getName() + " exception is " + e);
                e.printStackTrace();
            }
        }
    }
}

