/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.Serializable;
import java.net.Socket;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.protocols.TunnelHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.List;
import org.jgroups.util.Util;

public class RouterStub {
    String router_host = null;
    int router_port = 0;
    Socket sock = null;
    DataOutputStream output = null;
    DataInputStream input = null;
    Address local_addr = null;
    final long RECONNECT_TIMEOUT = 5000L;
    boolean connected = false;
    private volatile boolean reconnect = false;

    public RouterStub(String router_host, int router_port) {
        this.router_host = router_host != null ? router_host : "localhost";
        this.router_port = router_port;
    }

    public Address connect() throws Exception {
        Address ret = null;
        int len = 0;
        try {
            this.sock = new Socket(this.router_host, this.router_port);
            this.sock.setSoLinger(true, 500);
            this.input = new DataInputStream(this.sock.getInputStream());
            len = this.input.readInt();
            byte[] buf = new byte[len];
            this.input.readFully(buf);
            ret = (Address)Util.objectFromByteBuffer(buf);
            this.output = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            throw e;
        }
        if (ret == null && this.sock != null) {
            ret = new IpAddress(this.sock.getLocalPort());
        }
        if (this.local_addr == null) {
            this.local_addr = ret;
        }
        return ret;
    }

    public void disconnect() {
        if (this.output != null) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sock != null) {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connected = false;
        this.reconnect = false;
    }

    public boolean register(String groupname) {
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            Trace.error("RouterStub.register()", "No connection to router (groupname=" + groupname + ")");
            this.connected = false;
            return false;
        }
        if (groupname == null || groupname.length() == 0) {
            Trace.error("RouterStub.register()", "groupname is null");
            return false;
        }
        if (this.local_addr == null) {
            Trace.error("RouterStub.register()", "local_addr is null");
            return false;
        }
        try {
            buf = Util.objectToByteBuffer(this.local_addr);
            this.output.writeInt(-11);
            this.output.writeUTF(groupname);
            this.output.writeInt(buf.length);
            this.output.write(buf, 0, buf.length);
            this.output.flush();
        }
        catch (Exception e) {
            Trace.error("RouterStub.register()", Trace.getStackTrace(e));
            this.connected = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List get(String groupname) {
        List ret;
        block39: {
            byte[] buf;
            int len;
            FilterInputStream input;
            FilterOutputStream output;
            Socket tmpsock;
            block33: {
                ret = null;
                tmpsock = null;
                output = null;
                input = null;
                if (groupname == null || groupname.length() == 0) {
                    Trace.error("RouterStub.get()", "groupname is null");
                    return null;
                }
                tmpsock = new Socket(this.router_host, this.router_port);
                tmpsock.setSoLinger(true, 500);
                input = new DataInputStream(tmpsock.getInputStream());
                len = ((DataInputStream)input).readInt();
                buf = new byte[len];
                ((DataInputStream)input).readFully(buf);
                output = new DataOutputStream(tmpsock.getOutputStream());
                ((DataOutputStream)output).writeInt(-10);
                ((DataOutputStream)output).writeUTF(groupname);
                len = ((DataInputStream)input).readInt();
                if (len != 0) break block33;
                List list = null;
                Object var10_10 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (tmpsock != null) {
                        tmpsock.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return list;
            }
            buf = new byte[len];
            ((DataInputStream)input).readFully(buf);
            ret = (List)Util.objectFromByteBuffer(buf);
            Object var10_11 = null;
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (tmpsock != null) {
                    tmpsock.close();
                }
                break block39;
            }
            catch (Exception e2) {}
            break block39;
            {
                catch (Exception e) {
                    Trace.error("RouterStub.get()", "exception=" + e);
                    Object var10_12 = null;
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (tmpsock != null) {
                            tmpsock.close();
                        }
                        break block39;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (tmpsock != null) {
                        tmpsock.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return ret;
    }

    public boolean send(Message msg, String groupname) {
        byte[] msg_buf = null;
        byte[] dst_buf = null;
        Address dst_addr = null;
        if (this.sock == null || this.output == null || this.input == null) {
            Trace.error("RouterStub.send()", "No connection to router (groupname=" + groupname + ")");
            this.connected = false;
            return false;
        }
        if (msg == null) {
            Trace.error("RouterStub.send()", "Message is null");
            return false;
        }
        try {
            dst_addr = msg.getDest();
            if (dst_addr != null) {
                dst_buf = Util.objectToByteBuffer(dst_addr);
            }
            msg_buf = Util.objectToByteBuffer(msg);
            this.output.writeUTF(groupname);
            if (dst_buf != null && dst_buf.length > 0) {
                this.output.writeInt(dst_buf.length);
                this.output.write(dst_buf, 0, dst_buf.length);
            } else {
                this.output.writeInt(0);
            }
            this.output.writeInt(msg_buf.length);
            this.output.write(msg_buf, 0, msg_buf.length);
        }
        catch (Exception e) {
            Trace.error("RouterStub.send()", Trace.getStackTrace(e));
            this.connected = false;
            return false;
        }
        return true;
    }

    public Message receive() {
        Message ret = null;
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            Trace.error("RouterStub.receive()", "No connection to router");
            this.connected = false;
            return null;
        }
        try {
            int len = this.input.readInt();
            if (len == 0) {
                ret = null;
            } else {
                buf = new byte[len];
                this.input.readFully(buf, 0, len);
                ret = (Message)Util.objectFromByteBuffer(buf);
            }
        }
        catch (Exception e) {
            this.connected = false;
            Trace.error("RouterStub.receive()", Trace.getStackTrace(e));
            return null;
        }
        return ret;
    }

    public synchronized boolean reconnect() {
        Address new_addr = null;
        if (this.connected) {
            return false;
        }
        this.disconnect();
        this.reconnect = true;
        while (this.reconnect) {
            try {
                new_addr = this.connect();
                if (new_addr != null) {
                    break;
                }
            }
            catch (Exception ex) {
                Trace.warn("RouterStub.reconnect()", "exception is " + ex);
            }
            Util.sleep(5000L);
        }
        if (new_addr == null) {
            return false;
        }
        Trace.warn("RouterStub.reconnect()", "Client reconnected, new addess is " + new_addr);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("RouterStub <host> <port>");
            return;
        }
        RouterStub stub = new RouterStub(args[0], new Integer(args[1]));
        String groupname = "BelaGroup";
        try {
            Message msg;
            int i;
            Address my_addr = stub.connect();
            System.out.println("My address is " + my_addr);
            System.out.println("Registering under BelaGroup");
            boolean rc = stub.register("BelaGroup");
            System.out.println("Done, rc=" + rc);
            System.out.println("Getting members of BelaGroup: ");
            List mbrs = stub.get("BelaGroup");
            System.out.println("Done, mbrs are " + mbrs);
            for (i = 0; i < 10; ++i) {
                msg = new Message(null, my_addr, (Serializable)((Object)("Bela #" + i)));
                msg.putHeader("TUNNEL", new TunnelHeader("BelaGroup"));
                rc = stub.send(msg, "BelaGroup");
                System.out.println("Sent msg, rc=" + rc);
            }
            for (i = 0; i < 10; ++i) {
                System.out.println("stub.receive():");
                msg = stub.receive();
                System.out.println("Received msg");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        finally {
            stub.disconnect();
        }
    }
}

