/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.CCLBorder;
import ccl.swing.ExitJDialog;
import ccl.swing.OKCancelPanel;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListCancelMultiSelector
extends ExitJDialog {
    private static final int MAX_ELEMENTS = 20;
    private static final String S_TITLE = "Select";
    protected JList _lst;
    protected Vector _vValues;
    protected Vector _vSelected = new Vector();
    protected Vector _vOrigSelected;
    protected Vector _vIndexes = new Vector();
    protected Vector _vOrigIndexes = new Vector();
    private OKCancelPanel _pOKCancelPanel = null;
    protected JLabel[] _alblHeadline;
    protected boolean _bOK = false;

    public ListCancelMultiSelector(Frame frmParent_, String sMessage_, Vector vsList_) {
        this(frmParent_, sMessage_, vsList_, new Vector());
    }

    public ListCancelMultiSelector(Frame frmParent_, String sMessage_, Vector vsList_, Vector vsSelected_) {
        super(frmParent_, S_TITLE, true);
        Util.panicIf(vsList_ == null);
        this._bOK = false;
        this._vValues = (Vector)vsList_.clone();
        this._vOrigSelected = (Vector)vsSelected_.clone();
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Vector vMessages = new Vector();
        vMessages = Util.stringToLines(sMessage_);
        JPanel pnlMessages = new JPanel();
        AutoGridBagLayout agblMessages = new AutoGridBagLayout();
        agblMessages.setExpandHorizontal();
        agblMessages.setFillHorizontal();
        agblMessages.setAnchor(17);
        pnlMessages.setLayout(agblMessages);
        this._alblHeadline = new JLabel[vMessages.size()];
        int line = 0;
        while (line < vMessages.size()) {
            JLabel lblLine;
            String sLine = (String)vMessages.elementAt(line);
            this._alblHeadline[line] = lblLine = new JLabel(sLine);
            pnlMessages.add(lblLine);
            agblMessages.endLine();
            ++line;
        }
        this.getContentPane().add((Component)pnlMessages, "North");
        int lines = Util.min(vsList_.size(), 20);
        Util.debug("ListCancelMultiSelector.<init>(..).1");
        DefaultListModel pDefaultListModel = new DefaultListModel();
        this._lst = new JList(pDefaultListModel);
        this._lst.setSelectionMode(2);
        Enumeration e = vsList_.elements();
        while (e.hasMoreElements()) {
            pDefaultListModel.addElement(e.nextElement());
        }
        JScrollPane scpList = new JScrollPane(this._lst);
        scpList.setBorder(new CCLBorder());
        this.getContentPane().add((Component)scpList, "Center");
        Util.debug("ListCancelMultiSelector.<init>(..).2");
        if (vsSelected_ != null) {
            Enumeration eSelected = vsSelected_.elements();
            while (eSelected.hasMoreElements()) {
                String sNextSelected = (String)eSelected.nextElement();
                int index = vsList_.indexOf(sNextSelected);
                if (index == -1) continue;
                this._lst.setSelectedIndex(index);
                this._vOrigIndexes.addElement(new Integer(index));
            }
        }
        Util.debug("ListCancelMultiSelector.<init>(..).3");
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new BorderLayout());
        pnlButtons.add(Box.createVerticalStrut(5), "North");
        pnlButtons.add((Component)new JLabel(" "), "Center");
        this._pOKCancelPanel = new OKCancelPanel(this);
        pnlButtons.add((Component)this._pOKCancelPanel, "East");
        this.getContentPane().add((Component)pnlButtons, "South");
        Util.debug("ListCancelMultiSelector.<init>(..).4");
        this.pack();
        this.setSize(340, 340);
        SwingUtil.centerComponent(this);
    }

    public boolean isOK() {
        return this._bOK;
    }

    public Vector getValues() {
        if (!this._bOK) {
            return this._vOrigSelected;
        }
        return this._vSelected;
    }

    public Vector getIndexes() {
        if (!this._bOK) {
            return this._vOrigIndexes;
        }
        return this._vIndexes;
    }

    public void exit() {
        super.exit();
    }

    public void setVisible(boolean bVisible_) {
        if (!bVisible_ && this._pOKCancelPanel.isOK()) {
            this._vSelected = new Vector();
            int[] aiSelected = this._lst.getSelectedIndices();
            int selected = 0;
            while (selected < aiSelected.length) {
                this._vSelected.addElement(this._vValues.elementAt(aiSelected[selected]));
                this._vIndexes.addElement(new Integer(aiSelected[selected]));
                ++selected;
            }
            this._bOK = true;
        }
        super.setVisible(bVisible_);
    }

    public static Vector input(Frame frmParent_, String sMessage_, Vector vsList_) {
        ListCancelMultiSelector dialog = new ListCancelMultiSelector(frmParent_, sMessage_, vsList_);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            return dialog.getValues();
        }
        return null;
    }

    public static Vector inputIndexes(Frame frmParent_, String sMessage_, Vector vsList_) {
        ListCancelMultiSelector dialog = new ListCancelMultiSelector(frmParent_, sMessage_, vsList_);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            return dialog.getIndexes();
        }
        return null;
    }
}

