/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class CCLLineBorder
extends LineBorder {
    private Insets insets = null;

    public CCLLineBorder(Color color) {
        super(color);
    }

    public CCLLineBorder(Color color, int thickness) {
        super(color, thickness);
    }

    public CCLLineBorder(Color color, Insets insets_) {
        super(color);
        this.insets = insets_;
    }

    public Insets getBorderInsets(Component c, Insets insets_) {
        if (this.insets != null) {
            insets_.top = this.insets.top;
            insets_.left = this.insets.left;
            insets_.bottom = this.insets.bottom;
            insets_.right = this.insets.right;
            return insets_;
        }
        return super.getBorderInsets(c, insets_);
    }

    public Insets getBorderInsets(Component c) {
        if (this.insets != null) {
            Insets retVal = new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            return retVal;
        }
        return super.getBorderInsets(c);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.insets == null) {
            super.paintBorder(c, g, x, y, width, height);
            return;
        }
        Color color = this.getLineColor();
        g.setColor(color);
        g.fillRect(x, y, width, this.insets.top);
        g.fillRect(x, y, this.insets.left, height);
        g.fillRect(x, y + height - this.insets.bottom, width, this.insets.bottom);
        g.fillRect(x + width - this.insets.right, y, this.insets.right, height);
    }
}

