/*
 * Decompiled with CFR 0.152.
 */
package ccl.xml.test;

import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import ccl.xml.XMLUtil;
import java.io.File;
import javax.xml.transform.TransformerException;

public class XMLUtilTest
extends Test {
    public void testValueOf() throws Exception {
        String sXML = "<boo>\n  <foo>\n    <flop>blah</flop>\n  </foo>\n</boo>\n";
        try {
            String sResult = XMLUtil.getValueOf(sXML, "/boo/foo/flop");
            this.Assert(sResult.equals("blah"));
        }
        catch (NoClassDefFoundError classError) {
            Util.print(" No Xalan XSLT parser found, skipping test! ");
        }
    }

    public void testGetXMLException() throws Exception {
        File tempFile = File.createTempFile("_xmltest", null);
        String stylesheet = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<xsl:stylesheet\n   version=\"1.0\"\n   xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:output method=\"text\"/>\n\n<xsl:template match=\"/\"><xsl:value-of select=\"xpath\"/></xsl:template>\n\n</xsl:stylesheet>\n";
        String result = null;
        try {
            result = XMLUtil.getXML("<xml></xml>", tempFile);
            this.Assert(false);
        }
        catch (TransformerException transformerException) {
            this.Assert(transformerException.getMessage().indexOf("_xmltest") != -1, transformerException.getMessage());
        }
        try {
            result = XMLUtil.getXML(tempFile, tempFile);
            this.Assert(false);
        }
        catch (TransformerException transformerException) {
            this.Assert(transformerException.getMessage().indexOf("_xmltest") != -1, transformerException.getMessage());
        }
        try {
            result = XMLUtil.getXML(tempFile, stylesheet);
            this.Assert(false);
        }
        catch (TransformerException transformerException) {
            this.Assert(transformerException.getMessage().indexOf("_xmltest") != -1, transformerException.getMessage());
        }
        FileUtil.delete(tempFile.getPath());
    }

    public XMLUtilTest() {
    }

    public XMLUtilTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        this.testGetXMLException();
        this.testValueOf();
    }

    public static void main(String[] asArg_) {
        XMLUtilTest pTest = new XMLUtilTest();
        pTest.setVerbose(true);
        pTest.run();
        Test.printResult(pTest);
        System.exit(0);
    }
}

