package android.gov.nist.javax.sip.clientauthutils;

import android.javax.sip.ClientTransaction;

public interface SecureAccountManager  {
    /**
     * Returns the user credentials for a given SIP Domain.
     * You can implement any desired method (such as popping up a dialog for example )
     * to retrieve the credentials.
     *
     * @param challengedTransaction - the transaction that is being challenged.
     * @param realm - the realm that is being challenged for which a credential should be
     *         returned.
     * @return -- the user credentials associated with the domain.
     */

    UserCredentialHash getCredentialHash(ClientTransaction challengedTransaction, String realm);

}
