/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.KeyedSemaphore;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class NIOHandler {
    private static StackLogger logger = CommonLogger.getLogger(NIOHandler.class);
    private SipStackImpl sipStack;
    private NioTcpMessageProcessor messageProcessor;
    Timer timer = new Timer();
    private final ConcurrentHashMap<String, SocketChannel> socketTable = new ConcurrentHashMap();
    KeyedSemaphore keyedSemaphore = new KeyedSemaphore();

    protected static String makeKey(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    protected static String makeKey(String addr, int port) {
        return addr + ":" + port;
    }

    protected NIOHandler(SIPTransactionStack sipStack, NioTcpMessageProcessor messageProcessor) {
        this.sipStack = (SipStackImpl)sipStack;
        this.messageProcessor = messageProcessor;
        if (sipStack.nioSocketMaxIdleTime > 0L) {
            this.timer.scheduleAtFixedRate((TimerTask)new SocketTimeoutAuditor(), 20000L, 20000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSocket(String key, SocketChannel sock) {
        ConcurrentHashMap<String, SocketChannel> concurrentHashMap = this.socketTable;
        synchronized (concurrentHashMap) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("adding socket for key " + key);
            }
            this.socketTable.put(key, sock);
        }
    }

    protected SocketChannel getSocket(String key) {
        return this.socketTable.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocket(String key) {
        ConcurrentHashMap<String, SocketChannel> concurrentHashMap = this.socketTable;
        synchronized (concurrentHashMap) {
            this.socketTable.remove(key);
            this.keyedSemaphore.remove(key);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("removed Socket and Semaphore for key " + key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocket(SocketChannel channel) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Trying to remove cached socketChannel without key" + this + " socketChannel = " + channel);
        }
        LinkedList<String> keys = new LinkedList<String>();
        ConcurrentHashMap<String, SocketChannel> concurrentHashMap = this.socketTable;
        synchronized (concurrentHashMap) {
            Set<Map.Entry<String, SocketChannel>> e = this.socketTable.entrySet();
            for (Map.Entry<String, SocketChannel> entry : e) {
                SocketChannel sc = entry.getValue();
                if (!sc.equals(channel)) continue;
                keys.add(entry.getKey());
            }
            for (String key : keys) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Removing cached socketChannel without key" + this + " socketChannel = " + channel + " key = " + key);
                }
                this.socketTable.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(SocketChannel channel, byte[] bytes, int length) {
        SocketChannel socketChannel = channel;
        synchronized (socketChannel) {
            byte[] buff = new byte[length];
            System.arraycopy(bytes, 0, buff, 0, length);
            this.messageProcessor.send(channel, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel sendBytes(InetAddress senderAddress, InetAddress receiverAddress, int contactPort, String transport, byte[] bytes, boolean isClient, NioTcpMessageChannel messageChannel) throws IOException {
        SocketChannel clientSock;
        block30: {
            int retry_count = 0;
            int max_retry = isClient ? 2 : 1;
            int length = bytes.length;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " length = " + length + " isClient " + isClient);
            }
            if (logger.isLoggingEnabled(16) && this.sipStack.isLogStackTraceOnMessageSend()) {
                logger.logStackTrace(16);
            }
            String key = NIOHandler.makeKey(receiverAddress, contactPort);
            clientSock = null;
            this.keyedSemaphore.enterIOCriticalSection(key);
            boolean newSocket = false;
            try {
                clientSock = this.getSocket(key);
                if (retry_count >= max_retry) break block30;
                if (!(clientSock == null || clientSock.isConnected() && clientSock.isOpen())) {
                    this.removeSocket(key);
                    clientSock = null;
                    newSocket = true;
                }
                if (clientSock != null) break block30;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("inaddr = " + receiverAddress);
                    logger.logDebug("port = " + contactPort);
                }
                try {
                    clientSock = this.messageProcessor.blockingConnect(new InetSocketAddress(receiverAddress, contactPort), 10000);
                    newSocket = true;
                }
                catch (SocketException e) {
                    logger.logError("Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress + " for message " + (messageChannel.isSecure() ? "<<<ENCRYPTED MESSAGE>>>" : new String(bytes, "UTF-8")));
                    this.removeSocket(key);
                    throw new SocketException(e.getClass() + " " + e.getMessage() + " " + e.getCause() + " Problem connecting " + receiverAddress + " " + contactPort + " " + senderAddress + " for message " + new String(bytes, "UTF-8"));
                }
                this.putSocket(key, clientSock);
            }
            catch (IOException ex) {
                if (logger.isLoggingEnabled(4)) {
                    logger.logError("Problem sending: sendBytes " + transport + " inAddr " + receiverAddress.getHostAddress() + " port = " + contactPort + " remoteHost " + messageChannel.getPeerAddress() + " remotePort " + messageChannel.getPeerPort() + " peerPacketPort " + messageChannel.getPeerPacketSourcePort() + " isClient " + isClient);
                }
                this.removeSocket(key);
                if (!isClient) {
                    receiverAddress = InetAddress.getByName(messageChannel.peerAddressAdvertisedInHeaders);
                    contactPort = messageChannel.peerPortAdvertisedInHeaders;
                    if (contactPort <= 0) {
                        contactPort = 5060;
                    }
                    if ((clientSock = this.getSocket(key = NIOHandler.makeKey(receiverAddress, contactPort))) == null || !clientSock.isConnected() || !clientSock.isOpen()) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("inaddr = " + receiverAddress + " port = " + contactPort);
                        }
                        clientSock = this.messageProcessor.blockingConnect(new InetSocketAddress(receiverAddress, contactPort), 10000);
                        newSocket = true;
                        messageChannel.peerPort = contactPort;
                        this.putSocket(key, clientSock);
                    }
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("sending to " + key);
                    }
                } else {
                    logger.logError("IOException occured at ", ex);
                    throw ex;
                }
                SocketChannel socketChannel = clientSock;
                return socketChannel;
            }
            finally {
                try {
                    if (clientSock != null) {
                        if (newSocket && messageChannel instanceof NioTlsMessageChannel) {
                        } else {
                            this.writeChunks(clientSock, bytes, length);
                        }
                    }
                }
                finally {
                    this.keyedSemaphore.leaveIOCriticalSection(key);
                }
            }
        }
        if (clientSock == null) {
            if (logger.isLoggingEnabled(4)) {
                logger.logError(this.socketTable.toString());
                logger.logError("Could not connect to " + receiverAddress + ":" + contactPort);
            }
            throw new IOException("Could not connect to " + receiverAddress + ":" + contactPort);
        }
        return clientSock;
    }

    public void closeAll() {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Closing " + this.socketTable.size() + " sockets from IOHandler");
        }
        Enumeration<SocketChannel> values = this.socketTable.elements();
        while (values.hasMoreElements()) {
            SocketChannel s = values.nextElement();
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.timer.cancel();
            this.timer.purge();
            ConcurrentHashMap<String, SocketChannel> concurrentHashMap = this.socketTable;
            synchronized (concurrentHashMap) {
                HashSet<String> keysToRemove = new HashSet<String>();
                for (String key : this.socketTable.keySet()) {
                    try {
                        SocketChannel socketChannel = this.socketTable.get(key);
                        NioTcpMessageChannel messageChannel = NioTcpMessageChannel.getMessageChannel(socketChannel);
                        if (messageChannel == null) {
                            keysToRemove.add(key);
                            continue;
                        }
                        keysToRemove.add(key);
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("stop() : Will remove socket " + key + " lastActivity=" + messageChannel.getLastActivityTimestamp() + " current= " + System.currentTimeMillis());
                        }
                        NioTcpMessageChannel.removeMessageChannel(socketChannel);
                        messageChannel.close();
                    }
                    catch (Exception anything) {}
                }
                for (String key : keysToRemove) {
                    this.socketTable.remove(key);
                    if (!logger.isLoggingEnabled(32)) continue;
                    logger.logDebug("stop() : Removed socket " + key);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel createOrReuseSocket(InetAddress inetAddress, int port) throws IOException {
        String key = NIOHandler.makeKey(inetAddress, port);
        SocketChannel channel = null;
        this.keyedSemaphore.enterIOCriticalSection(key);
        try {
            channel = this.getSocket(key);
            if (!(channel == null || channel.isConnected() && channel.isOpen())) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Channel disconnected " + channel);
                }
                channel = null;
            }
            if (channel == null) {
                InetSocketAddress sockAddr = new InetSocketAddress(inetAddress, port);
                channel = this.messageProcessor.blockingConnect(sockAddr, 10000);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("create channel = " + channel + "  " + inetAddress + " " + port);
                }
                if (channel != null && channel.isConnected()) {
                    this.putSocket(NIOHandler.makeKey(inetAddress, port), channel);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("channel cached channel = " + channel);
                    }
                }
            }
            SocketChannel socketChannel = channel;
            return socketChannel;
        }
        finally {
            this.keyedSemaphore.leaveIOCriticalSection(key);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Returning socket " + key + " channel = " + channel);
            }
        }
    }

    private class SocketTimeoutAuditor
    extends TimerTask {
        private SocketTimeoutAuditor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentHashMap concurrentHashMap = NIOHandler.this.socketTable;
            synchronized (concurrentHashMap) {
                try {
                    HashSet<String> keysToRemove = new HashSet<String>();
                    for (String key : NIOHandler.this.socketTable.keySet()) {
                        SocketChannel socketChannel = (SocketChannel)NIOHandler.this.socketTable.get(key);
                        NioTcpMessageChannel messageChannel = NioTcpMessageChannel.getMessageChannel(socketChannel);
                        if (messageChannel == null) {
                            keysToRemove.add(key);
                            continue;
                        }
                        if (System.currentTimeMillis() - messageChannel.getLastActivityTimestamp() <= ((NIOHandler)NIOHandler.this).sipStack.nioSocketMaxIdleTime) continue;
                        keysToRemove.add(key);
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Will remove socket " + key + " lastActivity=" + messageChannel.getLastActivityTimestamp() + " current= " + System.currentTimeMillis() + " socketChannel = " + socketChannel);
                        }
                        NioTcpMessageChannel.removeMessageChannel(socketChannel);
                        messageChannel.close();
                    }
                    for (String key : keysToRemove) {
                        NIOHandler.this.socketTable.remove(key);
                        if (!logger.isLoggingEnabled(32)) continue;
                        logger.logDebug("Removed socket " + key);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

