/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.NioPipelineParser;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageProcessor;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.NIOHandler;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.text.ParseException;
import java.util.HashMap;
import javax.net.ssl.SSLException;

public class NioTcpMessageChannel
extends ConnectionOrientedMessageChannel {
    private static StackLogger logger = CommonLogger.getLogger(NioTcpMessageChannel.class);
    protected static HashMap<SocketChannel, NioTcpMessageChannel> channelMap = new HashMap();
    protected SocketChannel socketChannel;
    protected long lastActivityTimeStamp;
    NioPipelineParser nioParser = null;

    public static NioTcpMessageChannel create(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        NioTcpMessageChannel retval = channelMap.get(socketChannel);
        if (retval == null) {
            retval = new NioTcpMessageChannel(nioTcpMessageProcessor, socketChannel);
            channelMap.put(socketChannel, retval);
        }
        retval.messageProcessor = nioTcpMessageProcessor;
        retval.myClientInputStream = socketChannel.socket().getInputStream();
        return retval;
    }

    public static NioTcpMessageChannel getMessageChannel(SocketChannel socketChannel) {
        return channelMap.get(socketChannel);
    }

    public static void putMessageChannel(SocketChannel socketChannel, NioTcpMessageChannel nioTcpMessageChannel) {
        channelMap.put(socketChannel, nioTcpMessageChannel);
    }

    public static void removeMessageChannel(SocketChannel socketChannel) {
        channelMap.remove(socketChannel);
    }

    public void readChannel() {
        block11: {
            logger.logDebug("NioTcpMessageChannel::readChannel");
            int bufferSize = 4096;
            byte[] msg = new byte[bufferSize];
            this.isRunning = true;
            try {
                ByteBuffer byteBuffer = ByteBuffer.wrap(msg);
                int nbytes = this.socketChannel.read(byteBuffer);
                byteBuffer.flip();
                msg = new byte[byteBuffer.remaining()];
                byteBuffer.get(msg);
                boolean streamError = nbytes == -1;
                nbytes = msg.length;
                byteBuffer.clear();
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Read " + nbytes + " from socketChannel");
                }
                if (nbytes == 0) {
                    throw new IOException("The socket is giving us empty TCP packets. This is usually an indication we are stuck and it is better to disconnect.");
                }
                if (streamError) {
                    throw new IOException("Stream error msg len = -1 This is usually an indication we are stuck and it is better to disconnect.");
                }
                byte[] bytes = new byte[nbytes];
                System.arraycopy(msg, 0, bytes, 0, nbytes);
                this.addBytes(bytes);
                this.lastActivityTimeStamp = System.currentTimeMillis();
            }
            catch (Exception ex) {
                if (ex instanceof IOException && !(ex instanceof SSLException)) {
                    try {
                        this.nioParser.addBytes("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("IOException  closing sock " + ex + "myAddress:myport " + this.myAddress + ":" + this.myPort + ", remoteAddress:remotePort " + this.peerAddress + ":" + this.peerPort);
                    }
                    this.close(true, false);
                }
                catch (Exception ex1) {
                    if (!logger.isLoggingEnabled(32)) break block11;
                    logger.logDebug("Exception closing the socket " + ex1);
                }
            }
        }
    }

    protected void addBytes(byte[] bytes) throws Exception {
        this.nioParser.addBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NioTcpMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        super(nioTcpMessageProcessor.getSIPStack());
        this.myClientInputStream = socketChannel.socket().getInputStream();
        try {
            this.peerAddress = socketChannel.socket().getInetAddress();
            this.peerPort = socketChannel.socket().getPort();
            this.socketChannel = socketChannel;
            this.mySock = socketChannel.socket();
            this.nioParser = new NioPipelineParser(this.sipStack, this, this.sipStack.getMaxMessageSize());
            this.peerProtocol = nioTcpMessageProcessor.transport;
            this.lastActivityTimeStamp = System.currentTimeMillis();
            this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, nioTcpMessageProcessor.transport);
            this.myAddress = nioTcpMessageProcessor.getIpAddress().getHostAddress();
            this.myPort = nioTcpMessageProcessor.getPort();
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Done creating NioTcpMessageChannel " + this + " socketChannel = " + socketChannel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioTcpMessageChannel(InetAddress inetAddress, int port, SIPTransactionStack sipStack, NioTcpMessageProcessor nioTcpMessageProcessor) throws IOException {
        super(sipStack);
        logger.logDebug("NioTcpMessageChannel::NioTcpMessageChannel: " + inetAddress.getHostAddress() + ":" + port);
        try {
            this.messageProcessor = nioTcpMessageProcessor;
            this.socketChannel = nioTcpMessageProcessor.nioHandler.createOrReuseSocket(inetAddress, port);
            this.peerAddress = this.socketChannel.socket().getInetAddress();
            this.peerPort = this.socketChannel.socket().getPort();
            this.mySock = this.socketChannel.socket();
            this.peerProtocol = this.getTransport();
            this.nioParser = new NioPipelineParser(sipStack, this, this.sipStack.getMaxMessageSize());
            NioTcpMessageChannel.putMessageChannel(this.socketChannel, this);
            this.lastActivityTimeStamp = System.currentTimeMillis();
            this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, this.getTransport());
            this.myAddress = nioTcpMessageProcessor.getIpAddress().getHostAddress();
            this.myPort = nioTcpMessageProcessor.getPort();
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("NioTcpMessageChannel::NioTcpMessageChannel: Done creating NioTcpMessageChannel " + this + " socketChannel = " + this.socketChannel);
            }
        }
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    protected void close(boolean removeSocket, boolean stopKeepAliveTask) {
        try {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing NioTcpMessageChannel " + this + " socketChannel = " + this.socketChannel);
            }
            NioTcpMessageChannel.removeMessageChannel(this.socketChannel);
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
            if (this.nioParser != null) {
                this.nioParser.close();
            }
            this.isRunning = false;
            if (removeSocket) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Removing NioTcpMessageChannel " + this + " socketChannel = " + this.socketChannel);
                }
                ((NioTcpMessageProcessor)this.messageProcessor).nioHandler.removeSocket(this.socketChannel);
                ((ConnectionOrientedMessageProcessor)this.messageProcessor).remove(this);
            }
            if (stopKeepAliveTask) {
                this.cancelPingKeepAliveTimeoutTaskIfStarted();
            }
        }
        catch (IOException e) {
            logger.logError("Problem occured while closing", e);
        }
    }

    @Override
    public String getTransport() {
        return "TCP";
    }

    @Override
    protected void sendMessage(byte[] msg, boolean isClient) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendMessage isClient  = " + isClient + " this = " + this);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        this.sendTCPMessage(msg, this.peerAddress, this.peerPort, isClient);
    }

    @Override
    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        this.sendTCPMessage(message, receiverAddress, receiverPort, retry);
    }

    public void sendTCPMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        NIOHandler nioHandler;
        SocketChannel sock;
        if (message == null || receiverAddress == null) {
            logger.logError("receiverAddress = " + receiverAddress);
            throw new IllegalArgumentException("Null argument");
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        if (this.peerPortAdvertisedInHeaders <= 0) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("receiver port = " + receiverPort + " for this channel " + this + " key " + this.key);
            }
            this.peerPortAdvertisedInHeaders = receiverPort <= 0 ? 5060 : receiverPort;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("2.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
            }
        }
        if ((sock = (nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler).sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TCP", message, retry, this)) != this.socketChannel && sock != null) {
            if (this.socketChannel != null) {
                if (logger.isLoggingEnabled(8)) {
                    logger.logWarning("[2] Old socket different than new socket on channel " + this.key + this.socketChannel + " " + sock);
                    logger.logStackTrace();
                    logger.logWarning("Old socket local ip address " + this.socketChannel.socket().getLocalSocketAddress());
                    logger.logWarning("Old socket remote ip address " + this.socketChannel.socket().getRemoteSocketAddress());
                    logger.logWarning("New socket local ip address " + sock.socket().getLocalSocketAddress());
                    logger.logWarning("New socket remote ip address " + sock.socket().getRemoteSocketAddress());
                }
                this.close(false, false);
                this.socketChannel = sock;
                NioTcpMessageChannel.putMessageChannel(this.socketChannel, this);
                this.onNewSocket(message);
            }
            if (this.socketChannel != null && logger.isLoggingEnabled(8)) {
                logger.logWarning("There was no exception for the retry mechanism so we keep going " + this.key);
            }
            this.socketChannel = sock;
        }
    }

    public void onNewSocket(byte[] message) {
    }

    @Override
    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (logger.isLoggingEnabled()) {
            logger.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(ContentLength.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            block7: {
                String msgString;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Encountered Bad Message \n" + sipMessage.toString());
                }
                if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ") && this.socketChannel != null) {
                    if (logger.isLoggingEnabled(4)) {
                        logger.logError("Malformed mandatory headers: closing socket! :" + this.socketChannel.toString());
                    }
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException ie) {
                        if (!logger.isLoggingEnabled(4)) break block7;
                        logger.logError("Exception while closing socket! :" + this.socketChannel.toString() + ":" + ie.toString());
                    }
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        NioTcpMessageChannel that = (NioTcpMessageChannel)other;
        return this.socketChannel == that.socketChannel;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public long getLastActivityTimestamp() {
        return this.lastActivityTimeStamp;
    }
}

