/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.ByteBufferFactory;
import gov.nist.javax.sip.stack.NIOHandler;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioTlsChannelInterface;
import gov.nist.javax.sip.stack.NioTlsMessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.SSLStateMachine;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

public class NioTlsMessageChannel
extends NioTcpMessageChannel
implements NioTlsChannelInterface {
    private static StackLogger logger = CommonLogger.getLogger(NioTlsMessageChannel.class);
    SSLStateMachine sslStateMachine;
    private int appBufferMax;
    private int netBufferMax;

    public static NioTcpMessageChannel create(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        NioTcpMessageChannel retval = (NioTcpMessageChannel)channelMap.get(socketChannel);
        if (retval == null) {
            retval = new NioTlsMessageChannel(nioTcpMessageProcessor, socketChannel);
            channelMap.put(socketChannel, retval);
        }
        return retval;
    }

    protected NioTlsMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel socketChannel) throws IOException {
        super(nioTcpMessageProcessor, socketChannel);
        this.messageProcessor = nioTcpMessageProcessor;
        this.myClientInputStream = socketChannel.socket().getInputStream();
        try {
            this.init(false);
            this.createBuffers();
        }
        catch (Exception e) {
            throw new IOException("Can't do TLS init", e);
        }
    }

    public void init(boolean clientMode) throws Exception, CertificateException, FileNotFoundException, IOException {
        SSLContext ctx = clientMode ? ((NioTlsMessageProcessor)this.messageProcessor).sslClientCtx : ((NioTlsMessageProcessor)this.messageProcessor).sslServerCtx;
        this.sslStateMachine = new SSLStateMachine(ctx.createSSLEngine(), this);
        this.sslStateMachine.sslEngine.setUseClientMode(clientMode);
        String auth = ((SipStackImpl)this.sipStack).getConfigurationProperties().getProperty("gov.nist.javax.sip.TLS_CLIENT_AUTH_TYPE");
        if (auth == null) {
            auth = "Enabled";
        }
        if (auth.equals("Disabled")) {
            this.sslStateMachine.sslEngine.setNeedClientAuth(false);
            this.sslStateMachine.sslEngine.setWantClientAuth(false);
        } else if (auth.equals("Enabled")) {
            this.sslStateMachine.sslEngine.setNeedClientAuth(true);
        } else if (auth.equals("Want")) {
            this.sslStateMachine.sslEngine.setNeedClientAuth(false);
            this.sslStateMachine.sslEngine.setWantClientAuth(true);
        } else {
            throw new RuntimeException("Invalid parameter for TLS authentication: " + auth);
        }
        this.sslStateMachine.sslEngine.setEnabledProtocols(((SipStackImpl)this.sipStack).getEnabledProtocols());
    }

    @Override
    public ByteBuffer prepareEncryptedDataBuffer() {
        return ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax);
    }

    @Override
    public ByteBuffer prepareAppDataBuffer() {
        return ByteBufferFactory.getInstance().allocateDirect(this.appBufferMax);
    }

    @Override
    protected void sendMessage(byte[] msg, final boolean isClient) throws IOException {
        this.checkSocketState();
        ByteBuffer b = ByteBuffer.wrap(msg);
        try {
            this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

                @Override
                public void doSend(byte[] bytes) throws IOException {
                    NioTlsMessageChannel.super.sendMessage(bytes, isClient);
                }
            });
        }
        catch (Exception e) {
            throw new IOException("Can't send message", e);
        }
    }

    @Override
    public void sendEncryptedData(byte[] msg) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("sendEncryptedData  this = " + this + " peerPort = " + this.peerPort + " addr = " + this.peerAddress);
        }
        this.lastActivityTimeStamp = System.currentTimeMillis();
        NIOHandler nioHandler = ((NioTcpMessageProcessor)this.messageProcessor).nioHandler;
        if (this.socketChannel != null && this.socketChannel.isConnected() && this.socketChannel.isOpen()) {
            nioHandler.putSocket(NIOHandler.makeKey(this.peerAddress, this.peerPort), this.socketChannel);
        }
        super.sendMessage(msg, this.peerAddress, this.peerPort, true);
    }

    @Override
    public void sendMessage(byte[] message, final InetAddress receiverAddress, final int receiverPort, final boolean retry) throws IOException {
        this.checkSocketState();
        ByteBuffer b = ByteBuffer.wrap(message);
        this.sslStateMachine.wrap(b, ByteBufferFactory.getInstance().allocateDirect(this.netBufferMax), new SSLStateMachine.MessageSendCallback(){

            @Override
            public void doSend(byte[] bytes) throws IOException {
                NioTlsMessageChannel.super.sendMessage(bytes, receiverAddress, receiverPort, retry);
            }
        });
    }

    protected void createBuffers() {
        SSLSession session = this.sslStateMachine.sslEngine.getSession();
        this.appBufferMax = session.getApplicationBufferSize();
        this.netBufferMax = session.getPacketBufferSize();
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("appBufferMax=" + this.appBufferMax + " netBufferMax=" + this.netBufferMax);
        }
    }

    public NioTlsMessageChannel(InetAddress inetAddress, int port, SIPTransactionStack sipStack, NioTcpMessageProcessor nioTcpMessageProcessor) throws IOException {
        super(inetAddress, port, sipStack, nioTcpMessageProcessor);
        try {
            this.init(true);
            this.createBuffers();
        }
        catch (Exception e) {
            throw new IOException("Can't init the TLS channel", e);
        }
    }

    @Override
    protected void addBytes(byte[] bytes) throws Exception {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Adding TLS bytes for decryption " + bytes.length);
        }
        if (bytes.length <= 0) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.sslStateMachine.unwrap(buffer);
    }

    @Override
    public String getTransport() {
        return "TLS";
    }

    @Override
    public void onNewSocket(byte[] message) {
        super.onNewSocket(message);
        try {
            if (logger.isLoggingEnabled(32)) {
                String last = null;
                if (message != null) {
                    last = new String(message, "UTF-8");
                }
                logger.logDebug("New socket for " + this + " last message = " + last);
            }
            this.init(true);
            this.createBuffers();
            this.sendMessage(message, false);
        }
        catch (Exception e) {
            logger.logError("Cant reinit", e);
        }
    }

    private void checkSocketState() throws IOException {
        if (!(this.socketChannel == null || this.socketChannel.isConnected() && this.socketChannel.isOpen())) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Need to reset SSL engine for socket " + this.socketChannel);
            }
            try {
                this.init(this.sslStateMachine.sslEngine.getUseClientMode());
            }
            catch (Exception ex) {
                logger.logError("Cannot reset SSL engine", ex);
                throw new IOException(ex);
            }
        }
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public void addPlaintextBytes(byte[] bytes) throws Exception {
        this.nioParser.addBytes(bytes);
    }

    public static class SSLReconnectedException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }
}

