/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.NioTcpMessageProcessor;
import gov.nist.javax.sip.stack.NioTlsMessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;

public class NioTlsMessageProcessor
extends NioTcpMessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(NioTlsMessageProcessor.class);
    SSLContext sslServerCtx;
    SSLContext sslClientCtx;

    public NioTlsMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) {
        super(ipAddress, sipStack, port);
        this.transport = "TLS";
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NioTcpMessageChannel createMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel client) throws IOException {
        return NioTlsMessageChannel.create(this, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key;
        NioTlsMessageChannel retval;
        block11: {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("NioTlsMessageProcessor::createMessageChannel: " + targetHostPort);
            }
            retval = null;
            try {
                key = MessageChannel.getKey(targetHostPort, "TLS");
                if (this.messageChannels.get(key) == null) break block11;
                NioTlsMessageChannel nioTlsMessageChannel = retval = (NioTlsMessageChannel)this.messageChannels.get(key);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("MessageChannel::createMessageChannel - exit " + retval);
                }
                return nioTlsMessageChannel;
            }
            catch (Throwable throwable) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("MessageChannel::createMessageChannel - exit " + retval);
                }
                throw throwable;
            }
        }
        retval = new NioTlsMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
        Object object = this.messageChannels;
        synchronized (object) {
            this.messageChannels.put(key, retval);
        }
        retval.isCached = true;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("key " + key);
            logger.logDebug("Creating " + retval);
        }
        this.selector.wakeup();
        object = retval;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("MessageChannel::createMessageChannel - exit " + retval);
        }
        return object;
    }

    @Override
    public MessageChannel createMessageChannel(InetAddress targetHost, int port) throws IOException {
        String key = MessageChannel.getKey(targetHost, port, "TLS");
        if (this.messageChannels.get(key) != null) {
            return (MessageChannel)this.messageChannels.get(key);
        }
        NioTlsMessageChannel retval = new NioTlsMessageChannel(targetHost, port, this.sipStack, this);
        this.selector.wakeup();
        this.messageChannels.put(key, retval);
        retval.isCached = true;
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("key " + key);
            logger.logDebug("Creating " + retval);
        }
        return retval;
    }

    public void init() throws Exception, CertificateException, FileNotFoundException, IOException {
        if (this.sipStack.securityManagerProvider.getKeyManagers(false) == null || this.sipStack.securityManagerProvider.getTrustManagers(false) == null || this.sipStack.securityManagerProvider.getTrustManagers(true) == null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("TLS initialization failed due to NULL security config");
            }
            return;
        }
        this.sslServerCtx = SSLContext.getInstance("TLS");
        this.sslServerCtx.init(this.sipStack.securityManagerProvider.getKeyManagers(false), this.sipStack.securityManagerProvider.getTrustManagers(false), null);
        this.sslClientCtx = SSLContext.getInstance("TLS");
        this.sslClientCtx.init(this.sipStack.securityManagerProvider.getKeyManagers(true), this.sipStack.securityManagerProvider.getTrustManagers(true), null);
    }
}

