package test.unit.gov.nist.javax.sip.stack;

import java.io.ByteArrayInputStream;

import gov.nist.javax.sip.stack.WebSocketCodec;
import junit.framework.TestCase;
/**
 * Feed masked websocket frames into the websocket codec to recover from different situations
 * 
 * @author vladimirralev
 *
 */
public class WebsocketPacketFragmentationTest extends TestCase {
	byte [] raw1 = new byte[] {-127};

	byte [] raw2 = new byte[] {-2, 1, };
	
	byte [] raw3 = new byte[] {119, 5, 49, -66, -31};
	
	byte [] raw4 = new byte[] {87, 116, -7, -88, 86, 101, -5, -77, 37, 66, -41, -111, 63, 67, -47, -106, 96, 95, -98, -78, 76, 97, -111, -45, 43, 1, -77, -21, 70, 80, -46, -115, 40, 120, -6, -37, 37, 0, -115, -42, 52, 1, -119, -39, 61, 0, -115, -40, 53, 4, -77, -21, 70, 98, -37, -112, 63, 17, -113, -63, 87, 116, -7, -88, 86, 101, -5, -77, 8, 59, -8, -109, 106, 92, -124, -63, 57, 66, -41, -111, 63, 67, -47, -106, 96, 95, -2, -125, 96, 95, -37, -121, 108, 69, -51, -49, 102, 94, -45, -33, 62, 69, -33, -122, 56, 0, -115, -42, 52, 1, -119, -39, 61, 0, -115, -40, 52, 3, -77, -21, 81, 94, -124, -63, 57, 66, -41, -111, 63, 67, -47, -106, 96, 95, -2, -125, 96, 95, -37, -121, 108, 69, -51, -49, 102, 94, -45, -33, 8, 59, -24, -120, 100, 11, -98, -78, 76, 97, -111, -45, 43, 1, -111, -74, 86, 17, -14, -42, 118, 99, -19, -47, 75, 69, -52, -116, 102, 75, -112, -120, 107, 71, -33, -115, 108, 85, -123, -125, 119, 80, -48, -126, 109, 12, -60, -40, 109, 118, -118, -125, 78, 28, -115, -45, 54, 9, -109, -39, 100, 7, -38, -124, 49, 83, -33, -121, 54, 84, -116, -40, 96, 84, -114, -42, 51, 84, -121, -126, 61, 9, -120, -47, 100, 85, -113, -48, 100, 85, -117, -38, 119, 65, -47, -109, 113, 60, -76, -84, 100, 73, -109, -89, 106, 67, -55, -128, 119, 85, -51, -37, 37, 6, -114, -20, 15, 100, -51, -124, 119, 28, -1, -122, 96, 95, -54, -37, 37, 67, -47, -106, 96, 95, -77, -21, 64, 73, -50, -120, 119, 84, -51, -37, 37, 2, -120, -47, 8, 59, -3, -114, 107, 69, -33, -126, 113, 11, -98, -35, 118, 88, -50, -37, 119, 94, -55, -124, 107, 113, -14, -42, 118, 99, -19, -47, 75, 69, -52, -116, 102, 75, -112, -120, 107, 71, -33, -115, 108, 85, -123, -107, 119, 80, -48, -110, 117, 94, -52, -107, 56, 70, -51, -33, 8, 59, -3, -114, 107, 69, -37, -113, 113, 28, -14, -124, 107, 86, -54, -119, 63, 17, -114, -20, 15, 60, -76,
			
			-127};
	
	byte[] raw5 = new byte[] {-127, -2, 1, -103, 42, 114, 40, -82, 120, 55, 111, -25, 121, 38, 109, -4, 10, 1, 65, -34, 16, 28, 71, -36, 71, 19, 68, -19, 70, 27, 77, -64, 94, 67, 8, -3, 99, 34, 7, -100, 4, 66, 37, -92, 105, 19, 68, -62, 7, 59, 108, -108, 10, 67, 27, -103, 27, 66, 16, -99, 31, 71, 17, -99, 26, 71, 37, -92, 105, 33, 77, -33, 16, 82, 25, -114, 120, 55, 111, -25, 121, 38, 109, -4, 39, 120, 110, -36, 69, 31, 18, -114, 22, 1, 65, -34, 16, 28, 71, -36, 71, 19, 68, -19, 70, 27, 77, -64, 94, 67, 104, -37, 68, 22, 77, -56, 67, 28, 77, -54, 20, 73, 92, -49, 77, 79, 25, -99, 29, 67, 24, -106, 25, 71, 29, -105, 25, 64, 25, -93, 32, 38, 71, -108, 10, 78, 91, -57, 90, 72, 70, -63, 88, 31, 73, -62, 105, 30, 65, -53, 68, 6, 25, -18, 95, 28, 76, -53, 76, 27, 70, -53, 78, 76, 37, -92, 124, 27, 73, -108, 10, 33, 97, -2, 5, 64, 6, -98, 5, 37, 123, -114, 73, 62, 103, -44, 88, 19, 69, -8, 27, 63, 75, -105, 4, 27, 70, -40, 75, 30, 65, -54, 17, 16, 90, -49, 68, 17, 64, -109, 80, 75, 64, -23, 30, 16, 99, -125, 25, 74, 27, -106, 7, 75, 25, -53, 76, 22, 17, -97, 30, 69, 75, -97, 73, 19, 74, -106, 73, 65, 26, -51, 29, 23, 27, -53, 26, 69, 76, -103, 25, 20, 29, -99, 79, 73, 90, -34, 69, 0, 92, -93, 32, 63, 73, -42, 7, 52, 71, -36, 93, 19, 90, -54, 89, 72, 8, -103, 26, 127, 34, -5, 89, 23, 90, -125, 107, 21, 77, -64, 94, 72, 8, -64, 69, 0, 69, -49, 70, 49, 68, -57, 79, 28, 92, -97, 39, 120, 109, -42, 90, 27, 90, -53, 89, 72, 8, -99, 28, 66, 37, -92, 105, 29, 70, -38, 75, 17, 92, -108, 10, 78, 91, -57, 90, 72, 70, -63, 88, 31, 73, -62, 105, 30, 65, -53, 68, 6, 25, -18, 73, 62, 103, -44, 88, 19, 69, -8, 27, 63, 75, -105, 4, 27, 70, -40, 75, 30, 65, -54, 17, 6, 90, -49, 68, 1, 88, -63, 88, 6, 21, -39, 89, 76, 37, -92, 105, 29, 70, -38, 79, 28, 92, -125, 102, 23, 70, -55, 94, 26, 18, -114, 26, 127, 34, -93, 32};
	
	byte[] raw52 = new byte[] {-127, -2, 1, -103, 42, 114, 40, -82, 120, 55, 111, -25, 121, 38, 109, -4, 10, 1, 65, -34, 16, 28, 71, -36, 71, 19, 68, -19, 70, 27, 77, -64, 94, 67, 8, -3, 99, 34, 7, -100, 4, 66, 37, -92, 105, 19, 68, -62, 7, 59, 108, -108, 10, 67, 27, -103, 27, 66, 16, -99, 31, 71, 17, -99, 26, 71, 37, -92, 105, 33, 77, -33, 16, 82, 25, -114, 120, 55, 111, -25, 121, 38, 109, -4, 39, 120, 110, -36, 69, 31, 18, -114, 22, 1, 65, -34, 16, 28, 71, -36, 71, 19, 68, -19, 70, 27, 77, -64, 94, 67, 104, -37, 68, 22, 77, -56, 67, 28, 77, -54, 20, 73, 92, -49, 77, 79, 25, -99, 29, 67, 24, -106, 25, 71, 29, -105, 25, 64, 25, -93, 32, 38, 71, -108, 10, 78, 91, -57, 90, 72, 70, -63, 88, 31, 73, -62, 105, 30, 65, -53, 68, 6, 25, -18, 95, 28, 76, -53, 76, 27, 70, -53, 78, 76, 37, -92, 124, 27, 73, -108, 10, 33, 97, -2, 5, 64, 6, -98, 5, 37, 123, -114, 73, 62, 103, -44, 88, 19, 69, -8, 27, 63, 75, -105, 4, 27, 70, -40, 75, 30, 65, -54, 17, 16, 90, -49, 68, 17, 64, -109, 80, 75, 64, -23, 30, 16, 99, -125, 25, 74, 27, -106, 7, 75, 25, -53, 76, 22, 17, -97, 30, 69, 75, -97, 73, 19, 74, -106, 73, 65, 26, -51, 29, 23, 27, -53, 26, 69, 76, -103, 25, 20, 29, -99, 79, 73, 90, -34, 69, 0, 92, -93, 32, 63, 73, -42, 7, 52, 71, -36, 93, 19, 90, -54, 89, 72, 8, -103, 26, 127, 34, -5, 89, 23, 90, -125, 107, 21, 77, -64, 94, 72, 8, -64, 69, 0, 69, -49, 70, 49, 68, -57, 79, 28, 92, -97, 39, 120, 109, -42, 90, 27, 90, -53, 89, 72, 8, -99, 28, 66, 37, -92, 105, 29, 70, -38, 75, 17, 92, -108, 10, 78, 91, -57, 90, 72, 70, -63, 88, 31, 73, -62, 105, 30, 65, -53, 68, 6, 25, -18, 73, 62, 103, -44, 88, 19, 69, -8, 27, 63, 75, -105, 4, 27, 70, -40, 75, 30, 65, -54, 17, 6, 90, -49, 68, 1, 88, -63, 88, 6, 21, -39, 89, 76, 37, -92, 105, 29, 70, -38, 79, 28, 92, -125, 102, 23, 70, -55, 94, 26, 18, -114, 26, 127, 34, -93, 32,
			-127, -2, 1, -103, 42, 114, 40, -82, 120, 55, 111, -25, 121, 38, 109, -4, 10, 1, 65, -34, 16, 28, 71, -36, 71, 19, 68, -19, 70, 27, 77, -64, 94, 67, 8, -3, 99, 34, 7, -100, 4, 66, 37, -92, 105, 19, 68, -62, 7, 59, 108, -108, 10, 67, 27, -103, 27, 66, 16, -99, 31, 71, 17, -99, 26, 71, 37, -92, 105, 33, 77, -33, 16, 82, 25, -114, 120, 55, 111, -25, 121, 38, 109, -4, 39, 120, 110, -36, 69, 31, 18, -114, 22, 1, 65, -34, 16, 28, 71, -36, 71, 19, 68, -19, 70, 27, 77, -64, 94, 67, 104, -37, 68, 22, 77, -56, 67, 28, 77, -54, 20, 73, 92, -49, 77, 79, 25, -99, 29, 67, 24, -106, 25, 71, 29, -105, 25, 64, 25, -93, 32, 38, 71, -108, 10, 78, 91, -57, 90, 72, 70, -63, 88, 31, 73, -62, 105, 30, 65, -53, 68, 6, 25, -18, 95, 28, 76, -53, 76, 27, 70, -53, 78, 76, 37, -92, 124, 27, 73, -108, 10, 33, 97, -2, 5, 64, 6, -98, 5, 37, 123, -114, 73, 62, 103, -44, 88, 19, 69, -8, 27, 63, 75, -105, 4, 27, 70, -40, 75, 30, 65, -54, 17, 16, 90, -49, 68, 17, 64, -109, 80, 75, 64, -23, 30, 16, 99, -125, 25, 74, 27, -106, 7, 75, 25, -53, 76, 22, 17, -97, 30, 69, 75, -97, 73, 19, 74, -106, 73, 65, 26, -51, 29, 23, 27, -53, 26, 69, 76, -103, 25, 20, 29, -99, 79, 73, 90, -34, 69, 0, 92, -93, 32, 63, 73, -42, 7, 52, 71, -36, 93, 19, 90, -54, 89, 72, 8, -103, 26, 127, 34, -5, 89, 23, 90, -125, 107, 21, 77, -64, 94, 72, 8, -64, 69, 0, 69, -49, 70, 49, 68, -57, 79, 28, 92, -97, 39, 120, 109, -42, 90, 27, 90, -53, 89, 72, 8, -99, 28, 66, 37, -92, 105, 29, 70, -38, 75, 17, 92, -108, 10, 78, 91, -57, 90, 72, 70, -63, 88, 31, 73, -62, 105, 30, 65, -53, 68, 6, 25, -18, 73, 62, 103, -44, 88, 19, 69, -8, 27, 63, 75, -105, 4, 27, 70, -40, 75, 30, 65, -54, 17, 6, 90, -49, 68, 1, 88, -63, 88, 6, 21, -39, 89, 76, 37, -92, 105, 29, 70, -38, 79, 28, 92, -125, 102, 23, 70, -55, 94, 26, 18, -114, 26, 127, 34, -93, 32};
	/**
	 * Edge-case fragmentation of single frame
	 * 
	 * @throws Exception
	 */
	public void testWebsocketCodecFragmentationInAllSectionsWithOverflow() throws Exception {
		ByteArrayInputStream bais1 = new ByteArrayInputStream(raw1);
		ByteArrayInputStream bais2 = new ByteArrayInputStream(raw2);
		ByteArrayInputStream bais3 = new ByteArrayInputStream(raw3);
		ByteArrayInputStream bais4 = new ByteArrayInputStream(raw4);
		ByteArrayInputStream bais5 = new ByteArrayInputStream(raw2);
		ByteArrayInputStream bais6 = new ByteArrayInputStream(raw3);
		ByteArrayInputStream bais7 = new ByteArrayInputStream(raw4);
		WebSocketCodec codec = new WebSocketCodec(true, false);
		assertNull(codec.decode(bais1));
		assertNull(codec.decode(bais2));
		assertNull(codec.decode(bais3));
		String s = new String(codec.decode(bais4));
		System.out.println(s);
		assertNotNull(s);
		assertTrue(s.startsWith("REGISTER"));
		assertNull(codec.decode(bais5));
		assertNull(codec.decode(bais6));
		s = new String(codec.decode(bais7));
		System.out.println(s);
		assertNotNull(s);
		assertTrue(s.startsWith("REGISTER"));
	}
	
	/**
	 * Perfectly aligned frames one after another
	 * @throws Exception
	 */
	public void testByteOverflowMetadata() throws Exception {
		ByteArrayInputStream bais1 = new ByteArrayInputStream(raw5);
		ByteArrayInputStream bais2 = new ByteArrayInputStream(raw5);
		ByteArrayInputStream bais3 = new ByteArrayInputStream(raw5);
		WebSocketCodec codec = new WebSocketCodec(true, false);
		String s = new String(codec.decode(bais1));
		System.out.println(s);
		assertTrue(s.startsWith("REGISTER"));
		s = new String(codec.decode(bais2));
		System.out.println(s);
		s = new String(codec.decode(bais3));
		System.out.println(s);
		assertNotNull(s);
		assertTrue(s.startsWith("REGISTER"));
	}
	/**
	 * Two messages in single frame
	 * @throws Exception
	 */
	public void testMoreThanOneMessageInTheFrame() throws Exception {
		ByteArrayInputStream bais1 = new ByteArrayInputStream(raw52);
		WebSocketCodec codec = new WebSocketCodec(true, false);
		String s = new String(codec.decode(bais1));
		assertNotNull(s);
		assertTrue(s.startsWith("REGISTER"));
		System.out.println(s);
		s = new String(codec.decode(new ByteArrayInputStream(new byte[]{})));
		System.out.println(s);
		assertNotNull(s);
		assertTrue(s.startsWith("REGISTER"));
		
	}
}
