/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.titan.diskstorage.tupl;

import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeySelector;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStore;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.classmethod.titan.diskstorage.tupl.TuplStoreManager;
import jp.classmethod.titan.diskstorage.tupl.TuplStoreTransaction;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuplKeyValueStore
implements OrderedKeyValueStore {
    private static final Logger log = LoggerFactory.getLogger(TuplKeyValueStore.class);
    private final String name;
    private final Index dbindex;
    private final TuplStoreManager manager;

    public TuplKeyValueStore(String name, Index dbindex, TuplStoreManager mgr) {
        this.name = name;
        this.dbindex = dbindex;
        this.manager = mgr;
    }

    public void delete(StaticBuffer key, StoreTransaction txh) throws BackendException {
        TuplStoreTransaction tx = TuplStoreTransaction.getTx(txh);
        try {
            this.dbindex.delete(tx.getTuplTxn(), TuplKeyValueStore.getByteArray(key));
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to delete key " + key, (Throwable)e);
        }
    }

    public StaticBuffer get(StaticBuffer key, StoreTransaction txh) throws BackendException {
        byte[] value;
        TuplStoreTransaction tx = TuplStoreTransaction.getTx(txh);
        try {
            value = this.dbindex.load(tx.getTuplTxn(), TuplKeyValueStore.getByteArray(key));
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to get key" + key, (Throwable)e);
        }
        return TuplKeyValueStore.getBuffer(value);
    }

    public boolean containsKey(StaticBuffer key, StoreTransaction txh) throws BackendException {
        return this.get(key, txh) != null;
    }

    public void acquireLock(StaticBuffer key, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        TuplStoreTransaction tx = TuplStoreTransaction.getTx(txh);
        if (!tx.contains(key)) {
            tx.put(key, expectedValue);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void close() throws BackendException {
        try {
            this.dbindex.close();
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to close store named " + this.name, (Throwable)e);
        }
        this.manager.unregisterStore(this);
    }

    public void insert(StaticBuffer key, StaticBuffer value, StoreTransaction txh) throws BackendException {
        TuplStoreTransaction tx = TuplStoreTransaction.getTx(txh);
        try {
            this.dbindex.store(tx.getTuplTxn(), TuplKeyValueStore.getByteArray(key), TuplKeyValueStore.getByteArray(value));
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to close store named " + this.name, (Throwable)e);
        }
    }

    public RecordIterator<KeyValueEntry> getSlice(KVQuery query, StoreTransaction txh) throws BackendException {
        TuplStoreTransaction tx = TuplStoreTransaction.getTx(txh);
        StaticBuffer start = query.getStart();
        StaticBuffer keyEnd = query.getEnd();
        KeySelector selector = query.getKeySelector();
        final ArrayList<KeyValueEntry> result = new ArrayList<KeyValueEntry>();
        Transaction txn = tx.getTuplTxn();
        Cursor cursor = this.dbindex.viewGe(TuplKeyValueStore.getByteArray(start)).newCursor(txn);
        try {
            StaticBuffer key;
            LockResult status = cursor.first();
            while ((key = TuplKeyValueStore.getBuffer(cursor.key())) != null && key.compareTo((Object)keyEnd) < 0) {
                if (selector.include(key)) {
                    result.add(new KeyValueEntry(key, TuplKeyValueStore.getBuffer(cursor.value())));
                }
                if (selector.reachedLimit()) break;
                status = cursor.next();
            }
            log.trace("db={}, op=getSlice, tx={}, resultcount={}", new Object[]{this.name, txh, result.size()});
            return new RecordIterator<KeyValueEntry>(){
                private final Iterator<KeyValueEntry> entries;
                {
                    this.entries = result.iterator();
                }

                public boolean hasNext() {
                    return this.entries.hasNext();
                }

                public KeyValueEntry next() {
                    return this.entries.next();
                }

                public void close() {
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public Map<KVQuery, RecordIterator<KeyValueEntry>> getSlices(List<KVQuery> queries, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    private static StaticBuffer getBuffer(byte[] entry) {
        return entry == null ? null : StaticArrayBuffer.of((byte[])entry);
    }

    private static byte[] getByteArray(StaticBuffer buffer) {
        return (byte[])buffer.as(StaticBuffer.ARRAY_FACTORY);
    }

    public Index getIndex() {
        return this.dbindex;
    }
}

