/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.titan.diskstorage.tupl;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StoreMetaData;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.MergedConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import com.thinkaurelius.titan.diskstorage.util.DirectoryUtil;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProviders;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jp.classmethod.titan.diskstorage.tupl.TuplKeyValueStore;
import jp.classmethod.titan.diskstorage.tupl.TuplStoreTransaction;
import org.cojen.tupl.Database;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuplStoreManager
extends AbstractStoreManager
implements OrderedKeyValueStoreManager {
    public static final String CANT_OVERRIDE_LOCK_MODE_WITHOUT_TX_OR_WHEN_BATCH_LOADING = "You cannot override the Tupl lock mode when transactions are turned off or you are batch loading. The lock mode will always be UNSAFE.";
    public static final String CANNOT_OVERRIDE_DURABILITY_MODE_WHEN_BATCH_LOADING = "You cannot override the Tupl durability mode when you are batch loading. The durability mode will always be NO_REDO.";
    private static final Logger log = LoggerFactory.getLogger(TuplStoreManager.class);
    public static final ConfigNamespace TUPL_NS = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "tupl", "Configuration for the Tupl Storage Backend for Titan.");
    public static final ConfigNamespace TUPL_LOCK_NS = new ConfigNamespace(TUPL_NS, "lock", "Configuration for the locking aspect of the Tupl Storage Backend for Titan.");
    public static final ConfigNamespace TUPL_CHECKPOINT_NS = new ConfigNamespace(TUPL_NS, "checkpoint", "Configuration for the checkpointing aspect of the Tupl Storage Backend for Titan.");
    public static final ConfigOption<String> TUPL_PREFIX = new ConfigOption(TUPL_NS, "prefix", "The file prefix to use for the database files that correspond to this graph.", ConfigOption.Type.MASKABLE, (Object)"tupldb");
    public static final ConfigOption<Boolean> TUPL_MAP_DATA_FILES = new ConfigOption(TUPL_NS, "map-data-files", "Enable memory mapping of the data files. Entire graph needs to fit in memory.", ConfigOption.Type.MASKABLE, (Object)Boolean.FALSE);
    public static final ConfigOption<Long> TUPL_MIN_CACHE_SIZE = new ConfigOption(TUPL_NS, "min-cache-size", "The tupl minimum cache size (bytes). Must be at least 5 pages long.", ConfigOption.Type.MASKABLE, (Object)100000000L);
    public static final ConfigOption<Long> TUPL_SECONDARY_CACHE_SIZE = new ConfigOption(TUPL_NS, "secondary-cache-size", "The tupl secondary cache size (bytes). Off by default.", ConfigOption.Type.MASKABLE, (Object)0L);
    public static final ConfigOption<String> TUPL_DURABILITY_MODE = new ConfigOption(TUPL_NS, "durability-mode", "Default transaction durability mode.", ConfigOption.Type.MASKABLE, (Object)DurabilityMode.SYNC.name());
    public static final ConfigOption<String> TUPL_LOCK_MODE = new ConfigOption(TUPL_LOCK_NS, "mode", "Default lock mode. READ_UNCOMMITTED is needed to pass most Titan KV and KCV tests.", ConfigOption.Type.MASKABLE, (Object)LockMode.READ_UNCOMMITTED.name());
    public static final ConfigOption<String> TUPL_LOCK_UPGRADE_RULE = new ConfigOption(TUPL_LOCK_NS, "upgrade-rule", "Default lock upgrade rule.", ConfigOption.Type.MASKABLE, (Object)LockUpgradeRule.STRICT.name());
    public static final ConfigOption<Long> TUPL_LOCK_TIMEOUT = new ConfigOption(TUPL_LOCK_NS, "timeout", "The lock timeout (milliseconds).", ConfigOption.Type.MASKABLE, (Object)60000L);
    public static final ConfigOption<Boolean> TUPL_SYNC_WRITES = new ConfigOption(TUPL_NS, "sync-writes", "Set true to ensure all writes to the main database file are immediately durable, although not checkpointed. This option typically reduces overall performance, but checkpoints complete more quickly. As a result, the main database file requires less pre-allocated pages and is smaller.", ConfigOption.Type.MASKABLE, (Object)Boolean.FALSE);
    public static final ConfigOption<Boolean> TUPL_DIRECT_PAGE_ACCESS = new ConfigOption(TUPL_NS, "direct-page-access", "Set true to allocate all pages off the Java heap, offering increased performance and reduced garbage collection activity.", ConfigOption.Type.MASKABLE, (Object)Boolean.TRUE);
    public static final ConfigOption<Integer> TUPL_PAGE_SIZE = new ConfigOption(TUPL_NS, "page-size", "The page size in bytes.", ConfigOption.Type.MASKABLE, (Object)4096);
    public static final ConfigOption<Long> TUPL_CHECKPOINT_RATE = new ConfigOption(TUPL_CHECKPOINT_NS, "rate", "The checkpoint rate in milliseconds. Set to a negative number to disable automatic checkpoints.", ConfigOption.Type.MASKABLE, (Object)1000L);
    public static final ConfigOption<Long> TUPL_CHECKPOINT_DELAY_THRESHOLD = new ConfigOption(TUPL_CHECKPOINT_NS, "delay-threshold", "The checkpoint delay threshold in milliseconds (infinite if negative). This delay takes precedence over the size threshold. Set to zero for non-transactional operations.", ConfigOption.Type.MASKABLE, (Object)60000L);
    public static final ConfigOption<Long> TUPL_CHECKPOINT_SIZE_THRESHOLD = new ConfigOption(TUPL_CHECKPOINT_NS, "size-threshold", "The checkpoint size threshold in bytes. Set to zero for non-transactional operations.", ConfigOption.Type.MASKABLE, (Object)0x40000000L);
    private final Map<String, TuplKeyValueStore> stores;
    private final String prefix;
    private final StoreFeatures features;
    private final DatabaseConfig config;
    private Database database;
    private final File directory;
    private final File prefixFile;
    private final File lockFile;

    public TuplStoreManager(Configuration storageConfig) throws BackendException {
        super(storageConfig);
        boolean persistent;
        this.directory = !storageConfig.has(GraphDatabaseConfiguration.STORAGE_DIRECTORY, new String[0]) ? null : DirectoryUtil.getOrCreateDataDirectory((String)((String)storageConfig.get(GraphDatabaseConfiguration.STORAGE_DIRECTORY, new String[0])));
        boolean bl = persistent = null != this.directory;
        if (persistent) {
            if (!storageConfig.has(TUPL_PREFIX, new String[0])) {
                throw new IllegalArgumentException("if persisting, must provide a db file prefix");
            }
            this.prefix = (String)storageConfig.get(TUPL_PREFIX, new String[0]);
            this.prefixFile = new File(this.directory, this.prefix);
            this.lockFile = new File(this.prefixFile.getAbsolutePath() + ".lock");
        } else {
            this.prefix = null;
            this.prefixFile = null;
            this.lockFile = null;
        }
        boolean mapDataFiles = (Boolean)storageConfig.get(TUPL_MAP_DATA_FILES, new String[0]);
        long minCacheSize = (Long)storageConfig.get(TUPL_MIN_CACHE_SIZE, new String[0]);
        long secondaryCacheSize = (Long)storageConfig.get(TUPL_SECONDARY_CACHE_SIZE, new String[0]);
        DurabilityMode durabilityMode = DurabilityMode.valueOf((String)((String)storageConfig.get(TUPL_DURABILITY_MODE, new String[0])));
        LockUpgradeRule lockUpgradeRule = LockUpgradeRule.STRICT;
        long lockTimeout = (Long)storageConfig.get(TUPL_LOCK_TIMEOUT, new String[0]);
        boolean syncWrites = (Boolean)storageConfig.get(TUPL_SYNC_WRITES, new String[0]);
        int pageSize = (Integer)storageConfig.get(TUPL_PAGE_SIZE, new String[0]);
        boolean directPageAccess = (Boolean)storageConfig.get(TUPL_DIRECT_PAGE_ACCESS, new String[0]);
        long checkpointRate = (Long)storageConfig.get(TUPL_CHECKPOINT_RATE, new String[0]);
        long checkpointDelayThreshold = (Long)storageConfig.get(TUPL_CHECKPOINT_DELAY_THRESHOLD, new String[0]);
        long checkpointSizeThreshold = (Long)storageConfig.get(TUPL_CHECKPOINT_SIZE_THRESHOLD, new String[0]);
        this.features = new TuplStoreFeatures(this.transactional, persistent);
        this.stores = new HashMap<String, TuplKeyValueStore>();
        this.config = new DatabaseConfig().baseFilePath(persistent ? this.prefixFile.getAbsolutePath() : null).mapDataFiles(mapDataFiles).minCacheSize(minCacheSize).secondaryCacheSize(secondaryCacheSize).durabilityMode(durabilityMode).lockUpgradeRule(lockUpgradeRule).lockTimeout(lockTimeout, TimeUnit.MILLISECONDS).syncWrites(syncWrites).pageSize(pageSize).directPageAccess(directPageAccess).checkpointRate(checkpointRate, TimeUnit.MILLISECONDS).checkpointDelayThreshold(checkpointDelayThreshold, TimeUnit.MILLISECONDS).checkpointSizeThreshold(checkpointSizeThreshold);
        try {
            this.database = Database.open((DatabaseConfig)this.config);
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to open the database", (Throwable)e);
        }
    }

    private ModifiableConfiguration buildGraphConfig() {
        return GraphDatabaseConfiguration.buildGraphConfiguration();
    }

    public TuplStoreTransaction beginTransaction(BaseTransactionConfig config) throws BackendException {
        DurabilityMode effectiveDurabilityMode;
        MergedConfiguration effectiveCfg = new MergedConfiguration(config.getCustomOptions(), this.getStorageConfig());
        if (this.batchLoading && effectiveCfg.has(TUPL_DURABILITY_MODE, new String[0])) {
            throw new PermanentBackendException(CANNOT_OVERRIDE_DURABILITY_MODE_WHEN_BATCH_LOADING);
        }
        DurabilityMode durabilityMode = effectiveDurabilityMode = this.batchLoading ? DurabilityMode.NO_REDO : DurabilityMode.valueOf((String)((String)effectiveCfg.get(TUPL_DURABILITY_MODE, new String[0])));
        if ((!this.transactional || this.batchLoading) && effectiveCfg.has(TUPL_LOCK_MODE, new String[0])) {
            throw new PermanentBackendException(CANT_OVERRIDE_LOCK_MODE_WITHOUT_TX_OR_WHEN_BATCH_LOADING);
        }
        LockMode effectiveLockMode = this.transactional && !this.batchLoading ? LockMode.valueOf((String)((String)effectiveCfg.get(TUPL_LOCK_MODE, new String[0]))) : LockMode.UNSAFE;
        Transaction txn = this.database.newTransaction(effectiveDurabilityMode);
        txn.lockMode(effectiveLockMode);
        return new TuplStoreTransaction(config, txn, this.database);
    }

    public void unregisterStore(TuplKeyValueStore db) throws PermanentBackendException {
        if (!this.stores.containsKey(db.getName())) {
            return;
        }
        this.stores.remove(db.getName());
    }

    public void close() throws BackendException {
        try {
            this.database.shutdown();
            if (null != this.lockFile) {
                this.lockFile.delete();
            }
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not close Tupl database", (Throwable)e);
        }
    }

    public void clearStorage() throws BackendException {
        try {
            this.close();
            this.database = Database.destroy((DatabaseConfig)this.config);
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to clear storage", (Throwable)e);
        }
    }

    public StoreFeatures getFeatures() {
        return this.features;
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        throw new UnsupportedOperationException();
    }

    public TuplKeyValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        Index dbindex;
        Preconditions.checkNotNull((Object)name);
        if (this.stores.containsKey(name)) {
            return this.stores.get(name);
        }
        try {
            dbindex = this.database.openIndex(name);
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to open " + name, (Throwable)e);
        }
        TuplKeyValueStore store = new TuplKeyValueStore(name, dbindex, this);
        this.stores.put(name, store);
        return store;
    }

    public TuplKeyValueStore openDatabase(String name) throws BackendException {
        return this.openDatabase(name, null);
    }

    public void mutateMany(Map<String, KVMutation> mutations, StoreTransaction txh) throws BackendException {
        for (Map.Entry<String, KVMutation> muts : mutations.entrySet()) {
            TuplKeyValueStore store = this.openDatabase(muts.getKey());
            KVMutation mut = muts.getValue();
            if (!mut.hasAdditions() && !mut.hasDeletions()) {
                log.debug("Empty mutation set for {}, doing nothing", (Object)muts.getKey());
            } else {
                log.debug("Mutating {}", (Object)muts.getKey());
            }
            if (mut.hasAdditions()) {
                for (KeyValueEntry entry : mut.getAdditions()) {
                    store.insert(entry.getKey(), entry.getValue(), txh);
                    log.trace("Insertion on {}: {}", (Object)muts.getKey(), (Object)entry);
                }
            }
            if (!mut.hasDeletions()) continue;
            for (StaticBuffer del : mut.getDeletions()) {
                store.delete(del, txh);
                log.trace("Deletion on {}: {}", (Object)muts.getKey(), (Object)del);
            }
        }
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " : " + (this.prefixFile == null ? "inmemory" : this.prefixFile.toString() + "*");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public class TuplStoreFeatures
    implements StoreFeatures {
        private final boolean transactional;
        private final boolean persistent;

        public TuplStoreFeatures(boolean transactional, boolean persistent) {
            this.transactional = transactional;
            this.persistent = persistent;
        }

        public boolean hasScan() {
            return true;
        }

        public boolean hasUnorderedScan() {
            return false;
        }

        public boolean hasOrderedScan() {
            return true;
        }

        public boolean hasMultiQuery() {
            return false;
        }

        public boolean hasLocking() {
            return true;
        }

        public boolean hasBatchMutation() {
            return true;
        }

        public boolean isKeyOrdered() {
            return true;
        }

        public boolean isDistributed() {
            return false;
        }

        public boolean hasTxIsolation() {
            return this.transactional;
        }

        public boolean hasLocalKeyPartition() {
            return false;
        }

        public boolean isKeyConsistent() {
            return true;
        }

        public boolean hasTimestamps() {
            return false;
        }

        public TimestampProviders getPreferredTimestamps() {
            return null;
        }

        public boolean hasCellTTL() {
            return false;
        }

        public boolean hasStoreTTL() {
            return false;
        }

        public boolean hasVisibility() {
            return false;
        }

        public boolean supportsPersistence() {
            return this.persistent;
        }

        public Configuration getKeyConsistentTxConfig() {
            return TuplStoreManager.this.buildGraphConfig();
        }

        public Configuration getLocalKeyConsistentTxConfig() {
            return null;
        }

        public Configuration getScanTxConfig() {
            return TuplStoreManager.this.buildGraphConfig().set(TUPL_LOCK_MODE, (Object)LockMode.UNSAFE.name(), new String[0]);
        }

        public boolean supportsInterruption() {
            return false;
        }
    }
}

