/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.titan.diskstorage.tupl;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import java.io.IOException;
import org.cojen.tupl.Database;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TuplStoreTransaction
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(TuplStoreTransaction.class);
    public static final String HEX_PREFIX = "0x";
    private final String id;
    private final Transaction txn;
    private final Database database;

    public TuplStoreTransaction(BaseTransactionConfig config, Transaction txn, Database database) {
        super(config);
        this.txn = txn;
        this.database = database;
        this.id = HEX_PREFIX + Long.toHexString(System.nanoTime());
    }

    public static TuplStoreTransaction getTx(StoreTransaction txh) {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(txh instanceof TuplStoreTransaction), (String)"Unexpected transaction type %s", (Object[])new Object[]{txh.getClass().getName()});
        return (TuplStoreTransaction)txh;
    }

    public String getId() {
        return this.id;
    }

    public Transaction getTuplTxn() {
        return this.txn;
    }

    public boolean contains(StaticBuffer key) {
        return false;
    }

    public void put(StaticBuffer key, StaticBuffer expectedValue) {
    }

    public void commit() throws BackendException {
        log.trace("commit txn={}, id={}", (Object)this.txn, (Object)this.id);
        try {
            this.txn.commit();
            this.txn.exit();
            if (DurabilityMode.NO_REDO == this.txn.durabilityMode()) {
                this.database.checkpoint();
            }
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to commit tx " + this.id, (Throwable)e);
        }
    }

    public void rollback() throws BackendException {
        log.trace("rollback txn={}, id={}", (Object)this.txn, (Object)this.id);
        try {
            this.txn.reset();
        }
        catch (IOException e) {
            throw new PermanentBackendException("unable to commit tx " + this.id, (Throwable)e);
        }
    }
}

