/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.titan.example;

import au.com.bytecode.opencsv.CSVReader;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.util.stats.MetricManager;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarvelGraphFactory {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int BATCH_SIZE = 10;
    private static final Logger LOG = LoggerFactory.getLogger(MarvelGraphFactory.class);
    public static final String APPEARED = "appeared";
    public static final String COMIC_BOOK = "comic-book";
    public static final String CHARACTER = "character";
    public static final String WEAPON = "weapon";
    public static final MetricRegistry REGISTRY = MetricManager.INSTANCE.getRegistry();
    public static final ConsoleReporter REPORTER = ConsoleReporter.forRegistry((MetricRegistry)REGISTRY).build();
    private static final String TIMER_LINE = "MarvelGraphFactory.line";
    private static final String TIMER_CREATE = "MarvelGraphFactory.create_";
    private static final String COUNTER_GET = "MarvelGraphFactory.get_";
    private static final String[] WEAPONS = new String[]{"claws", "ring", "shield", "robotic suit", "cards", "surf board", "glider", "gun", "swords", "lasso"};
    private static final AtomicInteger COMPLETED_TASK_COUNT = new AtomicInteger(0);
    private static final int POOL_SIZE = 10;

    public static void load(TitanGraph graph, int rowsToLoad, boolean report) throws Exception {
        int n;
        Object characterNames;
        TitanManagement mgmt = graph.openManagement();
        if (mgmt.getGraphIndex(CHARACTER) == null) {
            PropertyKey characterKey = mgmt.makePropertyKey(CHARACTER).dataType(String.class).make();
            mgmt.buildIndex(CHARACTER, Vertex.class).addKey(characterKey).unique().buildCompositeIndex();
        }
        if (mgmt.getGraphIndex(COMIC_BOOK) == null) {
            PropertyKey comicBookKey = mgmt.makePropertyKey(COMIC_BOOK).dataType(String.class).make();
            mgmt.buildIndex(COMIC_BOOK, Vertex.class).addKey(comicBookKey).unique().buildCompositeIndex();
            mgmt.makePropertyKey(WEAPON).dataType(String.class).make();
            mgmt.makeEdgeLabel(APPEARED).multiplicity(Multiplicity.MULTI).make();
        }
        mgmt.commit();
        ClassLoader classLoader = MarvelGraphFactory.class.getClassLoader();
        URL resource = classLoader.getResource("META-INF/marvel.csv");
        int line = 0;
        HashMap comicToCharacter = new HashMap();
        HashMap characterToComic = new HashMap();
        HashSet<String> characters = new HashSet<String>();
        LinkedBlockingQueue<Runnable> creationQueue = new LinkedBlockingQueue<Runnable>();
        Throwable throwable = null;
        try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(resource.openStream()));){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null && line < rowsToLoad) {
                ++line;
                String comicBook = nextLine[1];
                characterNames = nextLine[0].split("/");
                if (!comicToCharacter.containsKey(comicBook)) {
                    comicToCharacter.put(comicBook, new HashSet());
                }
                List<String> comicCharacters = Arrays.asList(characterNames);
                ((Set)comicToCharacter.get(comicBook)).addAll(comicCharacters);
                characters.addAll(comicCharacters);
            }
        }
        catch (Throwable nextLine) {
            Throwable throwable2 = nextLine;
            throw nextLine;
        }
        for (String string : characters) {
            creationQueue.add(new CharacterCreationCommand(graph, string));
        }
        LinkedBlockingQueue<Runnable> appearedQueue = new LinkedBlockingQueue<Runnable>();
        for (String comicBook : comicToCharacter.keySet()) {
            creationQueue.add(new ComicBookCreationCommand(graph, comicBook));
            Set comicCharacters = (Set)comicToCharacter.get(comicBook);
            characterNames = comicCharacters.iterator();
            while (characterNames.hasNext()) {
                String character = (String)characterNames.next();
                AppearedCommand lineCommand = new AppearedCommand(graph, new Appeared(character, comicBook));
                appearedQueue.add(lineCommand);
                if (!characterToComic.containsKey(character)) {
                    characterToComic.put(character, new HashSet());
                }
                ((Set)characterToComic.get(character)).add(comicBook);
            }
            REGISTRY.histogram("histogram.comic-to-character").update(comicCharacters.size());
        }
        boolean bl = false;
        String maxCharacter = "";
        for (String character : characterToComic.keySet()) {
            Set comicBookSet = (Set)characterToComic.get(character);
            int numberOfAppearances = comicBookSet.size();
            REGISTRY.histogram("histogram.character-to-comic").update(numberOfAppearances);
            if (numberOfAppearances <= n) continue;
            maxCharacter = character;
            n = numberOfAppearances;
        }
        LOG.info("Character {} has most appearances at {}", (Object)maxCharacter, (Object)n);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            executor.execute(new BatchCommand(graph, creationQueue));
        }
        executor.shutdown();
        while (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
            LOG.info("Awaiting:" + creationQueue.size());
            if (!report) continue;
            REPORTER.report();
        }
        executor = Executors.newSingleThreadExecutor();
        executor.execute(new BatchCommand(graph, appearedQueue));
        executor.shutdown();
        while (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
            LOG.info("Awaiting:" + appearedQueue.size());
            if (!report) continue;
            REPORTER.report();
        }
        LOG.info("MarvelGraphFactory.load complete");
    }

    protected static void processLine(TitanGraph graph, Appeared appeared) {
        long start = System.currentTimeMillis();
        MarvelGraphFactory.process(graph, appeared);
        long end = System.currentTimeMillis();
        long time = end - start;
        REGISTRY.timer(TIMER_LINE).update(time, TimeUnit.MILLISECONDS);
    }

    private static void process(TitanGraph graph, Appeared appeared) {
        Vertex characterVertex;
        Vertex comicBookVertex = MarvelGraphFactory.get(graph, COMIC_BOOK, appeared.getComicBook());
        if (null == comicBookVertex) {
            REGISTRY.counter("error.missingComicBook." + appeared.getComicBook()).inc();
            comicBookVertex = graph.addVertex(new Object[0]);
            comicBookVertex.property(COMIC_BOOK, (Object)appeared.getComicBook());
        }
        if (null == (characterVertex = MarvelGraphFactory.get(graph, CHARACTER, appeared.getCharacter()))) {
            REGISTRY.counter("error.missingCharacter." + appeared.getCharacter()).inc();
            characterVertex = graph.addVertex(new Object[0]);
            characterVertex.property(CHARACTER, (Object)appeared.getCharacter());
            characterVertex.property(WEAPON, (Object)WEAPONS[RANDOM.nextInt(WEAPONS.length)]);
        }
        characterVertex.addEdge(APPEARED, comicBookVertex, new Object[0]);
    }

    private static Vertex get(TitanGraph graph, String key, String value) {
        GraphTraversalSource g = graph.traversal();
        GraphTraversal it = g.V(new Object[0]).has(key, (Object)value);
        return it.hasNext() ? (Vertex)it.next() : null;
    }

    public static class AppearedCommand
    implements Runnable {
        final TitanGraph graph;
        final Appeared appeared;

        public AppearedCommand(TitanGraph graph, Appeared appeared) {
            this.graph = graph;
            this.appeared = appeared;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MarvelGraphFactory.processLine(this.graph, this.appeared);
            }
            catch (Throwable e) {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                String rootCauseMessage = null == rootCause ? "" : rootCause.getMessage();
                LOG.error("Error processing line {} {}", new Object[]{e.getMessage(), rootCauseMessage, e});
            }
            finally {
                COMPLETED_TASK_COUNT.incrementAndGet();
            }
        }
    }

    public static class CharacterCreationCommand
    implements Runnable {
        final String character;
        final TitanGraph graph;

        public CharacterCreationCommand(TitanGraph graph, String character) {
            this.character = character;
            this.graph = graph;
        }

        @Override
        public void run() {
            CharacterCreationCommand.createCharacter(this.graph, this.character);
        }

        private static Vertex createCharacter(TitanGraph graph, String value) {
            long start = System.currentTimeMillis();
            TitanVertex vertex = graph.addVertex(new Object[0]);
            vertex.property(MarvelGraphFactory.CHARACTER, (Object)value);
            vertex.property(MarvelGraphFactory.WEAPON, (Object)WEAPONS[RANDOM.nextInt(WEAPONS.length)]);
            REGISTRY.counter("MarvelGraphFactory.get_character").inc();
            long end = System.currentTimeMillis();
            long time = end - start;
            REGISTRY.timer("MarvelGraphFactory.create_character").update(time, TimeUnit.MILLISECONDS);
            return vertex;
        }
    }

    public static class ComicBookCreationCommand
    implements Runnable {
        final String comicBook;
        final TitanGraph graph;

        public ComicBookCreationCommand(TitanGraph graph, String comicBook) {
            this.comicBook = comicBook;
            this.graph = graph;
        }

        @Override
        public void run() {
            ComicBookCreationCommand.createComicBook(this.graph, this.comicBook);
        }

        private static Vertex createComicBook(TitanGraph graph, String value) {
            long start = System.currentTimeMillis();
            TitanVertex vertex = graph.addVertex(new Object[0]);
            vertex.property(MarvelGraphFactory.COMIC_BOOK, (Object)value);
            REGISTRY.counter("MarvelGraphFactory.get_comic-book").inc();
            long end = System.currentTimeMillis();
            long time = end - start;
            REGISTRY.timer("MarvelGraphFactory.create_comic-book").update(time, TimeUnit.MILLISECONDS);
            return vertex;
        }
    }

    public static class BatchCommand
    implements Runnable {
        final TitanGraph graph;
        final BlockingQueue<Runnable> commands;

        public BatchCommand(TitanGraph graph, BlockingQueue<Runnable> commands) {
            this.commands = commands;
            this.graph = graph;
        }

        @Override
        public void run() {
            int i = 0;
            Runnable command = null;
            while ((command = (Runnable)this.commands.poll()) != null) {
                try {
                    command.run();
                }
                catch (Throwable e) {
                    Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                    String rootCauseMessage = null == rootCause ? "" : rootCause.getMessage();
                    LOG.error("Error processing comic book {} {}", new Object[]{e.getMessage(), rootCauseMessage, e});
                }
                if (i++ % 10 != 0) continue;
                try {
                    this.graph.tx().commit();
                }
                catch (Throwable e) {
                    LOG.error("error processing commit {} {}", (Object)e.getMessage(), (Object)ExceptionUtils.getRootCause((Throwable)e).getMessage());
                }
            }
            try {
                this.graph.tx().commit();
            }
            catch (Throwable e) {
                LOG.error("error processing commit {} {}", (Object)e.getMessage(), (Object)ExceptionUtils.getRootCause((Throwable)e).getMessage());
            }
        }
    }

    public static class Appeared {
        final String character;
        final String comicBook;

        public Appeared(String character, String comicBook) {
            this.character = character;
            this.comicBook = comicBook;
        }

        public String getCharacter() {
            return this.character;
        }

        public String getComicBook() {
            return this.comicBook;
        }
    }
}

