/*
 * Decompiled with CFR 0.152.
 */
package jp.classmethod.titan.example;

import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class TuplTinkerFactory {
    public static final String PETER = "peter";
    public static final String RIPPLE = "ripple";
    public static final String JOSH = "josh";
    public static final String LOP = "lop";
    public static final String VADAS = "vadas";
    public static final String MARKO = "marko";
    public static final String JAVA = "java";
    public static final String LANG = "lang";
    public static final String WEIGHT = "weight";
    public static final String CREATED = "created";
    public static final String KNOWS = "knows";
    public static final String SOFTWARE = "software";
    public static final String PERSON = "person";
    public static final String SKILL = "skill";
    public static final String SINCE = "since";
    public static final String END_TIME = "endTime";
    public static final String START_TIME = "startTime";
    public static final String LOCATION = "location";
    public static final String USES = "uses";
    public static final String DEVELOPS = "develops";
    public static final String AGE = "age";
    public static final String NAME = "name";
    public static final String ID = "id";

    public static Graph createClassic() {
        Graph g = TuplTinkerFactory.openTuplGraph();
        TuplTinkerFactory.generateClassic(g);
        return g;
    }

    private static Graph openTuplGraph() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty("storage.backend", (Object)"jp.classmethod.titan.diskstorage.tupl.TuplStoreManager");
        TitanGraph g = TitanFactory.open((Configuration)conf);
        TitanManagement mgmt = g.openManagement();
        PropertyKey nameKey = mgmt.makePropertyKey(NAME).cardinality(Cardinality.SINGLE).dataType(String.class).make();
        mgmt.buildIndex("nameKeyIndex", Vertex.class).addKey(nameKey).unique().buildCompositeIndex();
        mgmt.commit();
        g.tx().commit();
        return g;
    }

    public static void generateClassic(Graph g) {
        Vertex marko = g.addVertex(new Object[]{ID, 1, NAME, MARKO, AGE, 29});
        Vertex vadas = g.addVertex(new Object[]{ID, 2, NAME, VADAS, AGE, 27});
        Vertex lop = g.addVertex(new Object[]{ID, 3, NAME, LOP, LANG, JAVA});
        Vertex josh = g.addVertex(new Object[]{ID, 4, NAME, JOSH, AGE, 32});
        Vertex ripple = g.addVertex(new Object[]{ID, 5, NAME, RIPPLE, LANG, JAVA});
        Vertex peter = g.addVertex(new Object[]{ID, 6, NAME, PETER, AGE, 35});
        marko.addEdge(KNOWS, vadas, new Object[]{ID, 7, WEIGHT, Float.valueOf(0.5f)});
        marko.addEdge(KNOWS, josh, new Object[]{ID, 8, WEIGHT, Float.valueOf(1.0f)});
        marko.addEdge(CREATED, lop, new Object[]{ID, 9, WEIGHT, Float.valueOf(0.4f)});
        josh.addEdge(CREATED, ripple, new Object[]{ID, 10, WEIGHT, Float.valueOf(1.0f)});
        josh.addEdge(CREATED, lop, new Object[]{ID, 11, WEIGHT, Float.valueOf(0.4f)});
        peter.addEdge(CREATED, lop, new Object[]{ID, 12, WEIGHT, Float.valueOf(0.2f)});
        g.tx().commit();
    }

    public static Graph createModern() {
        Graph g = TuplTinkerFactory.openTuplGraph();
        TuplTinkerFactory.generateModern(g);
        return g;
    }

    public static void generateModern(Graph g) {
        Vertex marko = g.addVertex(new Object[]{ID, 1, T.label, PERSON, NAME, MARKO, AGE, 29});
        Vertex vadas = g.addVertex(new Object[]{ID, 2, T.label, PERSON, NAME, VADAS, AGE, 27});
        Vertex lop = g.addVertex(new Object[]{ID, 3, T.label, SOFTWARE, NAME, LOP, LANG, JAVA});
        Vertex josh = g.addVertex(new Object[]{ID, 4, T.label, PERSON, NAME, JOSH, AGE, 32});
        Vertex ripple = g.addVertex(new Object[]{ID, 5, T.label, SOFTWARE, NAME, RIPPLE, LANG, JAVA});
        Vertex peter = g.addVertex(new Object[]{ID, 6, T.label, PERSON, NAME, PETER, AGE, 35});
        marko.addEdge(KNOWS, vadas, new Object[]{ID, 7, WEIGHT, 0.5});
        marko.addEdge(KNOWS, josh, new Object[]{ID, 8, WEIGHT, 1.0});
        marko.addEdge(CREATED, lop, new Object[]{ID, 9, WEIGHT, 0.4});
        josh.addEdge(CREATED, ripple, new Object[]{ID, 10, WEIGHT, 1.0});
        josh.addEdge(CREATED, lop, new Object[]{ID, 11, WEIGHT, 0.4});
        peter.addEdge(CREATED, lop, new Object[]{ID, 12, WEIGHT, 0.2});
        g.tx().commit();
    }

    public static Graph createBaby() {
        Graph g = TuplTinkerFactory.openTuplGraph();
        TuplTinkerFactory.generateBaby(g);
        return g;
    }

    public static void generateBaby(Graph g) {
        Vertex marko = g.addVertex(new Object[]{ID, 1, T.label, PERSON, NAME, MARKO, AGE, 29});
        Vertex lop = g.addVertex(new Object[]{ID, 3, T.label, SOFTWARE, NAME, LOP, LANG, JAVA});
        marko.addEdge(CREATED, lop, new Object[]{ID, 9, WEIGHT, 0.4});
        g.tx().commit();
    }

    public static Graph createTheCrew() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty("storage.backend", (Object)"jp.classmethod.titan.diskstorage.tupl.TuplStoreManager");
        TitanGraph g = TitanFactory.open((Configuration)conf);
        TitanManagement mgmt = g.openManagement();
        mgmt.makePropertyKey(LOCATION).cardinality(Cardinality.LIST).dataType(String.class).make();
        mgmt.makePropertyKey(START_TIME).cardinality(Cardinality.LIST).dataType(Integer.class).make();
        mgmt.makePropertyKey(END_TIME).cardinality(Cardinality.LIST).dataType(Integer.class).make();
        mgmt.commit();
        g.tx().commit();
        TuplTinkerFactory.generateTheCrew((Graph)g);
        return g;
    }

    public static void generateTheCrew(Graph g) {
        Vertex marko = g.addVertex(new Object[]{ID, 1, T.label, PERSON, NAME, MARKO});
        Vertex stephen = g.addVertex(new Object[]{ID, 7, T.label, PERSON, NAME, "stephen"});
        Vertex matthias = g.addVertex(new Object[]{ID, 8, T.label, PERSON, NAME, "matthias"});
        Vertex daniel = g.addVertex(new Object[]{ID, 9, T.label, PERSON, NAME, "daniel"});
        Vertex gremlin = g.addVertex(new Object[]{ID, 10, T.label, SOFTWARE, NAME, "gremlin"});
        Vertex tinkergraph = g.addVertex(new Object[]{ID, 11, T.label, SOFTWARE, NAME, "tinkergraph"});
        marko.property(VertexProperty.Cardinality.list, LOCATION, (Object)"san diego", new Object[]{START_TIME, 1997, END_TIME, 2001});
        marko.property(VertexProperty.Cardinality.list, LOCATION, (Object)"santa cruz", new Object[]{START_TIME, 2001, END_TIME, 2004});
        marko.property(VertexProperty.Cardinality.list, LOCATION, (Object)"brussels", new Object[]{START_TIME, 2004, END_TIME, 2005});
        marko.property(VertexProperty.Cardinality.list, LOCATION, (Object)"santa fe", new Object[]{START_TIME, 2005});
        stephen.property(VertexProperty.Cardinality.list, LOCATION, (Object)"centreville", new Object[]{START_TIME, 1990, END_TIME, 2000});
        stephen.property(VertexProperty.Cardinality.list, LOCATION, (Object)"dulles", new Object[]{START_TIME, 2000, END_TIME, 2006});
        stephen.property(VertexProperty.Cardinality.list, LOCATION, (Object)"purcellville", new Object[]{START_TIME, 2006});
        matthias.property(VertexProperty.Cardinality.list, LOCATION, (Object)"bremen", new Object[]{START_TIME, 2004, END_TIME, 2007});
        matthias.property(VertexProperty.Cardinality.list, LOCATION, (Object)"baltimore", new Object[]{START_TIME, 2007, END_TIME, 2011});
        matthias.property(VertexProperty.Cardinality.list, LOCATION, (Object)"oakland", new Object[]{START_TIME, 2011, END_TIME, 2014});
        matthias.property(VertexProperty.Cardinality.list, LOCATION, (Object)"seattle", new Object[]{START_TIME, 2014});
        daniel.property(VertexProperty.Cardinality.list, LOCATION, (Object)"spremberg", new Object[]{START_TIME, 1982, END_TIME, 2005});
        daniel.property(VertexProperty.Cardinality.list, LOCATION, (Object)"kaiserslautern", new Object[]{START_TIME, 2005, END_TIME, 2009});
        daniel.property(VertexProperty.Cardinality.list, LOCATION, (Object)"aachen", new Object[]{START_TIME, 2009});
        marko.addEdge(DEVELOPS, gremlin, new Object[]{ID, 13, SINCE, 2009});
        marko.addEdge(DEVELOPS, tinkergraph, new Object[]{ID, 14, SINCE, 2010});
        marko.addEdge(USES, gremlin, new Object[]{ID, 15, SKILL, 4});
        marko.addEdge(USES, tinkergraph, new Object[]{ID, 16, SKILL, 5});
        stephen.addEdge(DEVELOPS, gremlin, new Object[]{ID, 17, SINCE, 2010});
        stephen.addEdge(DEVELOPS, tinkergraph, new Object[]{ID, 18, SINCE, 2011});
        stephen.addEdge(USES, gremlin, new Object[]{ID, 19, SKILL, 5});
        stephen.addEdge(USES, tinkergraph, new Object[]{ID, 20, SKILL, 4});
        matthias.addEdge(DEVELOPS, gremlin, new Object[]{ID, 21, SINCE, 2012});
        matthias.addEdge(USES, gremlin, new Object[]{ID, 22, SKILL, 3});
        matthias.addEdge(USES, tinkergraph, new Object[]{ID, 23, SKILL, 3});
        daniel.addEdge(USES, gremlin, new Object[]{ID, 24, SKILL, 5});
        daniel.addEdge(USES, tinkergraph, new Object[]{ID, 25, SKILL, 3});
        gremlin.addEdge("traverses", tinkergraph, new Object[]{ID, 26});
        g.variables().set("creator", (Object)MARKO);
        g.variables().set("lastModified", (Object)2014);
        g.variables().set("comment", (Object)"this graph was created to provide examples and test coverage for tinkerpop3 api advances");
        g.tx().commit();
    }
}

