/*
 * Copyright (C) 2005-2009 Makoto Sato. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.objectfanatics.assertion.sample;

import jp.objectfanatics.assertion.constraints.NotNull;

public class SampleBean {
	
	private String parameter = null;
	
	/**
	 * 引数が null でないことを保証するアサーションのサンプルメソッド
	 * 
	 * @param param
	 *            null 以外の値
	 * @throws AssertionError
	 *             param が null の場合
	 */
	public void setParameter(@NotNull String param) {
		parameter = param;
	}
	
	/**
	 * 戻り値が null でないことを保証するアサーションのサンプルメソッド
	 * 
	 * @return null 以外の値
	 * @throws AssertionError
	 *             null を戻り値として返そうとした場合
	 */
	@NotNull
	public String getParameter() {
		return parameter;
	}
}
