/*
 * Decompiled with CFR 0.152.
 */
package jp.openstandia.midpoint.grpc;

import com.evolveum.midpoint.gui.api.util.WebComponentUtil;
import com.evolveum.midpoint.model.api.ModelExecuteOptions;
import com.evolveum.midpoint.model.api.ModelInteractionService;
import com.evolveum.midpoint.model.api.ModelService;
import com.evolveum.midpoint.model.api.TaskService;
import com.evolveum.midpoint.model.api.context.ModelContext;
import com.evolveum.midpoint.model.impl.ModelCrudService;
import com.evolveum.midpoint.model.impl.util.ModelImplUtils;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.crypto.EncryptionException;
import com.evolveum.midpoint.prism.crypto.Protector;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.DeltaFactory;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.prism.delta.builder.S_ItemEntry;
import com.evolveum.midpoint.prism.delta.builder.S_MaybeDelete;
import com.evolveum.midpoint.prism.delta.builder.S_ValuesEntry;
import com.evolveum.midpoint.prism.path.ItemPath;
import com.evolveum.midpoint.prism.query.ObjectFilter;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.prism.query.QueryFactory;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.DefinitionProcessingOption;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.GetOperationOptions;
import com.evolveum.midpoint.schema.ObjectDeltaOperation;
import com.evolveum.midpoint.schema.RetrieveOption;
import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.schema.SearchResultList;
import com.evolveum.midpoint.schema.SearchResultMetadata;
import com.evolveum.midpoint.schema.SelectorOptions;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.LocalizationUtil;
import com.evolveum.midpoint.schema.util.ObjectQueryUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.LocalizableMessage;
import com.evolveum.midpoint.util.LocalizableMessageList;
import com.evolveum.midpoint.util.LocalizableMessageListBuilder;
import com.evolveum.midpoint.util.exception.CommonException;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.PolicyViolationException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AbstractRoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.AssignmentHolderType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.EvaluatedPolicyRuleTriggerType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.EvaluatedPolicyRuleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.FocusType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.LocalizableMessageType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.MisfireActionType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OperationBusinessContextType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OrgType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.PartialProcessingOptionsType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.PartialProcessingTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.PasswordType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.PolicyRuleEnforcerHookPreviewOutputType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ScheduleType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ServiceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TaskBindingType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TaskExecutionStatusType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TaskRecurrenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ThreadStopActionType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.UserType;
import com.evolveum.prism.xml.ns._public.query_3.QueryType;
import com.evolveum.prism.xml.ns._public.types_3.EvaluationTimeType;
import com.evolveum.prism.xml.ns._public.types_3.ObjectDeltaType;
import com.evolveum.prism.xml.ns._public.types_3.PolyStringType;
import com.evolveum.prism.xml.ns._public.types_3.ProtectedStringType;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import jp.openstandia.midpoint.grpc.AddObjectRequest;
import jp.openstandia.midpoint.grpc.AddObjectResponse;
import jp.openstandia.midpoint.grpc.AddOrgRequest;
import jp.openstandia.midpoint.grpc.AddRoleRequest;
import jp.openstandia.midpoint.grpc.AddServiceRequest;
import jp.openstandia.midpoint.grpc.AddUserRequest;
import jp.openstandia.midpoint.grpc.AddUserResponse;
import jp.openstandia.midpoint.grpc.AndFilterMessage;
import jp.openstandia.midpoint.grpc.AssignmentMessage;
import jp.openstandia.midpoint.grpc.BuilderWrapper;
import jp.openstandia.midpoint.grpc.DeleteObjectRequest;
import jp.openstandia.midpoint.grpc.DeleteObjectResponse;
import jp.openstandia.midpoint.grpc.FilterInOidMessage;
import jp.openstandia.midpoint.grpc.ForceUpdateCredentialRequest;
import jp.openstandia.midpoint.grpc.GetOrgRequest;
import jp.openstandia.midpoint.grpc.GetOrgResponse;
import jp.openstandia.midpoint.grpc.GetRoleRequest;
import jp.openstandia.midpoint.grpc.GetRoleResponse;
import jp.openstandia.midpoint.grpc.GetSelfAssignmentRequest;
import jp.openstandia.midpoint.grpc.GetSelfAssignmentResponse;
import jp.openstandia.midpoint.grpc.GetSelfRequest;
import jp.openstandia.midpoint.grpc.GetSelfResponse;
import jp.openstandia.midpoint.grpc.GetServiceRequest;
import jp.openstandia.midpoint.grpc.GetServiceResponse;
import jp.openstandia.midpoint.grpc.GetUserRequest;
import jp.openstandia.midpoint.grpc.GetUserResponse;
import jp.openstandia.midpoint.grpc.ItemDeltaMessage;
import jp.openstandia.midpoint.grpc.MidPointGrpcService;
import jp.openstandia.midpoint.grpc.MidPointTaskContext;
import jp.openstandia.midpoint.grpc.ModifyObjectRequest;
import jp.openstandia.midpoint.grpc.ModifyObjectResponse;
import jp.openstandia.midpoint.grpc.ModifyProfileRequest;
import jp.openstandia.midpoint.grpc.ModifyProfileResponse;
import jp.openstandia.midpoint.grpc.ModifyUserRequest;
import jp.openstandia.midpoint.grpc.ModifyUserResponse;
import jp.openstandia.midpoint.grpc.ObjectFilterMessage;
import jp.openstandia.midpoint.grpc.OrgTypeMessage;
import jp.openstandia.midpoint.grpc.PolicyError;
import jp.openstandia.midpoint.grpc.PolyStringMessage;
import jp.openstandia.midpoint.grpc.PrismContainerMessage;
import jp.openstandia.midpoint.grpc.PrismObjectMessage;
import jp.openstandia.midpoint.grpc.QNameMessage;
import jp.openstandia.midpoint.grpc.QueryMessage;
import jp.openstandia.midpoint.grpc.RecomputeObjectRequest;
import jp.openstandia.midpoint.grpc.RecomputeObjectResponse;
import jp.openstandia.midpoint.grpc.ReferenceMessage;
import jp.openstandia.midpoint.grpc.RequestAssignmentsRequest;
import jp.openstandia.midpoint.grpc.RequestAssignmentsResponse;
import jp.openstandia.midpoint.grpc.RoleTypeMessage;
import jp.openstandia.midpoint.grpc.SearchAssignmentsRequest;
import jp.openstandia.midpoint.grpc.SearchObjectsRequest;
import jp.openstandia.midpoint.grpc.SearchObjectsResponse;
import jp.openstandia.midpoint.grpc.SearchOrgsResponse;
import jp.openstandia.midpoint.grpc.SearchRequest;
import jp.openstandia.midpoint.grpc.SearchRolesResponse;
import jp.openstandia.midpoint.grpc.SearchServicesResponse;
import jp.openstandia.midpoint.grpc.SearchUsersResponse;
import jp.openstandia.midpoint.grpc.SelfServiceResourceGrpc;
import jp.openstandia.midpoint.grpc.ServiceTypeMessage;
import jp.openstandia.midpoint.grpc.TypeConverter;
import jp.openstandia.midpoint.grpc.UpdateCredentialRequest;
import jp.openstandia.midpoint.grpc.UpdateCredentialResponse;
import jp.openstandia.midpoint.grpc.UserItemDeltaMessage;
import jp.openstandia.midpoint.grpc.UserTypeMessage;
import org.lognet.springboot.grpc.GRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import shaded.com.google.protobuf.Message;
import shaded.com.google.protobuf.ProtocolStringList;

@GRpcService
public class SelfServiceResource
extends SelfServiceResourceGrpc.SelfServiceResourceImplBase
implements MidPointGrpcService {
    private static final Trace LOGGER = TraceManager.getTrace(SelfServiceResource.class);
    public static final String CLASS_DOT;
    public static final String OPERATION_SELF;
    public static final String OPERATION_SELF_ASSIGNMENT;
    public static final String OPERATION_MODIFY_PROFILE;
    public static final String OPERATION_ADD_USER;
    public static final String OPERATION_MODIFY_USER;
    public static final String OPERATION_GET_USER;
    public static final String OPERATION_ADD_ROLE;
    public static final String OPERATION_GET_ROLE;
    public static final String OPERATION_ADD_ORG;
    public static final String OPERATION_GET_ORG;
    public static final String OPERATION_ADD_SERVICE;
    public static final String OPERATION_GET_SERVICE;
    public static final String OPERATION_RECOMPUTE_OBJECT;
    public static final String OPERATION_EXECUTE_USER_UPDATE;
    public static final String OPERATION_EXECUTE_CREDENTIAL_CHECK;
    public static final String OPERATION_EXECUTE_CREDENTIAL_UPDATE;
    public static final String OPERATION_REQUEST_ASSIGNMENTS;
    public static final String OPERATION_SEARCH_OBJECTS;
    public static final String OPERATION_SEARCH_ASSIGNMENTS;
    public static final String OPERATION_ADD_OBJECT;
    public static final String OPERATION_MODIFY_OBJECT;
    public static final String OPERATION_EXECUTE_OBJECT_UPDATE;
    public static final String OPERATION_DELETE_OBJECT;
    private static final long WAIT_FOR_TASK_STOP = 2000L;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ModelCrudService modelCrudService;
    @Autowired
    protected ModelInteractionService modelInteraction;
    @Autowired
    protected PrismContext prismContext;
    @Autowired
    protected Protector protector;
    @Autowired
    protected TaskService taskService;
    public static final Metadata.Key<PolicyError> PolicyErrorMetadataKey;

    public Metadata handlePolicyViolationException(PolicyViolationException e) {
        PolicyError error = TypeConverter.toPolicyError(e);
        Metadata metadata = new Metadata();
        metadata.put(PolicyErrorMetadataKey, (Object)error);
        return metadata;
    }

    @Override
    public void getSelf(GetSelfRequest request, StreamObserver<GetSelfResponse> responseObserver) {
        LOGGER.debug("Start getSelf");
        UserTypeMessage self = (UserTypeMessage)this.runTask(ctx -> {
            Task task = ctx.task;
            UserType loggedInUser = ctx.principal.getUser();
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_SELF);
            ProtocolStringList options = request.getOptionsList();
            ProtocolStringList include = request.getIncludeList();
            ProtocolStringList exclude = request.getExcludeList();
            ProtocolStringList resolveNames = request.getResolveNamesList();
            Collection getOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, null, (PrismContext)this.prismContext);
            PrismObject user = this.modelCrudService.getObject(UserType.class, loggedInUser.getOid(), getOptions, task, parentResult);
            parentResult.computeStatus();
            return TypeConverter.toUserTypeMessage((UserType)user.asObjectable(), getOptions);
        });
        GetSelfResponse res = GetSelfResponse.newBuilder().setProfile(self).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End getSelf");
    }

    @Override
    public void getSelfAssignment(GetSelfAssignmentRequest request, StreamObserver<GetSelfAssignmentResponse> responseObserver) {
        LOGGER.debug("Start getSelfAssignment");
        List assignments = (List)this.runTask(ctx -> {
            Task task = ctx.task;
            UserType loggedInUser = ctx.principal.getUser();
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_SELF_ASSIGNMENT);
            PrismObject user = this.modelCrudService.getObject(UserType.class, loggedInUser.getOid(), null, task, parentResult);
            UserType userType = (UserType)user.asObjectable();
            Set directOids = userType.getAssignment().stream().map(x -> x.getTargetRef().getOid()).collect(Collectors.toSet());
            Set orgRefOids = Collections.emptySet();
            if (request.getIncludeOrgRefDetail()) {
                orgRefOids = userType.getAssignment().stream().filter(x -> x.getOrgRef() != null).map(x -> x.getOrgRef().getOid()).collect(Collectors.toSet());
            }
            Set indirectOids = Collections.emptySet();
            if (request.getIncludeIndirect()) {
                indirectOids = userType.getRoleMembershipRef().stream().map(x -> x.getOid()).collect(Collectors.toSet());
            }
            HashSet oids = new HashSet();
            oids.addAll(directOids);
            oids.addAll(orgRefOids);
            oids.addAll(indirectOids);
            ObjectQuery query = this.prismContext.queryFor(AbstractRoleType.class).id(oids.toArray(new String[0])).build();
            Collection options = SelectorOptions.createCollection((Object)GetOperationOptions.createExecutionPhase().resolveNames(Boolean.valueOf(true)));
            Map<String, AbstractRoleType> cache = this.modelService.searchObjects(AbstractRoleType.class, query, options, task, parentResult).stream().collect(Collectors.toMap(a -> a.getOid(), a -> (AbstractRoleType)a.asObjectable()));
            HashSet directAssignment = new HashSet();
            List assignmentMessages = userType.getAssignment().stream().filter(x -> cache.containsKey(x.getTargetRef().getOid())).map(x -> {
                AbstractRoleType o = (AbstractRoleType)cache.get(x.getTargetRef().getOid());
                ObjectReferenceType orgRef = x.getOrgRef();
                AbstractRoleType resolvedOrgRef = null;
                if (orgRef != null) {
                    resolvedOrgRef = (AbstractRoleType)cache.get(orgRef.getOid());
                }
                QName type = x.getTargetRef().getType();
                QName relation = x.getTargetRef().getRelation();
                if (request.getIncludeIndirect()) {
                    directAssignment.add(x.getTargetRef().getOid() + "#" + relation.toString());
                }
                return ((AssignmentMessage.Builder)BuilderWrapper.wrap((Object)AssignmentMessage.newBuilder()).nullSafe((Object)TypeConverter.toReferenceMessage(orgRef, resolvedOrgRef), (b, v) -> b.setOrgRef((ReferenceMessage)v)).nullSafe((Object)x.getSubtype(), (b, v) -> b.addAllSubtype((Iterable<String>)v)).unwrap()).setTargetRef(((ReferenceMessage.Builder)BuilderWrapper.wrap((Object)ReferenceMessage.newBuilder()).nullSafe((Object)o.getOid(), (b, v) -> b.setOid((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(o.getName()), (b, v) -> b.setName((PolyStringMessage)v)).nullSafe((Object)TypeConverter.toStringMessage(o.getDescription()), (b, v) -> b.setDescription((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(o.getDisplayName()), (b, v) -> b.setDisplayName((PolyStringMessage)v)).nullSafe(TypeConverter.toReferenceMessageList(o.getArchetypeRef(), cache), (b, v) -> b.addAllArchetypeRef((Iterable<? extends ReferenceMessage>)v)).nullSafe((Object)o.getSubtype(), (b, v) -> b.addAllSubtype((Iterable<String>)v)).unwrap()).setType(QNameMessage.newBuilder().setNamespaceURI(type.getNamespaceURI()).setLocalPart(type.getLocalPart()).setPrefix(type.getPrefix())).setRelation(QNameMessage.newBuilder().setNamespaceURI(relation.getNamespaceURI()).setLocalPart(relation.getLocalPart()).setPrefix(relation.getPrefix())).build()).build();
            }).collect(Collectors.toList());
            if (request.getIncludeIndirect()) {
                List indirect = userType.getRoleMembershipRef().stream().filter(x -> cache.containsKey(x.getOid())).filter(x -> !directAssignment.contains(x.getOid() + "#" + x.getRelation().toString())).map(x -> {
                    AbstractRoleType o = (AbstractRoleType)cache.get(x.getOid());
                    QName type = x.getType();
                    QName relation = x.getRelation();
                    return ((AssignmentMessage.Builder)BuilderWrapper.wrap((Object)AssignmentMessage.newBuilder()).unwrap()).setIndirect(true).setTargetRef(((ReferenceMessage.Builder)BuilderWrapper.wrap((Object)ReferenceMessage.newBuilder()).nullSafe((Object)o.getOid(), (b, v) -> b.setOid((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(o.getName()), (b, v) -> b.setName((PolyStringMessage)v)).nullSafe((Object)TypeConverter.toStringMessage(o.getDescription()), (b, v) -> b.setDescription((String)v)).nullSafe((Object)TypeConverter.toPolyStringMessage(o.getDisplayName()), (b, v) -> b.setDisplayName((PolyStringMessage)v)).nullSafe(TypeConverter.toReferenceMessageList(o.getArchetypeRef(), cache), (b, v) -> b.addAllArchetypeRef((Iterable<? extends ReferenceMessage>)v)).nullSafe((Object)o.getSubtype(), (b, v) -> b.addAllSubtype((Iterable<String>)v)).unwrap()).setType(QNameMessage.newBuilder().setNamespaceURI(type.getNamespaceURI()).setLocalPart(type.getLocalPart()).setPrefix(type.getPrefix())).setRelation(QNameMessage.newBuilder().setNamespaceURI(relation.getNamespaceURI()).setLocalPart(relation.getLocalPart()).setPrefix(relation.getPrefix())).build()).build();
                }).collect(Collectors.toList());
                assignmentMessages.addAll(indirect);
            }
            parentResult.computeStatus();
            return assignmentMessages;
        });
        GetSelfAssignmentResponse res = GetSelfAssignmentResponse.newBuilder().addAllAssignment(assignments).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End getSelfAssignment");
    }

    @Override
    public void modifyProfile(ModifyProfileRequest request, StreamObserver<ModifyProfileResponse> responseObserver) {
        LOGGER.debug("Start modifyProfile");
        this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_MODIFY_PROFILE);
            UserType loggedInUser = ctx.principal.getUser();
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            this.executeChanges(loggedInUser.getOid(), request.getModificationsList(), modelExecuteOptions, task, parentResult);
            parentResult.computeStatus();
            return null;
        });
        ModifyProfileResponse res = ModifyProfileResponse.newBuilder().build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End updateProfile");
    }

    private void executeChanges(String oid, List<UserItemDeltaMessage> userModifications, ModelExecuteOptions modelExecuteOptions, Task task, OperationResult result) throws SchemaException, CommunicationException, ObjectNotFoundException, ObjectAlreadyExistsException, PolicyViolationException, SecurityViolationException, ConfigurationException, ExpressionEvaluationException {
        OperationResult updateResult = result.createSubresult(OPERATION_EXECUTE_USER_UPDATE);
        PrismContainerDefinition definition = this.prismContext.getSchemaRegistry().findContainerDefinitionByCompileTimeClass(UserType.class);
        S_ItemEntry i = this.prismContext.deltaFor(UserType.class);
        for (UserItemDeltaMessage m : userModifications) {
            S_MaybeDelete av;
            QName typeName;
            ItemPath path;
            if (m.hasItemPath()) {
                path = TypeConverter.toItemPathValue(m.getItemPath());
            } else if (m.getPathWrapperCase() == UserItemDeltaMessage.PathWrapperCase.PATH) {
                path = TypeConverter.toItemPath(m.getPath());
            } else if (m.getPathWrapperCase() == UserItemDeltaMessage.PathWrapperCase.USER_TYPE_PATH) {
                path = TypeConverter.toItemName(m.getUserTypePath());
            } else {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_path").asRuntimeException();
                throw exception;
            }
            ItemDefinition itemDef = definition.findItemDefinition(path);
            if (itemDef == null) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_path").asRuntimeException();
                throw exception;
            }
            Class<ProtectedStringType> itemClass = itemDef.getTypeClass();
            if (itemClass == null && (typeName = itemDef.getTypeName()).equals(ProtectedStringType.COMPLEX_TYPE)) {
                itemClass = ProtectedStringType.class;
            }
            S_ValuesEntry v = i.item(path);
            Object entry = null;
            if (!m.getValuesToAddList().isEmpty()) {
                av = v.addRealValues((Collection)TypeConverter.toRealValue((List<String>)m.getValuesToAddList(), itemClass));
                entry = !m.getValuesToDeleteList().isEmpty() ? av.deleteRealValues((Collection)TypeConverter.toRealValue((List<String>)m.getValuesToDeleteList(), itemClass)) : av;
            } else if (!m.getValuesToReplaceList().isEmpty()) {
                entry = v.replaceRealValues((Collection)TypeConverter.toRealValue((List<String>)m.getValuesToReplaceList(), itemClass));
            } else if (!m.getValuesToDeleteList().isEmpty()) {
                entry = v.deleteRealValues((Collection)TypeConverter.toRealValue((List<String>)m.getValuesToDeleteList(), itemClass));
            }
            if (!m.getPrismValuesToAddList().isEmpty()) {
                av = v.add(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToAddList()));
                entry = !m.getPrismValuesToDeleteList().isEmpty() ? av.delete(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToDeleteList())) : av;
            } else if (!m.getPrismValuesToReplaceList().isEmpty()) {
                entry = v.replace(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToReplaceList()));
            } else if (!m.getPrismValuesToDeleteList().isEmpty()) {
                entry = v.delete(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToDeleteList()));
            }
            if (entry == null) {
                LOGGER.warn("Invalid argument. No values for modification.");
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT);
            }
            i = entry;
        }
        List modifications = i.asItemDeltas();
        this.modelCrudService.modifyObject(UserType.class, oid, (Collection)modifications, modelExecuteOptions, task, updateResult);
        updateResult.computeStatus();
    }

    private void executeChanges(Class clazz, String oid, List<ItemDeltaMessage> modifications, ModelExecuteOptions modelExecuteOptions, Task task, OperationResult result) throws SchemaException, CommunicationException, ObjectNotFoundException, ObjectAlreadyExistsException, PolicyViolationException, SecurityViolationException, ConfigurationException, ExpressionEvaluationException {
        OperationResult updateResult = result.createSubresult(OPERATION_EXECUTE_OBJECT_UPDATE);
        PrismContainerDefinition definition = this.prismContext.getSchemaRegistry().findContainerDefinitionByCompileTimeClass(clazz);
        S_ItemEntry i = this.prismContext.deltaFor(clazz);
        for (ItemDeltaMessage m : modifications) {
            ItemPath path;
            if (m.hasItemPath()) {
                path = TypeConverter.toItemPathValue(m.getItemPath());
            } else if (m.getPathWrapperCase() == ItemDeltaMessage.PathWrapperCase.PATH) {
                path = TypeConverter.toItemPath(m.getPath());
            } else {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_path").asRuntimeException();
                throw exception;
            }
            ItemDefinition itemDef = definition.findItemDefinition(path);
            if (itemDef == null) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_path").asRuntimeException();
                throw exception;
            }
            S_ValuesEntry v = i.item(path);
            Object entry = null;
            if (!m.getPrismValuesToAddList().isEmpty()) {
                S_MaybeDelete av = v.add(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToAddList()));
                entry = !m.getPrismValuesToDeleteList().isEmpty() ? av.delete(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToDeleteList())) : av;
            } else if (!m.getPrismValuesToReplaceList().isEmpty()) {
                entry = v.replace(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToReplaceList()));
            } else if (!m.getPrismValuesToDeleteList().isEmpty()) {
                entry = v.delete(TypeConverter.toPrismValueList(this.prismContext, itemDef, m.getPrismValuesToDeleteList()));
            }
            if (entry == null) {
                LOGGER.warn("Invalid argument. No values for modification.");
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT);
            }
            i = entry;
        }
        List mods = i.asItemDeltas();
        this.modelCrudService.modifyObject(definition.getCompileTimeClass(), oid, (Collection)mods, modelExecuteOptions, task, updateResult);
        updateResult.computeStatus();
    }

    @Override
    public void updateCredential(UpdateCredentialRequest request, StreamObserver<UpdateCredentialResponse> responseObserver) {
        LOGGER.debug("Start updateCredential");
        this.runTask(ctx -> {
            this.updateCredential(ctx, request.getOld(), request.getNew(), true);
            return null;
        });
        UpdateCredentialResponse res = UpdateCredentialResponse.newBuilder().build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End updateCredential");
    }

    @Override
    public void forceUpdateCredential(ForceUpdateCredentialRequest request, StreamObserver<UpdateCredentialResponse> responseObserver) {
        LOGGER.debug("Start forceUpdateCredential");
        this.runTask(ctx -> {
            this.updateCredential(ctx, null, request.getNew(), false);
            return null;
        });
        UpdateCredentialResponse res = UpdateCredentialResponse.newBuilder().build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End forceUpdateCredential");
    }

    private void resolveReference(ObjectDelta delta, OperationResult result) {
        try {
            ModelImplUtils.resolveReferences((ObjectDelta)delta, (RepositoryService)this.repositoryService, (boolean)false, (boolean)false, (EvaluationTimeType)EvaluationTimeType.IMPORT, (boolean)true, (PrismContext)this.prismContext, (OperationResult)result);
        }
        catch (SystemException e) {
            StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_reference").asRuntimeException();
            throw exception;
        }
    }

    @Override
    public void requestAssignments(RequestAssignmentsRequest request, StreamObserver<RequestAssignmentsResponse> responseObserver) {
        LOGGER.debug("Start requestAssignments");
        String result = (String)this.runTask(ctx -> {
            Task task = ctx.task;
            UserType loggedInUser = ctx.principal.getUser();
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_REQUEST_ASSIGNMENTS);
            List<PrismContainerValue> assignmentTypes = request.getAssignmentsList().stream().map(x -> TypeConverter.toAssignmentTypeValue(this.prismContext, x).asPrismContainerValue()).collect(Collectors.toList());
            String taskOid = null;
            if (request.getOidsList().size() < 2) {
                String targetOid = request.getOidsList().isEmpty() ? loggedInUser.getOid() : request.getOids(0);
                ObjectDelta delta = this.prismContext.deltaFactory().object().createModificationAddContainer(UserType.class, targetOid, (ItemPath)FocusType.F_ASSIGNMENT, assignmentTypes.toArray(new PrismContainerValue[assignmentTypes.size()]));
                this.resolveReference(delta, parentResult);
                ModelExecuteOptions options = this.createOptions(request.getComment());
                options.setInitialPartialProcessing(new PartialProcessingOptionsType().inbound(PartialProcessingTypeType.SKIP).projection(PartialProcessingTypeType.SKIP));
                this.modelCrudService.modifyObject(UserType.class, delta.getOid(), delta.getModifications(), options, task, parentResult);
            } else {
                LocalizableMessageListBuilder builder = new LocalizableMessageListBuilder();
                for (String oid : request.getOidsList()) {
                    ObjectDelta previewDelta = this.prismContext.deltaFactory().object().createModificationAddContainer(UserType.class, oid, (ItemPath)FocusType.F_ASSIGNMENT, (PrismContainerValue[])assignmentTypes.stream().map(x -> x.clone()).toArray(PrismContainerValue[]::new));
                    this.resolveReference(previewDelta, parentResult);
                    ArrayList<ObjectDelta> previewDeltas = new ArrayList<ObjectDelta>();
                    previewDeltas.add(previewDelta);
                    ModelExecuteOptions options = this.createOptions(request.getComment());
                    options.getOrCreatePartialProcessing().setApprovals(PartialProcessingTypeType.PROCESS);
                    ModelContext previewResult = this.modelInteraction.previewChanges(previewDeltas, options, task, parentResult);
                    PolicyRuleEnforcerHookPreviewOutputType enforcements = (PolicyRuleEnforcerHookPreviewOutputType)previewResult.getHookPreviewResult(PolicyRuleEnforcerHookPreviewOutputType.class);
                    List rule = enforcements.getRule();
                    for (EvaluatedPolicyRuleType r : rule) {
                        for (EvaluatedPolicyRuleTriggerType g : r.getTrigger()) {
                            LocalizableMessage message = LocalizationUtil.toLocalizableMessage((LocalizableMessageType)g.getMessage());
                            builder.addMessage(message);
                        }
                    }
                }
                LocalizableMessage allMessages = builder.separator(LocalizableMessageList.SEMICOLON).buildOptimized();
                if (!allMessages.isEmpty()) {
                    throw new PolicyViolationException(allMessages);
                }
                ObjectDelta delta = this.prismContext.deltaFactory().object().createModificationAddContainer(UserType.class, "fakeOid", (ItemPath)FocusType.F_ASSIGNMENT, (PrismContainerValue[])assignmentTypes.stream().map(x -> x.clone()).toArray(PrismContainerValue[]::new));
                this.resolveReference(delta, parentResult);
                QueryFactory queryFactory = this.prismContext.queryFactory();
                ObjectQuery query = queryFactory.createQuery((ObjectFilter)queryFactory.createInOid((Collection)request.getOidsList()));
                TaskType reqTask = this.createSingleRecurrenceTask(loggedInUser, "Request assignments - " + UUID.randomUUID().toString(), UserType.COMPLEX_TYPE, query, delta, this.createOptions(request.getComment()), "ExecuteChanges");
                taskOid = this.runTask(reqTask, task, parentResult);
            }
            parentResult.computeStatus();
            return taskOid;
        });
        RequestAssignmentsResponse.Builder builder = RequestAssignmentsResponse.newBuilder();
        if (result != null) {
            builder.setTaskOid(result);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
        LOGGER.debug("End requestAssignments");
    }

    protected TaskType createSingleRecurrenceTask(UserType owner, String taskName, QName applicableType, ObjectQuery query, ObjectDelta delta, ModelExecuteOptions options, String category) throws SchemaException {
        TaskType task = new TaskType(this.prismContext);
        ObjectReferenceType ownerRef = new ObjectReferenceType();
        ownerRef.setOid(owner.getOid());
        ownerRef.setType(UserType.COMPLEX_TYPE);
        task.setOwnerRef(ownerRef);
        task.setBinding(TaskBindingType.LOOSE);
        task.setCategory(category);
        task.setExecutionStatus(TaskExecutionStatusType.RUNNABLE);
        task.setRecurrence(TaskRecurrenceType.SINGLE);
        task.setThreadStopAction(ThreadStopActionType.RESTART);
        task.setHandlerUri(this.taskService.getHandlerUriForCategory(category));
        ScheduleType schedule = new ScheduleType();
        schedule.setMisfireAction(MisfireActionType.EXECUTE_IMMEDIATELY);
        task.setSchedule(schedule);
        task.setName(PolyStringType.fromOrig((String)taskName));
        PrismObject prismTask = task.asPrismObject();
        QueryType queryType = this.prismContext.getQueryConverter().createQueryType(query);
        prismTask.findOrCreateProperty(SchemaConstants.PATH_MODEL_EXTENSION_OBJECT_QUERY).addRealValue((Object)queryType);
        if (applicableType != null) {
            prismTask.findOrCreateProperty(SchemaConstants.PATH_MODEL_EXTENSION_OBJECT_TYPE).setRealValue((Object)applicableType);
        }
        if (delta != null) {
            ObjectDeltaType deltaBean = DeltaConvertor.toObjectDeltaType((ObjectDelta)delta);
            prismTask.findOrCreateProperty(SchemaConstants.PATH_MODEL_EXTENSION_OBJECT_DELTA).setRealValue((Object)deltaBean);
        }
        if (options != null) {
            prismTask.findOrCreateProperty(SchemaConstants.PATH_MODEL_EXTENSION_EXECUTE_OPTIONS).setRealValue((Object)options.toModelExecutionOptionsType());
        }
        return task;
    }

    protected String runTask(TaskType taskToRun, Task operationalTask, OperationResult parentResult) {
        try {
            ObjectDelta delta = DeltaFactory.Object.createAddDelta((PrismObject)taskToRun.asPrismObject());
            this.prismContext.adopt(delta);
            Collection results = this.modelService.executeChanges(WebComponentUtil.createDeltaCollection((ObjectDelta[])new ObjectDelta[]{delta}), null, operationalTask, parentResult);
            ObjectDeltaOperation result = (ObjectDeltaOperation)results.iterator().next();
            String taskOid = result.getObjectDelta().getOid();
            parentResult.recordInProgress();
            parentResult.setBackgroundTaskOid(taskOid);
            return taskOid;
        }
        catch (CommonException e) {
            LoggingUtils.logUnexpectedException((Trace)LOGGER, (String)("Couldn't run task " + e.getMessage()), (Throwable)e, (Object[])new Object[0]);
            StatusRuntimeException exception = Status.INTERNAL.withDescription("Couldn't run task " + e.getMessage()).asRuntimeException();
            throw exception;
        }
    }

    private ModelExecuteOptions createOptions(String comment) {
        OperationBusinessContextType businessContextType;
        if (comment != null && !comment.isEmpty()) {
            businessContextType = new OperationBusinessContextType();
            businessContextType.setComment(comment);
        } else {
            businessContextType = null;
        }
        ModelExecuteOptions options = ModelExecuteOptions.fromRestOptions((List)Collections.EMPTY_LIST);
        if (options == null) {
            options = new ModelExecuteOptions();
        }
        options.setRequestBusinessContext(businessContextType);
        return options;
    }

    @Override
    public void addUser(AddUserRequest request, StreamObserver<AddUserResponse> responseObserver) {
        LOGGER.debug("Start addUser");
        String resultOid = (String)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_ADD_USER);
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            UserTypeMessage message = request.getProfile();
            PrismObject<UserType> user = TypeConverter.toPrismObject(this.prismContext, this.repositoryService, message);
            try {
                ModelImplUtils.resolveReferences(user, (RepositoryService)this.repositoryService, (boolean)false, (boolean)false, (EvaluationTimeType)EvaluationTimeType.IMPORT, (boolean)true, (PrismContext)this.prismContext, (OperationResult)parentResult);
            }
            catch (SystemException e) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_reference").asRuntimeException();
                throw exception;
            }
            String oid = this.modelCrudService.addObject(user, modelExecuteOptions, task, parentResult);
            LOGGER.debug("returned oid :  {}", (Object)oid);
            parentResult.computeStatus();
            return oid;
        });
        AddUserResponse.Builder builder = AddUserResponse.newBuilder();
        if (resultOid != null) {
            builder.setOid(resultOid);
        }
        AddUserResponse res = builder.build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End addUser");
    }

    @Override
    public void modifyUser(ModifyUserRequest request, StreamObserver<ModifyUserResponse> responseObserver) {
        LOGGER.debug("Start modifyUser");
        this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_MODIFY_USER);
            String oid = this.resolveOid(UserType.class, request.getOid(), request.getName(), task, parentResult);
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            this.executeChanges(oid, request.getModificationsList(), modelExecuteOptions, task, parentResult);
            parentResult.computeStatus();
            return null;
        });
        ModifyUserResponse res = ModifyUserResponse.newBuilder().build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End modifyUser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCredential(MidPointTaskContext ctx, String oldCred, String newCred, boolean validate) throws SchemaException, SecurityViolationException, CommunicationException, ConfigurationException, ExpressionEvaluationException, ObjectNotFoundException, EncryptionException, PolicyViolationException, ObjectAlreadyExistsException {
        LOGGER.debug("Start updateCredential");
        Task task = ctx.task;
        UserType user = ctx.principal.getUser();
        ProtectedStringType oldPassword = null;
        if (validate) {
            OperationResult checkPasswordResult = task.getResult().createSubresult(OPERATION_EXECUTE_CREDENTIAL_CHECK);
            try {
                oldPassword = new ProtectedStringType();
                oldPassword.setClearValue((Object)oldCred);
                boolean isCorrectPassword = this.modelInteraction.checkPassword(user.getOid(), oldPassword, task, checkPasswordResult);
                if (!isCorrectPassword) {
                    StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_credential").asRuntimeException();
                    throw exception;
                }
                checkPasswordResult.computeStatus();
            }
            finally {
                checkPasswordResult.computeStatusIfUnknown();
            }
        }
        OperationResult updateResult = task.getResult().createSubresult(OPERATION_EXECUTE_CREDENTIAL_UPDATE);
        try {
            ProtectedStringType newProtectedCred = this.protector.encryptString(newCred);
            ItemPath valuePath = ItemPath.create((Object[])new Object[]{SchemaConstantsGenerated.C_CREDENTIALS, CredentialsType.F_PASSWORD, PasswordType.F_VALUE});
            SchemaRegistry registry = this.prismContext.getSchemaRegistry();
            ArrayList<ObjectDelta> deltas = new ArrayList<ObjectDelta>();
            PrismObjectDefinition objDef = registry.findObjectDefinitionByCompileTimeClass(UserType.class);
            PropertyDelta delta = this.prismContext.deltaFactory().property().createModificationReplaceProperty(valuePath, objDef, (Object[])new ProtectedStringType[]{newProtectedCred});
            if (oldPassword != null) {
                delta.addEstimatedOldValue((PrismValue)this.prismContext.itemFactory().createPropertyValue((Object)oldPassword));
            }
            deltas.add(this.prismContext.deltaFactory().object().createModifyDelta(user.getOid(), (ItemDelta)delta, UserType.class));
            this.modelService.executeChanges(deltas, null, task, updateResult);
            updateResult.computeStatus();
        }
        catch (PolicyViolationException e) {
            LoggingUtils.logExceptionAsWarning((Trace)LOGGER, (String)"Couldn't save password changes because of policy violation: {}", (Throwable)e, (Object[])new Object[]{e.getMessage()});
            throw e;
        }
        catch (EncryptionException | ObjectAlreadyExistsException e) {
            LoggingUtils.logUnexpectedException((Trace)LOGGER, (String)"Couldn't save password changes", (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        finally {
            updateResult.computeStatusIfUnknown();
        }
        LOGGER.debug("End updateCredential");
    }

    private <T extends ObjectType> SearchResultList<PrismObject<T>> search(QueryMessage queryMessage, Class<T> clazz, Collection<SelectorOptions<GetOperationOptions>> searchOptions) {
        SearchResultList result = (SearchResultList)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_SEARCH_OBJECTS);
            ObjectQuery query = TypeConverter.toObjectQuery(this.prismContext, clazz, queryMessage);
            Integer total = this.modelService.countObjects(clazz, query, searchOptions, task, parentResult);
            SearchResultList foundObjects = this.modelService.searchObjects(clazz, query, searchOptions, task, parentResult);
            SearchResultMetadata metadata = foundObjects.getMetadata();
            if (metadata == null) {
                metadata = new SearchResultMetadata();
                foundObjects.setMetadata(metadata);
            }
            foundObjects.getMetadata().setApproxNumberOfAllResults(total);
            parentResult.computeStatus();
            return foundObjects;
        });
        return result;
    }

    @Override
    public void searchUsers(SearchRequest request, StreamObserver<SearchUsersResponse> responseObserver) {
        LOGGER.debug("Start searchUsers");
        ProtocolStringList options = request.getOptionsList();
        ProtocolStringList include = request.getIncludeList();
        ProtocolStringList exclude = request.getExcludeList();
        ProtocolStringList resolveNames = request.getResolveNamesList();
        Collection searchOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, (DefinitionProcessingOption)DefinitionProcessingOption.FULL, (PrismContext)this.prismContext);
        SearchResultList<PrismObject<UserType>> result = this.search(request.getQuery(), UserType.class, searchOptions);
        Integer total = result.getMetadata().getApproxNumberOfAllResults();
        List users = result.stream().map(x -> TypeConverter.toUserTypeMessage((UserType)x.asObjectable(), searchOptions)).collect(Collectors.toList());
        SearchUsersResponse res = SearchUsersResponse.newBuilder().setNumberOfAllResults(total).addAllResults(users).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End searchUsers");
    }

    @Override
    public void addRole(AddRoleRequest request, StreamObserver<AddObjectResponse> responseObserver) {
        LOGGER.debug("Start addRole");
        String resultOid = (String)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_ADD_ROLE);
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            RoleTypeMessage message = request.getObject();
            PrismObject<RoleType> object = TypeConverter.toPrismObject(this.prismContext, this.repositoryService, message);
            try {
                ModelImplUtils.resolveReferences(object, (RepositoryService)this.repositoryService, (boolean)false, (boolean)false, (EvaluationTimeType)EvaluationTimeType.IMPORT, (boolean)true, (PrismContext)this.prismContext, (OperationResult)parentResult);
            }
            catch (SystemException e) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_reference").asRuntimeException();
                throw exception;
            }
            String oid = this.modelCrudService.addObject(object, modelExecuteOptions, task, parentResult);
            LOGGER.debug("returned oid :  {}", (Object)oid);
            parentResult.computeStatus();
            return oid;
        });
        AddObjectResponse.Builder builder = AddObjectResponse.newBuilder();
        if (resultOid != null) {
            builder.setOid(resultOid);
        }
        AddObjectResponse res = builder.build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End addRole");
    }

    @Override
    public void getRole(GetRoleRequest request, StreamObserver<GetRoleResponse> responseObserver) {
        LOGGER.debug("Start getRole");
        RoleTypeMessage found = (RoleTypeMessage)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_GET_ROLE);
            String oid = this.resolveOid(UserType.class, request.getOid(), request.getName(), task, parentResult);
            ProtocolStringList options = request.getOptionsList();
            ProtocolStringList include = request.getIncludeList();
            ProtocolStringList exclude = request.getExcludeList();
            ProtocolStringList resolveNames = request.getResolveNamesList();
            Collection getOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, null, (PrismContext)this.prismContext);
            PrismObject object = this.modelCrudService.getObject(RoleType.class, oid, getOptions, task, parentResult);
            parentResult.computeStatus();
            return TypeConverter.toRoleTypeMessage((RoleType)object.asObjectable(), getOptions);
        });
        responseObserver.onNext((Object)GetRoleResponse.newBuilder().setResult(found).build());
        responseObserver.onCompleted();
        LOGGER.debug("End getRole");
    }

    @Override
    public void addOrg(AddOrgRequest request, StreamObserver<AddObjectResponse> responseObserver) {
        LOGGER.debug("Start addOrg");
        String resultOid = (String)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_ADD_ORG);
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            OrgTypeMessage message = request.getObject();
            PrismObject<OrgType> object = TypeConverter.toPrismObject(this.prismContext, this.repositoryService, message);
            try {
                ModelImplUtils.resolveReferences(object, (RepositoryService)this.repositoryService, (boolean)false, (boolean)false, (EvaluationTimeType)EvaluationTimeType.IMPORT, (boolean)true, (PrismContext)this.prismContext, (OperationResult)parentResult);
            }
            catch (SystemException e) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_reference").asRuntimeException();
                throw exception;
            }
            String oid = this.modelCrudService.addObject(object, modelExecuteOptions, task, parentResult);
            LOGGER.debug("returned oid :  {}", (Object)oid);
            parentResult.computeStatus();
            return oid;
        });
        AddObjectResponse.Builder builder = AddObjectResponse.newBuilder();
        if (resultOid != null) {
            builder.setOid(resultOid);
        }
        AddObjectResponse res = builder.build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End addOrg");
    }

    @Override
    public void getOrg(GetOrgRequest request, StreamObserver<GetOrgResponse> responseObserver) {
        LOGGER.debug("Start getOrg");
        OrgTypeMessage found = (OrgTypeMessage)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_GET_ORG);
            String oid = this.resolveOid(UserType.class, request.getOid(), request.getName(), task, parentResult);
            ProtocolStringList options = request.getOptionsList();
            ProtocolStringList include = request.getIncludeList();
            ProtocolStringList exclude = request.getExcludeList();
            ProtocolStringList resolveNames = request.getResolveNamesList();
            Collection getOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, null, (PrismContext)this.prismContext);
            PrismObject object = this.modelCrudService.getObject(OrgType.class, oid, getOptions, task, parentResult);
            parentResult.computeStatus();
            return TypeConverter.toOrgTypeMessage((OrgType)object.asObjectable(), getOptions);
        });
        responseObserver.onNext((Object)GetOrgResponse.newBuilder().setResult(found).build());
        responseObserver.onCompleted();
        LOGGER.debug("End getOrg");
    }

    @Override
    public void addService(AddServiceRequest request, StreamObserver<AddObjectResponse> responseObserver) {
        LOGGER.debug("Start addService");
        String resultOid = (String)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_ADD_SERVICE);
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            ServiceTypeMessage message = request.getObject();
            PrismObject<ServiceType> object = TypeConverter.toPrismObject(this.prismContext, this.repositoryService, message);
            try {
                ModelImplUtils.resolveReferences(object, (RepositoryService)this.repositoryService, (boolean)false, (boolean)false, (EvaluationTimeType)EvaluationTimeType.IMPORT, (boolean)true, (PrismContext)this.prismContext, (OperationResult)parentResult);
            }
            catch (SystemException e) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_reference").asRuntimeException();
                throw exception;
            }
            String oid = this.modelCrudService.addObject(object, modelExecuteOptions, task, parentResult);
            LOGGER.debug("returned oid :  {}", (Object)oid);
            parentResult.computeStatus();
            return oid;
        });
        AddObjectResponse.Builder builder = AddObjectResponse.newBuilder();
        if (resultOid != null) {
            builder.setOid(resultOid);
        }
        AddObjectResponse res = builder.build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End addService");
    }

    @Override
    public void getService(GetServiceRequest request, StreamObserver<GetServiceResponse> responseObserver) {
        LOGGER.debug("Start getService");
        ServiceTypeMessage found = (ServiceTypeMessage)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_GET_SERVICE);
            String oid = this.resolveOid(UserType.class, request.getOid(), request.getName(), task, parentResult);
            ProtocolStringList options = request.getOptionsList();
            ProtocolStringList include = request.getIncludeList();
            ProtocolStringList exclude = request.getExcludeList();
            ProtocolStringList resolveNames = request.getResolveNamesList();
            Collection getOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, null, (PrismContext)this.prismContext);
            PrismObject object = this.modelCrudService.getObject(ServiceType.class, oid, getOptions, task, parentResult);
            parentResult.computeStatus();
            return TypeConverter.toServiceTypeMessage((ServiceType)object.asObjectable(), getOptions);
        });
        responseObserver.onNext((Object)GetServiceResponse.newBuilder().setResult(found).build());
        responseObserver.onCompleted();
        LOGGER.debug("End getService");
    }

    @Override
    public void searchRoles(SearchRequest request, StreamObserver<SearchRolesResponse> responseObserver) {
        LOGGER.debug("Start searchRols");
        ProtocolStringList options = request.getOptionsList();
        ProtocolStringList include = request.getIncludeList();
        ProtocolStringList exclude = request.getExcludeList();
        ProtocolStringList resolveNames = request.getResolveNamesList();
        Collection searchOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, (DefinitionProcessingOption)DefinitionProcessingOption.FULL, (PrismContext)this.prismContext);
        SearchResultList<PrismObject<RoleType>> result = this.search(request.getQuery(), RoleType.class, searchOptions);
        Integer total = result.getMetadata().getApproxNumberOfAllResults();
        List roles = result.stream().map(x -> TypeConverter.toRoleTypeMessage((RoleType)x.asObjectable(), searchOptions)).collect(Collectors.toList());
        SearchRolesResponse res = SearchRolesResponse.newBuilder().setNumberOfAllResults(total).addAllResults(roles).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End searchRols");
    }

    @Override
    public void searchOrgs(SearchRequest request, StreamObserver<SearchOrgsResponse> responseObserver) {
        LOGGER.debug("Start searchOrgs");
        ProtocolStringList options = request.getOptionsList();
        ProtocolStringList include = request.getIncludeList();
        ProtocolStringList exclude = request.getExcludeList();
        ProtocolStringList resolveNames = request.getResolveNamesList();
        Collection searchOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, (DefinitionProcessingOption)DefinitionProcessingOption.FULL, (PrismContext)this.prismContext);
        SearchResultList<PrismObject<OrgType>> result = this.search(request.getQuery(), OrgType.class, searchOptions);
        Integer total = result.getMetadata().getApproxNumberOfAllResults();
        List orgs = result.stream().map(x -> TypeConverter.toOrgTypeMessage((OrgType)x.asObjectable(), searchOptions)).collect(Collectors.toList());
        SearchOrgsResponse res = SearchOrgsResponse.newBuilder().setNumberOfAllResults(total).addAllResults(orgs).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End searchOrgs");
    }

    @Override
    public void searchServices(SearchRequest request, StreamObserver<SearchServicesResponse> responseObserver) {
        LOGGER.debug("Start searchServices");
        ProtocolStringList options = request.getOptionsList();
        ProtocolStringList include = request.getIncludeList();
        ProtocolStringList exclude = request.getExcludeList();
        ProtocolStringList resolveNames = request.getResolveNamesList();
        Collection searchOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, (DefinitionProcessingOption)DefinitionProcessingOption.FULL, (PrismContext)this.prismContext);
        SearchResultList<PrismObject<ServiceType>> result = this.search(request.getQuery(), ServiceType.class, searchOptions);
        Integer total = result.getMetadata().getApproxNumberOfAllResults();
        List services = result.stream().map(x -> TypeConverter.toServiceTypeMessage((ServiceType)x.asObjectable(), searchOptions)).collect(Collectors.toList());
        SearchServicesResponse res = SearchServicesResponse.newBuilder().setNumberOfAllResults(total).addAllResults(services).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End searchServices");
    }

    @Override
    public void searchObjects(SearchObjectsRequest request, StreamObserver<SearchObjectsResponse> responseObserver) {
        Class clazz;
        QName qname;
        LOGGER.debug("Start searchObjects");
        ProtocolStringList options = request.getOptionsList();
        ProtocolStringList include = request.getIncludeList();
        ProtocolStringList exclude = request.getExcludeList();
        ProtocolStringList resolveNames = request.getResolveNamesList();
        Collection searchOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, (DefinitionProcessingOption)DefinitionProcessingOption.FULL, (PrismContext)this.prismContext);
        if (request.hasType()) {
            qname = TypeConverter.toQNameValue(request.getType());
            clazz = ObjectTypes.getObjectTypeClass((QName)qname);
        } else {
            qname = TypeConverter.toQNameValue(request.getObjectType());
            clazz = ObjectTypes.getObjectTypeClass((QName)qname);
        }
        SearchResultList result = this.search(request.getQuery(), clazz, searchOptions);
        boolean hasInclude = this.hasIncludeInSearchOptions(searchOptions);
        Collection finalSearchOptions = searchOptions;
        List itemMessage = result.stream().map(x -> {
            try {
                return TypeConverter.toPrismObjectMessage((ItemDefinition)x.getDefinition(), (PrismObject<? extends ObjectType>)x, finalSearchOptions, hasInclude);
            }
            catch (SchemaException e) {
                LOGGER.error("Failed to convert the object", (Throwable)e);
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_schema").asRuntimeException();
                throw exception;
            }
        }).collect(Collectors.toList());
        Integer total = result.getMetadata().getApproxNumberOfAllResults();
        SearchObjectsResponse res = SearchObjectsResponse.newBuilder().setNumberOfAllResults(total).addAllResults(itemMessage).build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End searchObjects");
    }

    @Override
    public void searchObjectsAsStream(SearchObjectsRequest request, StreamObserver<SearchObjectsResponse> responseObserver) {
        LOGGER.debug("Start searchObjectsAsStream");
        this.runTask(ctx -> {
            Class clazz;
            QName qname;
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_SEARCH_OBJECTS);
            ProtocolStringList options = request.getOptionsList();
            ProtocolStringList include = request.getIncludeList();
            ProtocolStringList exclude = request.getExcludeList();
            ProtocolStringList resolveNames = request.getResolveNamesList();
            Collection searchOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, (DefinitionProcessingOption)DefinitionProcessingOption.FULL, (PrismContext)this.prismContext);
            if (request.hasType()) {
                qname = TypeConverter.toQNameValue(request.getType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            } else {
                qname = TypeConverter.toQNameValue(request.getObjectType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            }
            ObjectQuery query = TypeConverter.toObjectQuery(this.prismContext, clazz, request.getQuery());
            SearchResultMetadata metadata = this.modelService.searchObjectsIterative(clazz, query, (object, pr) -> {
                try {
                    PrismObjectMessage prismObjectMessage = TypeConverter.toPrismObjectMessage((ItemDefinition)object.getDefinition(), (PrismObject<? extends ObjectType>)object);
                    SearchObjectsResponse response = SearchObjectsResponse.newBuilder().setNumberOfAllResults(-1).addResults(prismObjectMessage).build();
                    responseObserver.onNext((Object)response);
                }
                catch (SchemaException e) {
                    LOGGER.error("Failed to convert the object", (Throwable)e);
                    responseObserver.onError((Throwable)e);
                }
                return true;
            }, searchOptions, task, parentResult);
            parentResult.computeStatus();
            return null;
        });
        responseObserver.onCompleted();
        LOGGER.debug("End searchObjectsAsStream");
    }

    @Override
    public void searchAssignments(SearchAssignmentsRequest request, StreamObserver<SearchObjectsResponse> responseObserver) {
        LOGGER.debug("Start searchAssignments");
        this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_SEARCH_ASSIGNMENTS);
            String oid = this.resolveOid(AssignmentHolderType.class, request.getOid(), request.getName(), task, parentResult);
            PrismObject object = this.modelCrudService.getObject(AssignmentHolderType.class, oid, null, task, parentResult);
            AssignmentHolderType objectType = (AssignmentHolderType)object.asObjectable();
            Set directOids = objectType.getAssignment().stream().map(x -> x.getTargetRef().getOid()).collect(Collectors.toSet());
            Set indirectOids = Collections.emptySet();
            if (request.getIncludeIndirect()) {
                indirectOids = objectType.getRoleMembershipRef().stream().map(x -> x.getOid()).collect(Collectors.toSet());
            }
            HashSet<String> oids = new HashSet<String>();
            oids.addAll(directOids);
            oids.addAll(indirectOids);
            ObjectFilterMessage oidFilter = ObjectFilterMessage.newBuilder().setInOid(FilterInOidMessage.newBuilder().addAllValue(oids)).build();
            QueryMessage queryMessage = QueryMessage.newBuilder().setFilter(ObjectFilterMessage.newBuilder().setInOid(FilterInOidMessage.newBuilder().addAllValue(oids))).build();
            Class clazz = null;
            Collection searchOptions = null;
            SearchObjectsRequest search = request.getSearch();
            if (request.hasSearch()) {
                QName qname;
                ProtocolStringList options = search.getOptionsList();
                ProtocolStringList include = search.getIncludeList();
                ProtocolStringList exclude = search.getExcludeList();
                ProtocolStringList resolveNames = search.getResolveNamesList();
                searchOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, (DefinitionProcessingOption)DefinitionProcessingOption.FULL, (PrismContext)this.prismContext);
                if (search.hasType()) {
                    qname = TypeConverter.toQNameValue(search.getType());
                    clazz = ObjectTypes.getObjectTypeClass((QName)qname);
                } else {
                    qname = TypeConverter.toQNameValue(search.getObjectType());
                    clazz = ObjectTypes.getObjectTypeClass((QName)qname);
                }
                if (search.hasQuery()) {
                    ObjectFilterMessage.Builder filter = ObjectFilterMessage.newBuilder().setAnd(AndFilterMessage.newBuilder().addConditions(oidFilter).addConditions(search.getQuery().getFilter()));
                    queryMessage = search.getQuery().toBuilder().setFilter(filter).build();
                }
            }
            if (queryMessage == null) {
                queryMessage = QueryMessage.newBuilder().setFilter(oidFilter).build();
            }
            SearchResultList result = this.search(queryMessage, clazz, searchOptions);
            boolean hasInclude = this.hasIncludeInSearchOptions(searchOptions);
            Collection finalSearchOptions = searchOptions;
            List itemMessage = result.stream().map(x -> {
                try {
                    return TypeConverter.toPrismObjectMessage((ItemDefinition)x.getDefinition(), (PrismObject<? extends ObjectType>)x, finalSearchOptions, hasInclude);
                }
                catch (SchemaException e) {
                    LOGGER.error("Failed to convert the object", (Throwable)e);
                    StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_schema").asRuntimeException();
                    throw exception;
                }
            }).collect(Collectors.toList());
            Integer total = result.getMetadata().getApproxNumberOfAllResults();
            SearchObjectsResponse res = SearchObjectsResponse.newBuilder().setNumberOfAllResults(total).addAllResults(itemMessage).build();
            responseObserver.onNext((Object)res);
            responseObserver.onCompleted();
            return null;
        });
        LOGGER.debug("End searchAssignments");
    }

    private boolean hasIncludeInSearchOptions(Collection<SelectorOptions<GetOperationOptions>> searchOptions) {
        Optional<RetrieveOption> include;
        return searchOptions != null && (include = searchOptions.stream().map(o -> ((GetOperationOptions)o.getOptions()).getRetrieve()).filter(r -> r == RetrieveOption.INCLUDE).findFirst()).isPresent();
    }

    @Override
    public void getUser(GetUserRequest request, StreamObserver<GetUserResponse> responseObserver) {
        LOGGER.debug("Start getUser");
        UserTypeMessage foundUser = (UserTypeMessage)this.runTask(ctx -> {
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_GET_USER);
            String oid = this.resolveOid(UserType.class, request.getOid(), request.getName(), task, parentResult);
            ProtocolStringList options = request.getOptionsList();
            ProtocolStringList include = request.getIncludeList();
            ProtocolStringList exclude = request.getExcludeList();
            ProtocolStringList resolveNames = request.getResolveNamesList();
            Collection getOptions = GetOperationOptions.fromRestOptions((List)options, (List)include, (List)exclude, (List)resolveNames, null, (PrismContext)this.prismContext);
            PrismObject user = this.modelCrudService.getObject(UserType.class, oid, getOptions, task, parentResult);
            parentResult.computeStatus();
            return TypeConverter.toUserTypeMessage((UserType)user.asObjectable(), getOptions);
        });
        responseObserver.onNext((Object)GetUserResponse.newBuilder().setResult(foundUser).build());
        responseObserver.onCompleted();
        LOGGER.debug("End getUser");
    }

    private Collection<SelectorOptions<GetOperationOptions>> getDefaultGetOptionCollection() {
        return SelectorOptions.createCollection((Object)GetOperationOptions.createExecutionPhase());
    }

    @Override
    public void addObject(AddObjectRequest request, StreamObserver<AddObjectResponse> responseObserver) {
        LOGGER.debug("Start addObject");
        String resultOid = (String)this.runTask(ctx -> {
            Class clazz;
            QName qname;
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_ADD_USER);
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            if (request.hasType()) {
                qname = TypeConverter.toQNameValue(request.getType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            } else {
                qname = TypeConverter.toQNameValue(request.getObjectType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            }
            PrismContainerMessage message = request.getObject();
            PrismObject object = TypeConverter.toPrismObject(this.prismContext, clazz, message);
            try {
                ModelImplUtils.resolveReferences((PrismObject)object, (RepositoryService)this.repositoryService, (boolean)false, (boolean)false, (EvaluationTimeType)EvaluationTimeType.IMPORT, (boolean)true, (PrismContext)this.prismContext, (OperationResult)parentResult);
            }
            catch (SystemException e) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_reference").asRuntimeException();
                throw exception;
            }
            String oid = this.modelCrudService.addObject(object, modelExecuteOptions, task, parentResult);
            LOGGER.debug("returned oid :  {}", (Object)oid);
            parentResult.computeStatus();
            return oid;
        });
        AddObjectResponse.Builder builder = AddObjectResponse.newBuilder();
        if (resultOid != null) {
            builder.setOid(resultOid);
        }
        AddObjectResponse res = builder.build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End addObject");
    }

    @Override
    public void modifyObject(ModifyObjectRequest request, StreamObserver<ModifyObjectResponse> responseObserver) {
        LOGGER.debug("Start modifyObject");
        this.runTask(ctx -> {
            Class clazz;
            QName qname;
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_MODIFY_OBJECT);
            if (request.hasType()) {
                qname = TypeConverter.toQNameValue(request.getType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            } else {
                qname = TypeConverter.toQNameValue(request.getObjectType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            }
            String oid = this.resolveOid(clazz, request.getOid(), request.getName(), task, parentResult);
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)request.getOptionsList());
            this.executeChanges(clazz, oid, request.getModificationsList(), modelExecuteOptions, task, parentResult);
            parentResult.computeStatus();
            return null;
        });
        ModifyObjectResponse res = ModifyObjectResponse.newBuilder().build();
        responseObserver.onNext((Object)res);
        responseObserver.onCompleted();
        LOGGER.debug("End modifyObject");
    }

    @Override
    public void deleteObject(DeleteObjectRequest request, StreamObserver<DeleteObjectResponse> responseObserver) {
        LOGGER.debug("Start deleteObject");
        this.runTask(ctx -> {
            Class clazz;
            QName qname;
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_DELETE_OBJECT);
            if (request.hasType()) {
                qname = TypeConverter.toQNameValue(request.getType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            } else {
                qname = TypeConverter.toQNameValue(request.getObjectType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            }
            String oid = this.resolveOid(UserType.class, request.getOid(), request.getName(), task, parentResult);
            ProtocolStringList options = request.getOptionsList();
            if (clazz.isAssignableFrom(TaskType.class)) {
                this.taskService.suspendAndDeleteTask(oid, 2000L, true, task, parentResult);
                parentResult.computeStatus();
                if (parentResult.isSuccess()) {
                    return null;
                }
                StatusRuntimeException exception = Status.INTERNAL.withDescription(parentResult.getMessage()).asRuntimeException();
                throw exception;
            }
            ModelExecuteOptions modelExecuteOptions = ModelExecuteOptions.fromRestOptions((List)options);
            this.modelCrudService.deleteObject(clazz, oid, modelExecuteOptions, task, parentResult);
            parentResult.computeStatus();
            return null;
        });
        responseObserver.onNext((Object)DeleteObjectResponse.newBuilder().build());
        responseObserver.onCompleted();
        LOGGER.debug("End deleteObject");
    }

    @Override
    public void recomputeObject(RecomputeObjectRequest request, StreamObserver<RecomputeObjectResponse> responseObserver) {
        LOGGER.debug("Start recomputeObject");
        this.runTask(ctx -> {
            Class clazz;
            QName qname;
            Task task = ctx.task;
            OperationResult parentResult = task.getResult().createSubresult(OPERATION_RECOMPUTE_OBJECT);
            if (request.hasType()) {
                qname = TypeConverter.toQNameValue(request.getType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            } else {
                qname = TypeConverter.toQNameValue(request.getObjectType());
                clazz = ObjectTypes.getObjectTypeClass((QName)qname);
            }
            if (!FocusType.class.isAssignableFrom(clazz)) {
                StatusRuntimeException exception = Status.INVALID_ARGUMENT.withDescription("invalid_object_type").asRuntimeException();
                throw exception;
            }
            String oid = this.resolveOid(UserType.class, request.getOid(), request.getName(), task, parentResult);
            ModelExecuteOptions options = ModelExecuteOptions.createReconcile();
            ObjectDelta emptyDelta = this.prismContext.deltaFactory().object().createEmptyDelta(clazz, oid, ChangeType.MODIFY);
            this.modelService.executeChanges(Collections.singleton(emptyDelta), options, task, parentResult);
            parentResult.computeStatus();
            return null;
        });
        responseObserver.onNext((Object)RecomputeObjectResponse.newBuilder().build());
        responseObserver.onCompleted();
        LOGGER.debug("End recomputeObject");
    }

    private String resolveOid(Class<? extends ObjectType> clazz, String oid, String name, Task task, OperationResult result) throws SecurityViolationException, ObjectNotFoundException, CommunicationException, ConfigurationException, SchemaException, ExpressionEvaluationException {
        if (oid.isEmpty() && !name.isEmpty()) {
            ObjectType obj = this.searchObjectByName(clazz, name, task, result);
            if (obj == null) {
                throw new ObjectNotFoundException("Not found: " + name);
            }
            oid = obj.getOid();
        }
        return oid;
    }

    private <T extends ObjectType> T searchObjectByName(Class<T> type, String name, Task task, OperationResult result) throws SecurityViolationException, ObjectNotFoundException, CommunicationException, ConfigurationException, SchemaException, ExpressionEvaluationException {
        ObjectQuery nameQuery = ObjectQueryUtil.createNameQuery((String)name, (PrismContext)this.prismContext);
        SearchResultList foundObjects = this.repositoryService.searchObjects(type, nameQuery, null, result);
        if (foundObjects.isEmpty()) {
            return null;
        }
        if (foundObjects.size() > 1) {
            throw new IllegalStateException("More than one object found for type " + type + " and name '" + name + "'");
        }
        return (T)((ObjectType)((PrismObject)foundObjects.iterator().next()).asObjectable());
    }

    static {
        LOGGER.info("SelfServiceResource loaded");
        System.out.println("SelfServiceResource loaded");
        CLASS_DOT = SelfServiceResource.class.getName() + ".";
        OPERATION_SELF = CLASS_DOT + "self";
        OPERATION_SELF_ASSIGNMENT = CLASS_DOT + "selfAssignment";
        OPERATION_MODIFY_PROFILE = CLASS_DOT + "modifyProfile";
        OPERATION_ADD_USER = CLASS_DOT + "addUser";
        OPERATION_MODIFY_USER = CLASS_DOT + "modifyUser";
        OPERATION_GET_USER = CLASS_DOT + "getUser";
        OPERATION_ADD_ROLE = CLASS_DOT + "addRole";
        OPERATION_GET_ROLE = CLASS_DOT + "getRole";
        OPERATION_ADD_ORG = CLASS_DOT + "addOrg";
        OPERATION_GET_ORG = CLASS_DOT + "getOrg";
        OPERATION_ADD_SERVICE = CLASS_DOT + "addService";
        OPERATION_GET_SERVICE = CLASS_DOT + "getService";
        OPERATION_RECOMPUTE_OBJECT = CLASS_DOT + "recomputeObject";
        OPERATION_EXECUTE_USER_UPDATE = CLASS_DOT + "executeUserUpdate";
        OPERATION_EXECUTE_CREDENTIAL_CHECK = CLASS_DOT + "executeCredentialCheck";
        OPERATION_EXECUTE_CREDENTIAL_UPDATE = CLASS_DOT + "executeCredentialUpdate";
        OPERATION_REQUEST_ASSIGNMENTS = CLASS_DOT + "requestAssignments";
        OPERATION_SEARCH_OBJECTS = CLASS_DOT + "searchObjects";
        OPERATION_SEARCH_ASSIGNMENTS = CLASS_DOT + "searchAssignments";
        OPERATION_ADD_OBJECT = CLASS_DOT + "addObject";
        OPERATION_MODIFY_OBJECT = CLASS_DOT + "modifyObject";
        OPERATION_EXECUTE_OBJECT_UPDATE = CLASS_DOT + "executeObjectUpdate";
        OPERATION_DELETE_OBJECT = CLASS_DOT + "deleteObject";
        PolicyErrorMetadataKey = ProtoUtils.keyForProto((Message)PolicyError.getDefaultInstance());
    }
}

